/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cache;

import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;

public class WildCardMatcher {
    private final String[] patterns;
    private final boolean matchAll;
    private final boolean matchNone;
    private static final char MATCH_ALL_CHAR = '*';

    private WildCardMatcher(String[] patterns) {
        this.patterns = patterns;
        if (this.patterns == null || this.patterns.length == 0) {
            this.matchNone = true;
            this.matchAll = false;
        } else {
            this.matchNone = false;
            this.matchAll = this.hasMatchAllPattern(this.patterns);
        }
    }

    private boolean hasMatchAllPattern(String[] patterns) {
        for (String each : patterns) {
            if (!WildCardMatcher.isMatchAllPattern(each)) continue;
            return true;
        }
        return false;
    }

    private static boolean isMatchAllPattern(String pattern) {
        for (char ch : pattern.toCharArray()) {
            if (ch == '*') continue;
            return false;
        }
        return true;
    }

    public static WildCardMatcher create(String[] patterns) {
        return new WildCardMatcher(patterns);
    }

    public boolean isMatchAll() {
        return this.matchAll;
    }

    public boolean isMatchNone() {
        return this.matchNone;
    }

    public boolean isMatch(String string) {
        if (this.matchNone) {
            return false;
        }
        if (this.matchAll) {
            return true;
        }
        for (String pattern : this.patterns) {
            if (!this.isPatternMatch(pattern, string)) continue;
            return true;
        }
        return false;
    }

    private boolean isPatternMatch(String pattern, String string) {
        return FilenameUtils.wildcardMatch((String)string, (String)pattern, (IOCase)IOCase.INSENSITIVE);
    }
}

