/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cache.ehcache;

import kd.bos.cache.EhcacheStoreType;
import kd.bos.cache.ehcache.BuilderConfig;
import kd.bos.cache.ehcache.CacheBuilderStrategy;
import kd.bos.cache.ehcache.EhcacheFactory;
import org.ehcache.CacheManager;
import org.ehcache.config.Builder;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.ehcache.config.units.MemoryUnit;

class CacheDiskStrategy
extends CacheBuilderStrategy {
    String region;
    int maxHeapSize;
    EhcacheStoreType storeType;

    CacheDiskStrategy(String region, BuilderConfig config) {
        this.region = region;
        this.maxHeapSize = config.maxMemSize;
        this.storeType = config.storeType;
    }

    @Override
    CacheManager createCacheManager() {
        return EhcacheFactory.getCacheManager(this.region, this.storeType);
    }

    @Override
    <K, V> CacheConfigurationBuilder<K, V> createCacheConfigurationBuilder() {
        ResourcePoolsBuilder builder = ResourcePoolsBuilder.newResourcePoolsBuilder().disk((long)this.maxHeapSize, MemoryUnit.MB);
        return CacheConfigurationBuilder.newCacheConfigurationBuilder(String.class, String.class, (Builder)builder);
    }
}

