/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cache.ehcache;

import kd.bos.cache.ehcache.BuilderConfig;
import kd.bos.cache.ehcache.CacheBuilderStrategy;
import kd.bos.cache.ehcache.EhcacheFactory;
import org.ehcache.CacheManager;
import org.ehcache.config.Builder;
import org.ehcache.config.ResourceUnit;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.ehcache.config.units.MemoryUnit;

class CacheMemorySizeStrategy
extends CacheBuilderStrategy {
    private String region;
    private int maxMemSize;

    CacheMemorySizeStrategy(String region, BuilderConfig config) {
        this.region = region;
        this.maxMemSize = config.maxMemSize;
    }

    @Override
    CacheManager createCacheManager() {
        return EhcacheFactory.getCacheManager();
    }

    CacheConfigurationBuilder<String, Object> createCacheConfigurationBuilder() {
        ResourcePoolsBuilder builder = ResourcePoolsBuilder.newResourcePoolsBuilder().heap((long)this.maxMemSize, (ResourceUnit)MemoryUnit.MB);
        return CacheConfigurationBuilder.newCacheConfigurationBuilder(String.class, Object.class, (Builder)builder);
    }
}

