/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cache.ehcache;

import java.io.File;
import kd.bos.cache.EhcacheStoreType;
import org.ehcache.CacheManager;
import org.ehcache.config.builders.CacheManagerBuilder;

public class EhcacheFactory {
    public static CacheManager getCacheManager() {
        CacheManager cacheManager = CacheManagerBuilder.newCacheManagerBuilder().withDefaultSizeOfMaxObjectGraph(Integer.MAX_VALUE).build(false);
        cacheManager.init();
        return cacheManager;
    }

    static CacheManager getCacheManager(String region, EhcacheStoreType storeType) {
        CacheManager cacheManager;
        if (region != null && (storeType.getCode() & 4) == 4) {
            String rootDir = System.getProperty("ehcache.diskstore.path");
            if (rootDir == null) {
                rootDir = System.getProperty("user.dir");
            }
            cacheManager = CacheManagerBuilder.newCacheManagerBuilder().withDefaultSizeOfMaxObjectGraph(Integer.MAX_VALUE).with(CacheManagerBuilder.persistence((String)(rootDir + File.separator + region + File.separator + (Object)((Object)storeType)))).build(false);
        } else {
            cacheManager = CacheManagerBuilder.newCacheManagerBuilder().withDefaultSizeOfMaxObjectGraph(Integer.MAX_VALUE).build(false);
        }
        cacheManager.init();
        return cacheManager;
    }
}

