/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cache.ehcache;

import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.cache.LocalSessionableCache;
import kd.bos.cache.ehcache.EhcacheFactory;
import org.ehcache.Cache;
import org.ehcache.CacheManager;
import org.ehcache.config.Builder;
import org.ehcache.config.ResourceUnit;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.ExpiryPolicyBuilder;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.ehcache.config.units.MemoryUnit;

public class EhcacheSessionableCache
implements LocalSessionableCache {
    private Map<String, Cache<String, Object>> cacheMap = new ConcurrentHashMap<String, Cache<String, Object>>();

    private Cache<String, Object> getCache(String sessionId) {
        String region = sessionId;
        return this.cacheMap.computeIfAbsent(region, key -> this.newCache((String)key));
    }

    private Cache<String, Object> newCache(String sessionId) {
        CacheManager manager = EhcacheFactory.getCacheManager();
        Cache cache = manager.createCache(sessionId, CacheConfigurationBuilder.newCacheConfigurationBuilder(String.class, Object.class, (Builder)ResourcePoolsBuilder.newResourcePoolsBuilder().heap(100L, (ResourceUnit)MemoryUnit.MB)).withExpiry(ExpiryPolicyBuilder.timeToIdleExpiration((Duration)Duration.ofSeconds(36000L))).build());
        return cache;
    }

    @Override
    public void put(String sessionId, String key, Object value) {
        this.getCache(sessionId).put((Object)key, value);
    }

    @Override
    public Object get(String sessionId, String key) {
        return this.getCache(sessionId).get((Object)key);
    }

    @Override
    public void remove(String sessionId, String key) {
        this.getCache(sessionId).remove((Object)key);
    }

    @Override
    public boolean contains(String sessionId, String key) {
        return this.getCache(sessionId).containsKey((Object)key);
    }

    @Override
    public void remove(String sessionId) {
        CacheManager manager = EhcacheFactory.getCacheManager();
        manager.removeCache(sessionId);
        this.cacheMap.remove(sessionId);
    }

    @Override
    public Map<String, Object> getAll(String sessionId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Cache.Entry entry : this.getCache(sessionId)) {
            map.put((String)entry.getKey(), entry.getValue());
        }
        return map;
    }

    @Override
    public List<Object> get(String sessionId, String[] keys) {
        Cache<String, Object> cache = this.getCache(sessionId);
        ArrayList<Object> result = new ArrayList<Object>(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            result.add(cache.get((Object)keys[i]));
        }
        return result;
    }

    @Override
    public void expireAfter(String sessionId, int second) {
        throw new RuntimeException("Not implemented.");
    }

    @Override
    public void put(String sessionId, Map<String, Object> map) {
        Cache<String, Object> cache = this.getCache(sessionId);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            cache.put((Object)entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void remove(String sessionId, String[] keys) {
        Cache<String, Object> cache = this.getCache(sessionId);
        for (String key : keys) {
            cache.remove((Object)key);
        }
    }

    @Override
    public List<String> getKeys(String sessionId) {
        ArrayList<String> list = new ArrayList<String>(4);
        Cache<String, Object> cache = this.getCache(sessionId);
        for (Cache.Entry entry : cache) {
            list.add((String)entry.getKey());
        }
        return list;
    }

    @Override
    public List<String> getKeysWithPrefix(String sessionId, String prefix) {
        ArrayList<String> list = new ArrayList<String>(4);
        Cache<String, Object> cache = this.getCache(sessionId);
        for (Cache.Entry entry : cache) {
            String key = (String)entry.getKey();
            if (!key.startsWith(prefix)) continue;
            list.add((String)entry.getKey());
        }
        return list;
    }
}

