/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cache.ehcache.config;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.concurrent.locks.LockSupport;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import kd.bos.cache.ehcache.config.RegionDef;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;

@XmlRootElement(name="root")
public class CacheConfig {
    private static Log log = LogFactory.getLog(CacheConfig.class);
    public static final String CACHE_CONFIG_IN_JVM = "bos.jvmcache.config";
    private List<RegionDef> regions;

    @XmlElements(value={@XmlElement(name="region", type=RegionDef.class)})
    public List<RegionDef> getRegions() {
        return this.regions;
    }

    public void setRegions(List<RegionDef> regions) {
        this.regions = regions;
    }

    public static CacheConfig get() {
        String xml = System.getProperty(CACHE_CONFIG_IN_JVM);
        if (xml != null && xml.length() > 0) {
            try {
                return CacheConfig.parse(xml);
            }
            catch (Exception e) {
                log.warn("parse jvmcache config error from System.getProperty");
            }
        }
        try (InputStream in = CacheConfig.class.getResourceAsStream("/kd/bos/cache/ehcache/CacheConfig.xml");){
            xml = StringUtils.fromInputStream((InputStream)in, (String)"UTF-8");
        }
        catch (IOException e) {
            log.error("Can't load /kd/bos/cache/CacheConfig.xml, Starting to exit the service\uff1a", (Throwable)e);
            LockSupport.parkNanos(1000000000L);
            System.exit(-1);
        }
        if (xml == null) {
            return null;
        }
        return CacheConfig.parse(xml);
    }

    private static CacheConfig parse(String xml) {
        return CacheConfig.parse(new StringReader(xml));
    }

    private static CacheConfig parse(Reader reader) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{CacheConfig.class});
            XMLInputFactory xif = XMLInputFactory.newFactory();
            xif.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
            xif.setProperty("javax.xml.stream.supportDTD", true);
            XMLStreamReader xsr = xif.createXMLStreamReader(reader);
            Unmarshaller un = jaxbContext.createUnmarshaller();
            CacheConfig usageConfig = (CacheConfig)un.unmarshal(xsr);
            return usageConfig;
        }
        catch (Exception t) {
            throw new KDException(BosErrorCode.mqServerConfiguration, "cache usage config parse error", (Throwable)t);
        }
    }
}

