/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cache.ehcache.syncstatus;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import kd.bos.cache.CacheConfigKeys;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.cache.ehcache.EhcacheMemoryCacheClusterNotify;
import kd.bos.cache.ehcache.syncstatus.BalesBroadcastInfo;
import kd.bos.config.client.util.JSONUtils;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.redis.JedisClient;
import kd.bos.redis.RedisFactory;

public class MemoryCacheSyncStatusMange {
    private static Log logger = LogFactory.getLog(MemoryCacheSyncStatusMange.class);
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();
    private static final String UIDKEYPRE = "Broadcast_uid_" + Instance.getClusterName() + "_";
    private static final String UIDKEY = UIDKEYPRE + Instance.getInstanceId();
    private static final String MSGKEYPRE = "Broadcast_msg_" + Instance.getClusterName() + "_";
    private static final int QUEUE_MAX_IN_STORE = 2000;
    private static Map<String, AtomicLong> lastestConsumeUids = new ConcurrentHashMap<String, AtomicLong>(8);

    public static long getUid() {
        if (MemoryCacheSyncStatusMange.isBroadcastReliable()) {
            return cache.inc(UIDKEY, 3600);
        }
        return 0L;
    }

    private static boolean isBroadcastReliable() {
        return Boolean.getBoolean("broadcast.reliable.enable");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void recordReceiveStatus(BalesBroadcastInfo items) {
        if (!MemoryCacheSyncStatusMange.isBroadcastReliable()) {
            return;
        }
        String sourceInstanceId = items.getInstanceId();
        AtomicLong lastestConsumerUID = lastestConsumeUids.computeIfAbsent(sourceInstanceId, k -> new AtomicLong(0L));
        long curConsumerUID = items.getUid();
        long lastConsumerUID = lastestConsumerUID.get();
        if (lastConsumerUID < curConsumerUID - 1L) {
            logger.info("broad cast from instance ," + sourceInstanceId + "lastConsumerUID:" + lastConsumerUID + ",curConsumerUID:" + curConsumerUID);
            String consumerUIDKey = MemoryCacheSyncStatusMange.getUIDyKey(sourceInstanceId);
            String consumermsgKey = MemoryCacheSyncStatusMange.getMsgQueueKey(sourceInstanceId);
            try (JedisClient jedis = MemoryCacheSyncStatusMange.createJedisClient();){
                String s = jedis.get(consumerUIDKey);
                if (s == null) return;
                long consumerMaxUID = Long.parseLong(s);
                long fetchIndex = consumerMaxUID - lastConsumerUID;
                List pairs = jedis.lrange(consumermsgKey, 0L, fetchIndex);
                long fetchMax = 0L;
                long fetchMin = Long.MAX_VALUE;
                for (String pair : pairs) {
                    try {
                        BalesBroadcastInfo bases = (BalesBroadcastInfo)JSONUtils.cast((String)pair, BalesBroadcastInfo.class);
                        EhcacheMemoryCacheClusterNotify.invokeSyncMethods(bases.getLs());
                        long uid = bases.getUid();
                        if (uid > fetchMax) {
                            fetchMax = uid;
                        }
                        if (uid >= fetchMin) continue;
                        fetchMin = uid;
                    }
                    catch (IOException e) {
                        logger.error("invokexSyncMethods error", (Throwable)e);
                    }
                }
                int step = 1;
                while (fetchMin > lastConsumerUID + 1L && !(pairs = jedis.lrange(consumermsgKey, fetchIndex + (long)step++, fetchIndex + (long)(++step))).isEmpty()) {
                    for (String pair : pairs) {
                        try {
                            BalesBroadcastInfo bases = (BalesBroadcastInfo)JSONUtils.cast((String)pair, BalesBroadcastInfo.class);
                            EhcacheMemoryCacheClusterNotify.invokeSyncMethods(bases.getLs());
                            long uid = bases.getUid();
                            if (uid >= fetchMin) continue;
                            fetchMin = uid;
                        }
                        catch (IOException e) {
                            logger.error("invokexSyncMethods error", (Throwable)e);
                        }
                    }
                }
                if (fetchMax <= 0L) return;
                lastestConsumerUID.set(fetchMax);
                return;
            }
        } else {
            if (lastConsumerUID != curConsumerUID - 1L) return;
            lastestConsumerUID.set(curConsumerUID);
        }
    }

    public static void recordSendStatus(BalesBroadcastInfo cbitem) {
        if (!MemoryCacheSyncStatusMange.isBroadcastReliable()) {
            return;
        }
        try (JedisClient jedis = MemoryCacheSyncStatusMange.createJedisClient();){
            try {
                String msgQueuekey = MemoryCacheSyncStatusMange.getMsgQueueKey(Instance.getInstanceId());
                long size = jedis.lpush(msgQueuekey, new String[]{JSONUtils.toString((Object)cbitem)});
                jedis.expire(msgQueuekey, 3600);
                if ((double)size > 2200.0) {
                    jedis.ltrim(msgQueuekey, 0L, 2000L);
                }
            }
            catch (Exception e) {
                logger.error("recordSendStatus error", (Throwable)e);
            }
        }
    }

    private static String getMsgQueueKey(String instanceid) {
        return MSGKEYPRE + instanceid;
    }

    private static String getUIDyKey(String instanceid) {
        return UIDKEYPRE + instanceid;
    }

    private static JedisClient createJedisClient() {
        return RedisFactory.getJedisClient((String)MemoryCacheSyncStatusMange.getRedisUrl());
    }

    private static String getRedisUrl() {
        String url = null;
        String useRegion = "broadcast";
        String configKey = CacheConfigKeys.getSessionlessConfigKey(useRegion);
        url = System.getProperty(configKey);
        if (url == null) {
            configKey = CacheConfigKeys.getSessionlessConfigKey(null);
            url = System.getProperty(configKey);
        }
        return url;
    }
}

