/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cache.redis;

import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kd.bos.cache.Cacheable;
import kd.bos.cache.redis.JedisClientWrapper;
import kd.bos.cache.redis.Pair;
import kd.bos.cache.redis.RedisExceptionHelper;
import kd.bos.cache.redis.RedisMode;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.redis.JedisClient;
import redis.clients.jedis.exceptions.JedisConnectionException;

public abstract class AbstractRedisSessionCache
implements Cacheable {
    private static final Set<String> LISTENED_URL_SET = new CopyOnWriteArraySet<String>();
    private JedisClientWrapper jedisClientWrapper = null;
    private ReentrantReadWriteLock rwlock = new ReentrantReadWriteLock();
    private ReentrantReadWriteLock.ReadLock rlock = this.rwlock.readLock();
    private ReentrantReadWriteLock.WriteLock wlock = this.rwlock.writeLock();
    private RedisMode mode = RedisMode.single;

    protected abstract JedisClient createJedisClient();

    protected boolean isUrlListened() {
        String redisUrl = this.getRedisUrl();
        return LISTENED_URL_SET.contains(redisUrl);
    }

    protected synchronized boolean listenUrl() {
        return LISTENED_URL_SET.add(this.getRedisUrl());
    }

    private JedisClient createJedisClient1() {
        try {
            return this.createJedisClient();
        }
        catch (KDException e) {
            Throwable cause = e.getCause();
            if (cause instanceof JedisConnectionException) {
                throw new KDException(cause, BosErrorCode.redisNotAvailable, new Object[0]);
            }
            throw e;
        }
    }

    protected abstract String getRedisUrl();

    abstract boolean isSessionable();

    protected final JedisClient getJedis() {
        try {
            this.rlock.lock();
            if (RedisMode.single == this.mode) {
                JedisClientWrapper jedisClientWrapper = new JedisClientWrapper(this.createJedisClient1(), this.mode);
                return jedisClientWrapper;
            }
        }
        finally {
            this.rlock.unlock();
        }
        if (this.jedisClientWrapper != null && !this.jedisClientWrapper.isClosed()) {
            return this.jedisClientWrapper;
        }
        try {
            this.wlock.lock();
            if (this.jedisClientWrapper == null || this.jedisClientWrapper.isClosed()) {
                this.jedisClientWrapper = new JedisClientWrapper(this.createJedisClient1(), this.mode);
            }
            JedisClientWrapper jedisClientWrapper = this.jedisClientWrapper;
            return jedisClientWrapper;
        }
        finally {
            this.wlock.unlock();
        }
    }

    @Override
    public void pipelinedMode() {
        try {
            this.wlock.lock();
            if (RedisMode.pipelined == this.mode) {
                return;
            }
            this.syncAndReturn();
            this.mode = RedisMode.pipelined;
            this.jedisClientWrapper = new JedisClientWrapper(this.createJedisClient(), this.mode);
        }
        finally {
            this.wlock.unlock();
        }
    }

    @Override
    public void singleMode() {
        try {
            this.wlock.lock();
            if (RedisMode.single == this.mode) {
                return;
            }
            this.syncAndReturn();
            this.mode = RedisMode.single;
            this.jedisClientWrapper = new JedisClientWrapper(this.createJedisClient(), this.mode);
        }
        finally {
            this.wlock.unlock();
        }
    }

    @Override
    public List<Object> syncAndReturn() {
        try {
            this.wlock.lock();
            List<Object> ls = null;
            if (this.jedisClientWrapper != null) {
                try {
                    ls = this.jedisClientWrapper.syncAndReturn();
                }
                finally {
                    this.jedisClientWrapper = new JedisClientWrapper(this.createJedisClient(), this.mode);
                }
            }
            List<Object> list = ls;
            return list;
        }
        finally {
            this.wlock.unlock();
        }
    }

    public void syncAndClose() {
        try {
            this.wlock.lock();
            if (this.jedisClientWrapper != null) {
                this.jedisClientWrapper.syncAndReturn();
            }
        }
        finally {
            this.wlock.unlock();
        }
    }

    protected final void release(JedisClientWrapper wrapper, boolean isBroken) {
        if (wrapper != null && !wrapper.isClosed()) {
            wrapper.close();
        }
    }

    protected Pair<ErrorCode, String> buildJedisExceptionInfo(Exception ex, String opt, Object ... args) {
        return RedisExceptionHelper.buildJedisExceptionInfo(ex, opt, this.getRedisUrl(), args);
    }

    public String toString() {
        return "current used mode is : " + this.mode.name();
    }
}

