/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cache.redis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;

public class ConsistentHashingBucket {
    private static final String SPLIT = "&";
    private List<String> nodes;
    private SortedMap<Integer, String> virtualNodes = new TreeMap<Integer, String>();
    private Map<String, String> vrMap = new ConcurrentHashMap<String, String>();
    private static final int VIRTUAL_NODES = 128;

    public ConsistentHashingBucket(List<String> nodes) {
        this.nodes = Collections.unmodifiableList(nodes);
        for (String str : nodes) {
            for (int i = 0; i < 128; ++i) {
                String virtualNodeName = str + SPLIT + String.valueOf(i);
                this.vrMap.put(virtualNodeName, str);
                int hash = ConsistentHashingBucket.getHash(virtualNodeName);
                this.virtualNodes.put(hash, virtualNodeName);
            }
        }
    }

    private static int getHash(String str) {
        int p = 16777619;
        int hash = -2128831035;
        for (int i = 0; i < str.length(); ++i) {
            hash = (hash ^ str.charAt(i)) * 16777619;
        }
        hash += hash << 13;
        hash ^= hash >> 7;
        hash += hash << 3;
        hash ^= hash >> 17;
        if ((hash += hash << 5) < 0) {
            hash = Math.abs(hash);
        }
        return hash;
    }

    public String getBucket(String key) {
        int hash = ConsistentHashingBucket.getHash(key);
        SortedMap<Integer, String> subMap = this.virtualNodes.tailMap(hash);
        Integer i = subMap.isEmpty() ? this.virtualNodes.firstKey() : subMap.firstKey();
        String virtualNode = (String)this.virtualNodes.get(i);
        return this.vrMap.get(virtualNode);
    }

    public List<String> getBuckets() {
        return this.nodes;
    }

    public void addNode(String node) {
        for (int i = 0; i < 128; ++i) {
            String virtualNodeName = node + SPLIT + String.valueOf(i);
            this.vrMap.put(virtualNodeName, node);
            int hash = ConsistentHashingBucket.getHash(virtualNodeName);
            this.virtualNodes.put(hash, virtualNodeName);
        }
        ArrayList<String> _nodes = new ArrayList<String>();
        _nodes.addAll(this.nodes);
        _nodes.add(node);
        this.nodes = Collections.unmodifiableList(_nodes);
    }

    public void removeNode(String node) {
        for (int i = 0; i < 128; ++i) {
            String virtualNodeName = node + SPLIT + String.valueOf(i);
            this.vrMap.put(virtualNodeName, node);
            int hash = ConsistentHashingBucket.getHash(virtualNodeName);
            this.virtualNodes.remove(hash);
        }
        ArrayList<String> _nodes = new ArrayList<String>();
        _nodes.addAll(this.nodes);
        _nodes.remove(node);
        this.nodes = Collections.unmodifiableList(_nodes);
    }
}

