/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cache.redis;

import java.net.ConnectException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import kd.bos.cache.redis.Pair;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.ErrorCode;
import kd.bos.ha.component.ComponentStatusManager;
import kd.bos.util.StringUtils;
import redis.clients.jedis.exceptions.InvalidURIException;
import redis.clients.jedis.exceptions.JedisAskDataException;
import redis.clients.jedis.exceptions.JedisBusyException;
import redis.clients.jedis.exceptions.JedisClusterException;
import redis.clients.jedis.exceptions.JedisClusterMaxAttemptsException;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.jedis.exceptions.JedisDataException;
import redis.clients.jedis.exceptions.JedisException;
import redis.clients.jedis.exceptions.JedisMovedDataException;
import redis.clients.jedis.exceptions.JedisNoReachableClusterNodeException;
import redis.clients.jedis.exceptions.JedisNoScriptException;
import redis.clients.jedis.exceptions.JedisRedirectionException;

public class RedisExceptionHelper {
    private static final Map<String, ErrorCode> JEDISEXCEPTION_MAPPER_ERRORCODE = new HashMap<String, ErrorCode>();

    private RedisExceptionHelper() {
    }

    public static Pair<ErrorCode, String> buildJedisExceptionInfo(Exception ex, String opt, String url, Object ... args) {
        String msg = "";
        ErrorCode errorCode = BosErrorCode.otherUnknow;
        String appendOpt = StringUtils.isBlank((String)opt) ? "" : ":[" + opt + "]";
        String appendKeys = "";
        if (args != null && args.length > 0) {
            String argsFormat = "[keys=>%s]";
            ArrayList<String> argsList = new ArrayList<String>(args.length);
            for (Object key : args) {
                if (key instanceof byte[]) {
                    argsList.add(new String((byte[])key, StandardCharsets.UTF_8));
                    continue;
                }
                if (key instanceof String[]) {
                    argsList.add(Arrays.toString((String[])key));
                    continue;
                }
                argsList.add(key == null ? "null" : key.toString());
            }
            appendKeys = String.format(argsFormat, String.join((CharSequence)",", argsList));
        }
        if (ex instanceof JedisException) {
            errorCode = JEDISEXCEPTION_MAPPER_ERRORCODE.get(ex.getClass().getSimpleName());
            if (errorCode == null) {
                errorCode = BosErrorCode.jedisUnkownException;
            }
        } else if (ex instanceof ConnectException) {
            errorCode = BosErrorCode.redisConnection;
            if (ComponentStatusManager.isException((String)url)) {
                errorCode = BosErrorCode.redisNotAvailable;
            }
        } else {
            msg = ex != null ? ex.getClass().getSimpleName() + ": " : "";
        }
        msg = msg + (ex != null ? ex.getMessage() : "Exception is null");
        msg = msg + appendOpt;
        msg = msg + appendKeys;
        return new Pair<ErrorCode, String>(errorCode, msg);
    }

    static {
        JEDISEXCEPTION_MAPPER_ERRORCODE.put(InvalidURIException.class.getSimpleName(), BosErrorCode.jedisInvalidURIException);
        JEDISEXCEPTION_MAPPER_ERRORCODE.put(JedisAskDataException.class.getSimpleName(), BosErrorCode.jedisAskDataException);
        JEDISEXCEPTION_MAPPER_ERRORCODE.put(JedisBusyException.class.getSimpleName(), BosErrorCode.jedisBusyException);
        JEDISEXCEPTION_MAPPER_ERRORCODE.put(JedisClusterException.class.getSimpleName(), BosErrorCode.jedisClusterException);
        JEDISEXCEPTION_MAPPER_ERRORCODE.put(JedisConnectionException.class.getSimpleName(), BosErrorCode.redisNotAvailable);
        JEDISEXCEPTION_MAPPER_ERRORCODE.put(JedisDataException.class.getSimpleName(), BosErrorCode.jedisDataException);
        JEDISEXCEPTION_MAPPER_ERRORCODE.put(JedisMovedDataException.class.getSimpleName(), BosErrorCode.jedisMovedDataException);
        JEDISEXCEPTION_MAPPER_ERRORCODE.put(JedisNoReachableClusterNodeException.class.getSimpleName(), BosErrorCode.redisNotAvailable);
        JEDISEXCEPTION_MAPPER_ERRORCODE.put(JedisNoScriptException.class.getSimpleName(), BosErrorCode.jedisNoScriptException);
        JEDISEXCEPTION_MAPPER_ERRORCODE.put(JedisRedirectionException.class.getSimpleName(), BosErrorCode.jedisRedirectionException);
        JEDISEXCEPTION_MAPPER_ERRORCODE.put(JedisException.class.getSimpleName(), BosErrorCode.jedisException);
        JEDISEXCEPTION_MAPPER_ERRORCODE.put(JedisClusterMaxAttemptsException.class.getSimpleName(), BosErrorCode.redisNotAvailable);
    }
}

