/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cache.redis;

import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import kd.bos.audit.Audit;
import kd.bos.audit.Auditable;
import kd.bos.cache.CacheConfigKeys;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.cache.SessionlessHaListener;
import kd.bos.cache.redis.AbstractRedisSessionCache;
import kd.bos.cache.redis.CacheLimiter;
import kd.bos.cache.redis.CacheValueLimiter;
import kd.bos.cache.redis.Pair;
import kd.bos.cache.redis.RedisSessionlessTimerExpire;
import kd.bos.cache.redis.TruncateUtils;
import kd.bos.cache.redis.backendcheck.RedisBackendCheckService;
import kd.bos.cache.redis.lua.LuaManager;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.ha.component.ComponentStatusManager;
import kd.bos.ha.component.KeepAliveListener;
import kd.bos.ha.component.KeepAliveService;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.redis.JedisClient;
import kd.bos.redis.RedisFactory;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import redis.clients.jedis.commands.MultiKeyCommands;

public class RedisSessionlessCache
extends AbstractRedisSessionCache
implements DistributeSessionlessCache {
    private static final String AUDIT_NAMES = "redis,redis_sessionless";
    private static final String TRACE_NAME = "RedisSessionlessCache";
    private static final String VALUE = "value";
    private static final String REMOVE_STR = "remove";
    private static final String CONTAINS_STR = "contains";
    private static final String GET_KEYS_WITH_PREFIX = "getKeysWithPrefix";
    private static final String VALUES = "values";
    private static final String INDEX = "index";
    private static final String INCRBY_STR = "incrBy";
    private static final String ADD_TO_SET = "addToSet";
    private static Map<String, RedisSessionlessTimerExpire> timerMap = new ConcurrentHashMap<String, RedisSessionlessTimerExpire>();
    private final String DEFAULT_TIMEOUT_KEY = "redis.defaulttimeout";
    private final int DEFAULT_TIMEOUT = 3600;
    private final boolean NOT_LUA = Boolean.getBoolean("redis.notLua");
    private final int MAP_SIZE = 120;
    private static Log log = LogFactory.getLog(RedisSessionlessCache.class);
    private String region;
    private RedisSessionlessTimerExpire timerExpire;
    private final CacheValueLimiter cacheValueLimiter;
    private static final String EVAL_ENABLE_KEY = "redisCache.eval.enable";

    public RedisSessionlessCache(String region) {
        this.region = region == null ? "" : region;
        this.cacheValueLimiter = CacheValueLimiter.getLimiter(this.region);
        String redisUrl = this.getRedisUrl();
        if (Boolean.getBoolean("ha.component.enable") && !this.isUrlListened() && this.listenUrl()) {
            KeepAliveService.registerKeepAliveListener((KeepAliveListener)new SessionlessHaListener(redisUrl));
        }
        RedisBackendCheckService.register(redisUrl, this.getDefaultTimeout() * 10);
    }

    protected void release(JedisClient jedis, boolean isBroken) {
        if (jedis != null) {
            jedis.close();
        }
    }

    private int getDefaultTimeout() {
        String s = System.getProperty("redis.defaulttimeout");
        if (s != null) {
            try {
                return Integer.parseInt(s.trim());
            }
            catch (Exception t) {
                log.error("redis.defaulttimeout is not legal integer: " + s);
            }
        }
        return 3600;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final String getRedisUrl() {
        String url = null;
        String useRegion = this.region;
        String configKey = CacheConfigKeys.getSessionlessConfigKey(useRegion);
        url = System.getProperty(configKey);
        if (url == null && this.region != null) {
            configKey = CacheConfigKeys.getSessionlessConfigKey(null);
            url = System.getProperty(configKey);
        }
        if (!timerMap.containsKey(url) || this.timerExpire == null) {
            Map<String, RedisSessionlessTimerExpire> map = timerMap;
            synchronized (map) {
                if (!timerMap.containsKey(url)) {
                    timerMap.put(url, new RedisSessionlessTimerExpire(url, this));
                }
            }
            this.timerExpire = timerMap.get(url);
        }
        return url;
    }

    @Override
    boolean isSessionable() {
        return false;
    }

    @Override
    public void put(String key, String value) {
        this.checkRedisUrl();
        this.put(key, value, this.getDefaultTimeout());
    }

    @Override
    public void put(String key, String value, int timeout, TimeUnit timeUnit) {
        this.checkRedisUrl();
        int timeoutSeconds = this.toExpireTime(timeout, timeUnit);
        try (TraceSpan span = Tracer.create((String)TRACE_NAME, (String)"put");
             Auditable audit = Audit.audit((String)AUDIT_NAMES, (Object[])new Object[]{"put", key});){
            span.addTag("key", key);
            span.addTag(VALUE, TruncateUtils.truncateValue(value));
            span.addTag("timeout", "" + timeoutSeconds);
            byte[] keyBytes = this.cacheValueLimiter.encode(key);
            byte[] valueBytes = this.cacheValueLimiter.checkAndEncodeStringValue(key, value);
            CacheLimiter.checkCountTotalSize(value);
            JedisClient jedis = this.getJedis();
            boolean isBroken = false;
            try {
                if (timeoutSeconds > 0) {
                    jedis.setex(keyBytes, timeoutSeconds, valueBytes);
                } else {
                    jedis.set(keyBytes, valueBytes);
                }
            }
            catch (Exception e) {
                isBroken = true;
                Pair<ErrorCode, String> exceptionInfo = this.buildJedisExceptionInfo(e, "set", key, timeoutSeconds, value);
                throw new KDException((Throwable)e, exceptionInfo.getKey(), new Object[]{exceptionInfo.getValue()});
            }
            finally {
                this.release(jedis, isBroken);
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public String get(String key) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<String> get(String type, String[] keys) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void put(String type, Map<String, String> keyValues) {
        this.put(type, keyValues, this.getDefaultTimeout());
    }

    /*
     * Exception decompiling
     */
    @Override
    @Deprecated
    public Object eval(String lua, String key, List<String> params) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void put(String type, Map<String, String> keyValues, int timeout, TimeUnit timeUnit) {
        this.checkRedisUrl();
        int timeoutSeconds = this.toExpireTime(timeout, timeUnit);
        try (TraceSpan span = Tracer.create((String)TRACE_NAME, (String)"put");
             Auditable audit = Audit.audit((String)AUDIT_NAMES, (Object[])new Object[]{"put", type});){
            span.addTag("type", type);
            span.addTag("keyValue", TruncateUtils.truncateValues(keyValues));
            if (null == keyValues || keyValues.isEmpty()) {
                return;
            }
            byte[] byteType = type.getBytes(StandardCharsets.UTF_8);
            Map<byte[], byte[]> byteKeyValuesMap = this.cacheValueLimiter.checkAndEncodeMapValue(type, keyValues);
            CacheLimiter.checkCountTotalSize(keyValues);
            JedisClient jedis = this.getJedis();
            boolean isBroken = false;
            try {
                if (this.NOT_LUA || keyValues != null && keyValues.size() > 120 || Instance.isLightWeightDeploy()) {
                    jedis.hmset(byteType, byteKeyValuesMap);
                    this._expireKey(jedis, type, timeoutSeconds);
                } else {
                    LuaManager.hmset(jedis, type, keyValues, timeoutSeconds);
                }
            }
            catch (Exception e) {
                isBroken = true;
                Pair<ErrorCode, String> exceptionInfo = this.buildJedisExceptionInfo(e, "hmset", type, keyValues);
                throw new KDException((Throwable)e, exceptionInfo.getKey(), new Object[]{exceptionInfo.getValue()});
            }
            finally {
                this.release(jedis, isBroken);
            }
        }
    }

    @Override
    public void remove(String key) {
        this.checkRedisUrl();
        CacheLimiter.checkCount();
        try (TraceSpan span = Tracer.create((String)TRACE_NAME, (String)REMOVE_STR);
             Auditable audit = Audit.audit((String)AUDIT_NAMES, (Object[])new Object[]{REMOVE_STR, key});){
            span.addTag("key", key);
            JedisClient jedis = this.getJedis();
            boolean isBroken = false;
            try {
                jedis.del(key);
            }
            catch (Exception e) {
                isBroken = true;
                Pair<ErrorCode, String> exceptionInfo = this.buildJedisExceptionInfo(e, "del", key);
                throw new KDException((Throwable)e, exceptionInfo.getKey(), new Object[]{exceptionInfo.getValue()});
            }
            finally {
                this.release(jedis, isBroken);
            }
        }
    }

    @Override
    public void remove(String[] keys) {
        this.checkRedisUrl();
        CacheLimiter.checkCount();
        try (TraceSpan span = Tracer.create((String)TRACE_NAME, (String)REMOVE_STR);
             Auditable audit = Audit.audit((String)AUDIT_NAMES, (Object[])new Object[]{REMOVE_STR, keys});){
            span.addTag("keys", TruncateUtils.truncateKeys(keys));
            JedisClient jedis = this.getJedis();
            boolean isBroken = false;
            try {
                if (jedis instanceof MultiKeyCommands) {
                    ((MultiKeyCommands)jedis).del(keys);
                } else {
                    for (String key : keys) {
                        jedis.del(key);
                    }
                }
            }
            catch (Exception e) {
                isBroken = true;
                Pair<ErrorCode, String> exceptionInfo = this.buildJedisExceptionInfo(e, "del", "", keys);
                throw new KDException((Throwable)e, exceptionInfo.getKey(), new Object[]{exceptionInfo.getValue()});
            }
            finally {
                this.release(jedis, isBroken);
            }
        }
    }

    @Override
    public void remove(String type, String[] keys) {
        this.checkRedisUrl();
        CacheLimiter.checkCount();
        try (TraceSpan span = Tracer.create((String)TRACE_NAME, (String)REMOVE_STR);
             Auditable audit = Audit.audit((String)AUDIT_NAMES, (Object[])new Object[]{REMOVE_STR, keys});){
            span.addTag("type", type);
            span.addTag("keys", TruncateUtils.truncateKeys(keys));
            JedisClient jedis = this.getJedis();
            boolean isBroken = false;
            try {
                jedis.hdel(type, keys);
            }
            catch (Exception e) {
                isBroken = true;
                Pair<ErrorCode, String> exceptionInfo = this.buildJedisExceptionInfo(e, "hdel", type, keys);
                throw new KDException((Throwable)e, exceptionInfo.getKey(), new Object[]{exceptionInfo.getValue()});
            }
            finally {
                this.release(jedis, isBroken);
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean contains(String key) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void put(String type, String key, String value) {
        this.put(type, key, value, this.getDefaultTimeout());
    }

    @Override
    public void put(String type, String key, String value, int timeout, TimeUnit timeUnit) {
        this.checkRedisUrl();
        int timeoutSeconds = this.toExpireTime(timeout, timeUnit);
        try (TraceSpan span = Tracer.create((String)TRACE_NAME, (String)"put");
             Auditable audit = Audit.audit((String)AUDIT_NAMES, (Object[])new Object[]{"put", type, key});){
            span.addTag("key", key);
            span.addTag(VALUE, TruncateUtils.truncateValue(value));
            span.addTag("type", type);
            byte[] byteType = this.cacheValueLimiter.encode(type);
            byte[] byteKey = this.cacheValueLimiter.encode(key);
            byte[] byteValue = this.cacheValueLimiter.encode(value);
            this.cacheValueLimiter.checkByteMapItemValue(type, byteKey, byteValue);
            CacheLimiter.checkCountTotalSize(key);
            CacheLimiter.checkCountTotalSize(value);
            JedisClient jedis = this.getJedis();
            boolean isBroken = false;
            try {
                if (this.NOT_LUA || Instance.isLightWeightDeploy()) {
                    jedis.hset(byteType, byteKey, byteValue);
                    this._expireKey(jedis, type, timeoutSeconds);
                } else {
                    LuaManager.hset(jedis, type, key, value, timeoutSeconds);
                }
            }
            catch (Exception e) {
                isBroken = true;
                Pair<ErrorCode, String> exceptionInfo = this.buildJedisExceptionInfo(e, "hset", type, key, value);
                throw new KDException((Throwable)e, exceptionInfo.getKey(), new Object[]{exceptionInfo.getValue()});
            }
            finally {
                this.release(jedis, isBroken);
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public String get(String type, String key) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void remove(String type, String key) {
        this.checkRedisUrl();
        CacheLimiter.checkCount();
        try (TraceSpan span = Tracer.create((String)TRACE_NAME, (String)REMOVE_STR);
             Auditable audit = Audit.audit((String)AUDIT_NAMES, (Object[])new Object[]{REMOVE_STR, type, key});){
            span.addTag("key", key);
            span.addTag("type", type);
            JedisClient jedis = this.getJedis();
            boolean isBroken = false;
            try {
                jedis.hdel(type, new String[]{key});
            }
            catch (Exception e) {
                isBroken = true;
                Pair<ErrorCode, String> exceptionInfo = this.buildJedisExceptionInfo(e, "hdel", type, key);
                throw new KDException((Throwable)e, exceptionInfo.getKey(), new Object[]{exceptionInfo.getValue()});
            }
            finally {
                this.release(jedis, isBroken);
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean contains(String type, String key) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void removeType(String type) {
        this.checkRedisUrl();
        CacheLimiter.checkCount();
        try (TraceSpan span = Tracer.create((String)TRACE_NAME, (String)"removeType");
             Auditable audit = Audit.audit((String)AUDIT_NAMES, (Object[])new Object[]{"removeType", type});){
            span.addTag("type", type);
            JedisClient jedis = this.getJedis();
            boolean isBroken = false;
            try {
                jedis.del(type);
            }
            catch (Exception e) {
                isBroken = true;
                Pair<ErrorCode, String> exceptionInfo = this.buildJedisExceptionInfo(e, "del", type);
                throw new KDException((Throwable)e, exceptionInfo.getKey(), new Object[]{exceptionInfo.getValue()});
            }
            finally {
                this.release(jedis, isBroken);
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public Map<String, String> getAll(String type) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public List<String> getKeys(String type) {
        return this.getKeysWithPrefix(type, null);
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<String> getKeysWithPrefix(String type, String prefix) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<String> getKeysWithPrefix(String prefix) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void expireAfter(String keyOrType, int timeout, TimeUnit timeUnit) {
        this.checkRedisUrl();
        CacheLimiter.checkCount();
        int timeoutSeconds = this.toExpireTime(timeout, timeUnit);
        try (JedisClient jedis = this.getJedis();){
            this._expireKey(jedis, keyOrType, timeoutSeconds);
        }
    }

    @Override
    public void expireAfterImmediateEffect(String keyOrType, int timeout, TimeUnit timeUnit) {
        CacheLimiter.checkCount();
        int timeoutSeconds = this.toExpireTime(timeout, timeUnit);
        try (JedisClient jedis = this.getJedis();){
            jedis.expire(keyOrType, timeoutSeconds);
        }
    }

    private void _expireKey(JedisClient jedis, String key, int timeoutSeconds) {
        if (this.timerExpire.touchTimestampMap.putIfAbsent(key, System.currentTimeMillis()) == null) {
            jedis.expire(key, timeoutSeconds);
        }
        this.timerExpire.cacheKeyExpried.put(key, timeoutSeconds);
    }

    private void expireByteKey(JedisClient jedis, byte[] key, int timeoutSeconds) {
        if (timeoutSeconds > 0) {
            jedis.expire(key, timeoutSeconds);
        }
    }

    @Override
    public int addList(String key, String[] values) {
        this.checkTtl("addList", key);
        return this.addList(key, values, this.getDefaultTimeout());
    }

    /*
     * Exception decompiling
     */
    @Override
    public int addList(String key, String[] values, int timeout, TimeUnit timeUnit) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public int resetList(String key, String[] values, int timeout, TimeUnit timeUnit) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public int insertList(String key, int index, String[] values) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public String[] getList(String key) {
        return this.getList(key, 0, Integer.MAX_VALUE);
    }

    /*
     * Exception decompiling
     */
    @Override
    public String[] getList(String key, int index, int length) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void setListObject(String key, int index, String value) {
        this.checkRedisUrl();
        try (TraceSpan span = Tracer.create((String)TRACE_NAME, (String)"setListObject");
             Auditable audit = Audit.audit((String)AUDIT_NAMES, (Object[])new Object[]{"setListObject", key, index});){
            span.addTag("key", key);
            span.addTag(VALUE, TruncateUtils.truncateValue(value));
            span.addTag(INDEX, "" + index);
            byte[] byteKey = key.getBytes(StandardCharsets.UTF_8);
            byte[] byteValue = this.cacheValueLimiter.checkAndEncodeStringValue(key, value);
            CacheLimiter.checkCountTotalSize(value);
            JedisClient jedis = this.getJedis();
            boolean isBroken = false;
            try {
                jedis.lset(byteKey, (long)index, byteValue);
            }
            catch (Exception e) {
                isBroken = true;
                Pair<ErrorCode, String> exceptionInfo = this.buildJedisExceptionInfo(e, "lset", key, index, value);
                throw new KDException((Throwable)e, exceptionInfo.getKey(), new Object[]{exceptionInfo.getValue()});
            }
            finally {
                this.release(jedis, isBroken);
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public String getListObject(String key, int index) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void removeListObject(String key, int index) {
        this.removeListObjects(key, index, 1);
    }

    @Override
    public void removeListObjects(String key, int index, int length) {
        this.checkRedisUrl();
        CacheLimiter.checkCount();
        try (TraceSpan span = Tracer.create((String)TRACE_NAME, (String)"removeListObjects");
             Auditable audit = Audit.audit((String)AUDIT_NAMES, (Object[])new Object[]{"removeListObjects", key, index, length});){
            span.addTag("key", key);
            span.addTag(INDEX, "" + index);
            span.addTag("length", "" + length);
            JedisClient jedis = this.getJedis();
            String payload = "${del}";
            boolean isBroken = false;
            try {
                if (jedis.exists(key).booleanValue()) {
                    for (int i = 0; i < length; ++i) {
                        jedis.lset(key, (long)(i + index), payload);
                    }
                    jedis.lrem(key, (long)length, payload);
                }
            }
            catch (Exception e) {
                isBroken = true;
                Pair<ErrorCode, String> exceptionInfo = this.buildJedisExceptionInfo(e, "exists|lset|lrem", key, index, length);
                throw new KDException((Throwable)e, exceptionInfo.getKey(), new Object[]{exceptionInfo.getValue()});
            }
            finally {
                this.release(jedis, isBroken);
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public int getListLength(String key) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public long inc(String key, int timeout, TimeUnit timeUnit) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public long inc(String key) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public long incrBy(String key, int amount) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public long decr(String key, int timeout, TimeUnit timeUnit) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public long decr(String key) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public int addToSet(String key, String[] values) {
        this.checkTtl(ADD_TO_SET, key);
        return this.addToSet(key, values, this.getDefaultTimeout());
    }

    private void checkTtl(String methodName, String key) {
        if (Boolean.getBoolean("redis.key.checkTtl")) {
            JedisClient jedis = this.getJedis();
            boolean isBroken = false;
            try {
                Long ttl = jedis.ttl(key);
                if (ttl == -1L) {
                    throw new KDException(BosErrorCode.redisWrite, new Object[]{"not set ttl for key :" + key});
                }
            }
            catch (Exception e) {
                isBroken = true;
                Pair<ErrorCode, String> exceptionInfo = this.buildJedisExceptionInfo(e, methodName + "_ttl", key);
                throw new KDException((Throwable)e, exceptionInfo.getKey(), new Object[]{exceptionInfo.getValue()});
            }
            finally {
                this.release(jedis, isBroken);
            }
        }
    }

    private int toExpireTime(int timeout, TimeUnit timeUnit) {
        int expire = (int)timeUnit.toSeconds(timeout);
        if (expire < 0) {
            expire = this.getDefaultTimeout();
        }
        return expire;
    }

    /*
     * Exception decompiling
     */
    @Override
    public int addToSet(String key, String[] values, int timeout, TimeUnit timeUnit) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void removeSetValues(String key, String[] values) {
        this.checkRedisUrl();
        CacheLimiter.checkCount();
        try (TraceSpan span = Tracer.create((String)TRACE_NAME, (String)"removeSetValues");
             Auditable audit = Audit.audit((String)AUDIT_NAMES, (Object[])new Object[]{"removeSetValues", key});){
            span.addTag("key", key);
            span.addTag(VALUES, TruncateUtils.truncateValues(values));
            JedisClient jedis = this.getJedis();
            boolean isBroken = false;
            try {
                jedis.srem(key, values);
            }
            catch (Exception e) {
                isBroken = true;
                Pair<ErrorCode, String> exceptionInfo = this.buildJedisExceptionInfo(e, "srem", key, values);
                throw new KDException((Throwable)e, exceptionInfo.getKey(), new Object[]{exceptionInfo.getValue()});
            }
            finally {
                this.release(jedis, isBroken);
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public int getSetLength(String key) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public String[] getSetValues(String key) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    protected JedisClient createJedisClient() {
        return RedisFactory.getJedisClient((String)this.getRedisUrl());
    }

    public void put(byte[] key, byte[] value) {
        this.put(key, value, this.getDefaultTimeout());
    }

    @Override
    public void put(byte[] key, byte[] value, int timeout) {
        this.checkRedisUrl();
        this.cacheValueLimiter.checkByteValue(key, value);
        CacheLimiter.checkCountTotalSize(key);
        CacheLimiter.checkCountTotalSize(value);
        int timeoutSeconds = this.toExpireTime(timeout, TimeUnit.SECONDS);
        try (TraceSpan span = Tracer.create((String)TRACE_NAME, (String)"putbyte");
             Auditable audit = Audit.audit((String)AUDIT_NAMES, (Object[])new Object[]{"putbyte", key});){
            span.addTag("timeout", "" + timeoutSeconds);
            JedisClient jedis = this.getJedis();
            boolean isBroken = false;
            try {
                if (timeoutSeconds > 0) {
                    jedis.setex(key, timeoutSeconds, value);
                } else {
                    jedis.set(key, value);
                }
            }
            catch (Exception e) {
                isBroken = true;
                Pair<ErrorCode, String> exceptionInfo = this.buildJedisExceptionInfo(e, "putbyte", key, value, timeoutSeconds);
                throw new KDException((Throwable)e, exceptionInfo.getKey(), new Object[]{exceptionInfo.getValue()});
            }
            finally {
                this.release(jedis, isBroken);
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public byte[] get(byte[] key) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void hset(String key, byte[] field, byte[] value) {
        this.hset(key.getBytes(StandardCharsets.UTF_8), field, value);
    }

    @Override
    public void hset(String key, byte[] field, byte[] value, int timeoutSeconds) {
        this.hset(key.getBytes(StandardCharsets.UTF_8), field, value, timeoutSeconds);
    }

    @Override
    public void hmset(String key, Map<byte[], byte[]> hash) {
        this.hmset(key.getBytes(StandardCharsets.UTF_8), hash);
    }

    @Override
    public void hmset(String key, Map<byte[], byte[]> hash, int timeoutSeconds) {
        this.hmset(key.getBytes(StandardCharsets.UTF_8), hash, timeoutSeconds);
    }

    @Override
    public byte[] hget(String key, byte[] field) {
        return this.hget(key.getBytes(StandardCharsets.UTF_8), field);
    }

    @Override
    public Map<byte[], byte[]> hgetAll(String key) {
        return this.hgetAll(key.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public List<byte[]> hmget(String key, byte[] ... fields) {
        return this.hmget(key.getBytes(StandardCharsets.UTF_8), fields);
    }

    @Override
    public void put(String key, byte[] value) {
        this.put(key.getBytes(StandardCharsets.UTF_8), value);
    }

    @Override
    public void put(String key, byte[] value, int timeoutSeconds) {
        this.put(key.getBytes(StandardCharsets.UTF_8), value, timeoutSeconds);
    }

    @Override
    public byte[] getByteValue(String key) {
        return this.get(key.getBytes(StandardCharsets.UTF_8));
    }

    public void hset(byte[] key, byte[] field, byte[] value) {
        this.hset(key, field, value, this.getDefaultTimeout());
    }

    public void hset(byte[] key, byte[] field, byte[] value, int timeoutSeconds) {
        this.checkRedisUrl();
        this.cacheValueLimiter.checkByteMapItemValue(key, field, value);
        CacheLimiter.checkCountTotalSize(field);
        CacheLimiter.checkCountTotalSize(value);
        try (TraceSpan span = Tracer.create((String)TRACE_NAME, (String)"hset");
             Auditable audit = Audit.audit((String)AUDIT_NAMES, (Object[])new Object[]{"hset", key});){
            JedisClient jedis = this.getJedis();
            boolean isBroken = false;
            try {
                jedis.hset(key, field, value);
                this.expireByteKey(jedis, key, timeoutSeconds);
            }
            catch (Exception e) {
                isBroken = true;
                Pair<ErrorCode, String> exceptionInfo = this.buildJedisExceptionInfo(e, "hset", new Object[]{key});
                throw new KDException((Throwable)e, exceptionInfo.getKey(), new Object[]{exceptionInfo.getValue()});
            }
            finally {
                this.release(jedis, isBroken);
            }
        }
    }

    public void hmset(byte[] key, Map<byte[], byte[]> hash) {
        this.hmset(key, hash, this.getDefaultTimeout());
    }

    public void hmset(byte[] key, Map<byte[], byte[]> hash, int timeoutSeconds) {
        this.checkRedisUrl();
        this.cacheValueLimiter.checkByteMapValue(key, hash);
        CacheLimiter.checkCountTotalByteSize(hash);
        try (TraceSpan span = Tracer.create((String)TRACE_NAME, (String)"hmset");
             Auditable audit = Audit.audit((String)AUDIT_NAMES, (Object[])new Object[]{"hmset", key});){
            JedisClient jedis = this.getJedis();
            boolean isBroken = false;
            try {
                jedis.hmset(key, hash);
                this.expireByteKey(jedis, key, timeoutSeconds);
            }
            catch (Exception e) {
                isBroken = true;
                Pair<ErrorCode, String> exceptionInfo = this.buildJedisExceptionInfo(e, "hmset", new Object[]{key});
                throw new KDException((Throwable)e, exceptionInfo.getKey(), new Object[]{exceptionInfo.getValue()});
            }
            finally {
                this.release(jedis, isBroken);
            }
        }
    }

    /*
     * Exception decompiling
     */
    public byte[] hget(byte[] key, byte[] field) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public Map<byte[], byte[]> hgetAll(byte[] key) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public List<byte[]> hmget(byte[] key, byte[] ... fields) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void remove(byte[] key) {
        this.checkRedisUrl();
        CacheLimiter.checkCount();
        try (TraceSpan span = Tracer.create((String)TRACE_NAME, (String)"removebyte");
             Auditable audit = Audit.audit((String)AUDIT_NAMES, (Object[])new Object[]{"removebyte", key});){
            JedisClient jedis = this.getJedis();
            boolean isBroken = false;
            try {
                jedis.del(key);
            }
            catch (Exception e) {
                isBroken = true;
                Pair<ErrorCode, String> exceptionInfo = this.buildJedisExceptionInfo(e, "del", new Object[]{key});
                throw new KDException((Throwable)e, exceptionInfo.getKey(), new Object[]{exceptionInfo.getValue()});
            }
            finally {
                this.release(jedis, isBroken);
            }
        }
    }

    @Override
    public boolean isAvailable() {
        return !ComponentStatusManager.isException((String)this.getRedisUrl());
    }

    private void checkRedisUrl() {
        if (!Boolean.getBoolean("ha.component.enable")) {
            return;
        }
        if (this.isAvailable()) {
            return;
        }
        throw new KDException(BosErrorCode.redisNotAvailable, new Object[]{"redis server broken"});
    }
}

