/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cache.redis;

import com.google.common.collect.Lists;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import kd.bos.cache.CacheConfigKeys;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.cache.SessionlessHaListener;
import kd.bos.cache.redis.AbstractRedisSessionCache;
import kd.bos.cache.redis.Pair;
import kd.bos.cache.redis.RedisSessionlessTimerExpire;
import kd.bos.cache.redis.lua.LuaManager;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.ha.component.ComponentStatusManager;
import kd.bos.ha.component.KeepAliveListener;
import kd.bos.ha.component.KeepAliveService;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.redis.JedisClient;
import kd.bos.redis.RedisFactory;
import redis.clients.jedis.ListPosition;
import redis.clients.jedis.commands.MultiKeyCommands;

public class RedisSessionlessNoTraceCache
extends AbstractRedisSessionCache
implements DistributeSessionlessCache {
    private static final String INCRBY = "incrBy";
    private static Map<String, RedisSessionlessTimerExpire> timerMap = new ConcurrentHashMap<String, RedisSessionlessTimerExpire>();
    private final String DEFAULT_TIMEOUT_KEY = "redis.defaulttimeout";
    private final int DEFAULT_TIMEOUT = 3600;
    private final boolean NOT_LUA = Boolean.getBoolean("redis.notLua");
    private final int MAP_SIZE = 120;
    private Log log = LogFactory.getLog(RedisSessionlessNoTraceCache.class);
    private String region;
    private RedisSessionlessTimerExpire timerExpire;
    private static final String EVAL_ENABLE_KEY = "redisCache.eval.enable";

    public RedisSessionlessNoTraceCache(String region) {
        String string = this.region = region == null ? "" : region;
        if (Boolean.getBoolean("ha.component.enable") && !this.isUrlListened() && this.listenUrl()) {
            String redisUrl = this.getRedisUrl();
            KeepAliveService.registerKeepAliveListener((KeepAliveListener)new SessionlessHaListener(redisUrl));
        }
    }

    protected void release(JedisClient jedisClient, boolean isBroken) {
        if (jedisClient != null) {
            jedisClient.close();
        }
    }

    private int getDefaultTimeout() {
        String str = System.getProperty("redis.defaulttimeout");
        if (str != null) {
            try {
                return Integer.parseInt(str.trim());
            }
            catch (Exception t) {
                this.log.error("redis.defaulttimeout is not legal integer: " + str);
            }
        }
        return 3600;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final String getRedisUrl() {
        String redisUrl = null;
        String regionStr = this.region;
        String configKeyStr = CacheConfigKeys.getSessionlessConfigKey(regionStr);
        redisUrl = System.getProperty(configKeyStr);
        if (redisUrl == null && this.region != null) {
            configKeyStr = CacheConfigKeys.getSessionlessConfigKey(null);
            redisUrl = System.getProperty(configKeyStr);
        }
        if (!timerMap.containsKey(redisUrl) || this.timerExpire == null) {
            Map<String, RedisSessionlessTimerExpire> map = timerMap;
            synchronized (map) {
                if (!timerMap.containsKey(redisUrl)) {
                    timerMap.put(redisUrl, new RedisSessionlessTimerExpire(redisUrl, this));
                }
            }
            this.timerExpire = timerMap.get(redisUrl);
        }
        return redisUrl;
    }

    @Override
    boolean isSessionable() {
        return false;
    }

    @Override
    public void put(String keyStr, String valueStr) {
        this.put(keyStr, valueStr, this.getDefaultTimeout());
    }

    @Override
    public void put(String key, String value, int timeout, TimeUnit timeUnit) {
        int timeoutSeconds = this.toExpireTime(timeout, timeUnit);
        JedisClient jedisClient = this.getJedis();
        boolean isBroken = false;
        try {
            if (timeoutSeconds > 0) {
                jedisClient.setex(key, timeoutSeconds, value);
            } else {
                jedisClient.set(key, value);
            }
        }
        catch (Exception e) {
            isBroken = true;
            Pair<ErrorCode, String> exceptionInfo = this.buildJedisExceptionInfo(e, "set", key, timeoutSeconds, value);
            throw new KDException((Throwable)e, exceptionInfo.getKey(), new Object[]{exceptionInfo.getValue()});
        }
        finally {
            this.release(jedisClient, isBroken);
        }
    }

    @Override
    public String get(String key) {
        JedisClient jedisClient = this.getJedis();
        boolean isBroken = false;
        try {
            String string = jedisClient.get(key);
            return string;
        }
        catch (Exception e) {
            isBroken = true;
            Pair<ErrorCode, String> exceptionInfo = this.buildJedisExceptionInfo(e, "get", key);
            throw new KDException((Throwable)e, exceptionInfo.getKey(), new Object[]{exceptionInfo.getValue()});
        }
        finally {
            this.release(jedisClient, isBroken);
        }
    }

    @Override
    public List<String> get(String type, String[] keys) {
        JedisClient jedisClient = this.getJedis();
        boolean isBroken = false;
        try {
            List list = jedisClient.hmget(type, keys);
            return list;
        }
        catch (Exception e) {
            isBroken = true;
            Pair<ErrorCode, String> exceptionInfo = this.buildJedisExceptionInfo(e, "hmget", type, keys);
            throw new KDException((Throwable)e, exceptionInfo.getKey(), new Object[]{exceptionInfo.getValue()});
        }
        finally {
            this.release(jedisClient, isBroken);
        }
    }

    @Override
    public void put(String type, Map<String, String> keyValues) {
        this.put(type, keyValues, this.getDefaultTimeout());
    }

    @Override
    public void put(String type, Map<String, String> keyValues, int timeout, TimeUnit timeUnit) {
        int timeoutSeconds = this.toExpireTime(timeout, timeUnit);
        JedisClient jedisClient = this.getJedis();
        boolean isBroken = false;
        try {
            if (this.NOT_LUA || keyValues != null && keyValues.size() > 120 || Instance.isLightWeightDeploy()) {
                jedisClient.hmset(type, keyValues);
                this._expireKey(jedisClient, type, timeoutSeconds);
            } else {
                LuaManager.hmset(jedisClient, type, keyValues, timeoutSeconds);
            }
        }
        catch (Exception e) {
            isBroken = true;
            Pair<ErrorCode, String> exceptionInfo = this.buildJedisExceptionInfo(e, "hmset", type, keyValues);
            throw new KDException((Throwable)e, exceptionInfo.getKey(), new Object[]{exceptionInfo.getValue()});
        }
        finally {
            this.release(jedisClient, isBroken);
        }
    }

    @Override
    public void remove(String key) {
        JedisClient jedisClient = this.getJedis();
        boolean isBroken = false;
        try {
            jedisClient.del(key);
        }
        catch (Exception e) {
            isBroken = true;
            Pair<ErrorCode, String> exceptionInfo = this.buildJedisExceptionInfo(e, "del", key);
            throw new KDException((Throwable)e, exceptionInfo.getKey(), new Object[]{exceptionInfo.getValue()});
        }
        finally {
            this.release(jedisClient, isBroken);
        }
    }

    @Override
    public void remove(String[] keys) {
        JedisClient jedisClient = this.getJedis();
        boolean isBroken = false;
        try {
            if (jedisClient instanceof MultiKeyCommands) {
                ((MultiKeyCommands)jedisClient).del(keys);
            } else {
                for (String key : keys) {
                    jedisClient.del(key);
                }
            }
        }
        catch (Exception e) {
            isBroken = true;
            Pair<ErrorCode, String> exceptionInfo = this.buildJedisExceptionInfo(e, "del", "", keys);
            throw new KDException((Throwable)e, exceptionInfo.getKey(), new Object[]{exceptionInfo.getValue()});
        }
        finally {
            this.release(jedisClient, isBroken);
        }
    }

    @Override
    public void remove(String type, String[] keys) {
        JedisClient jedisClient = this.getJedis();
        boolean isBroken = false;
        try {
            jedisClient.hdel(type, keys);
        }
        catch (Exception e) {
            isBroken = true;
            Pair<ErrorCode, String> exceptionInfo = this.buildJedisExceptionInfo(e, "hdel", type, keys);
            throw new KDException((Throwable)e, exceptionInfo.getKey(), new Object[]{exceptionInfo.getValue()});
        }
        finally {
            this.release(jedisClient, isBroken);
        }
    }

    @Override
    public boolean contains(String key) {
        JedisClient jedisClient = this.getJedis();
        boolean isBroken = false;
        try {
            boolean bl = jedisClient.exists(key);
            return bl;
        }
        catch (Exception e) {
            isBroken = true;
            Pair<ErrorCode, String> exceptionInfo = this.buildJedisExceptionInfo(e, "exists", key);
            throw new KDException((Throwable)e, exceptionInfo.getKey(), new Object[]{exceptionInfo.getValue()});
        }
        finally {
            this.release(jedisClient, isBroken);
        }
    }

    @Override
    public void put(String type, String key, String value) {
        this.put(type, key, value, this.getDefaultTimeout());
    }

    @Override
    public void put(String type, String key, String value, int timeout, TimeUnit timeUnit) {
        int timeoutSeconds = this.toExpireTime(timeout, timeUnit);
        JedisClient jedisClient = this.getJedis();
        boolean isBroken = false;
        try {
            if (this.NOT_LUA || Instance.isLightWeightDeploy()) {
                jedisClient.hset(type, key, value);
                this._expireKey(jedisClient, type, timeoutSeconds);
            } else {
                LuaManager.hset(jedisClient, type, key, value, timeoutSeconds);
            }
        }
        catch (Exception e) {
            isBroken = true;
            Pair<ErrorCode, String> exceptionInfo = this.buildJedisExceptionInfo(e, "hset", type, key, value);
            throw new KDException((Throwable)e, exceptionInfo.getKey(), new Object[]{exceptionInfo.getValue()});
        }
        finally {
            this.release(jedisClient, isBroken);
        }
    }

    @Override
    public String get(String type, String key) {
        JedisClient jedisClient = this.getJedis();
        boolean isBroken = false;
        try {
            String string = jedisClient.hget(type, key);
            return string;
        }
        catch (Exception e) {
            isBroken = true;
            Pair<ErrorCode, String> exceptionInfo = this.buildJedisExceptionInfo(e, "hget", type, key);
            throw new KDException((Throwable)e, exceptionInfo.getKey(), new Object[]{exceptionInfo.getValue()});
        }
        finally {
            this.release(jedisClient, isBroken);
        }
    }

    @Override
    public void remove(String type, String key) {
        JedisClient jedisClient = this.getJedis();
        boolean isBroken = false;
        try {
            jedisClient.hdel(type, new String[]{key});
        }
        catch (Exception e) {
            isBroken = true;
            Pair<ErrorCode, String> exceptionInfo = this.buildJedisExceptionInfo(e, "hdel", type, key);
            throw new KDException((Throwable)e, exceptionInfo.getKey(), new Object[]{exceptionInfo.getValue()});
        }
        finally {
            this.release(jedisClient, isBroken);
        }
    }

    @Override
    public boolean contains(String type, String key) {
        JedisClient jedisClient = this.getJedis();
        boolean isBroken = false;
        try {
            boolean bl = jedisClient.hexists(type, key);
            return bl;
        }
        catch (Exception e) {
            isBroken = true;
            Pair<ErrorCode, String> exceptionInfo = this.buildJedisExceptionInfo(e, "hexists", type, key);
            throw new KDException((Throwable)e, exceptionInfo.getKey(), new Object[]{exceptionInfo.getValue()});
        }
        finally {
            this.release(jedisClient, isBroken);
        }
    }

    @Override
    public void removeType(String type) {
        JedisClient jedisClient = this.getJedis();
        boolean isBroken = false;
        try {
            jedisClient.del(type);
        }
        catch (Exception e) {
            isBroken = true;
            Pair<ErrorCode, String> exceptionInfo = this.buildJedisExceptionInfo(e, "del", type);
            throw new KDException((Throwable)e, exceptionInfo.getKey(), new Object[]{exceptionInfo.getValue()});
        }
        finally {
            this.release(jedisClient, isBroken);
        }
    }

    @Override
    public Map<String, String> getAll(String type) {
        JedisClient jedisClient = this.getJedis();
        boolean isBroken = false;
        try {
            Map map = jedisClient.hgetAll(type);
            return map;
        }
        catch (Exception e) {
            isBroken = true;
            Pair<ErrorCode, String> exceptionInfo = this.buildJedisExceptionInfo(e, "hgetAll", type);
            throw new KDException((Throwable)e, exceptionInfo.getKey(), new Object[]{exceptionInfo.getValue()});
        }
        finally {
            this.release(jedisClient, isBroken);
        }
    }

    @Override
    public List<String> getKeys(String type) {
        return this.getKeysWithPrefix(type, null);
    }

    @Override
    public List<String> getKeysWithPrefix(String type, String prefix) {
        JedisClient jedisClient = this.getJedis();
        List result = null;
        boolean isBroken = false;
        try {
            Set set = jedisClient.hkeys(type);
            if (set == null) {
                result = Collections.emptyList();
            } else {
                result = new ArrayList();
                if (prefix == null) {
                    result.addAll(set);
                } else {
                    for (String key : set) {
                        if (!key.startsWith(prefix)) continue;
                        result.add(key);
                    }
                }
            }
            List list = result;
            return list;
        }
        catch (Exception e) {
            isBroken = true;
            Pair<ErrorCode, String> exceptionInfo = this.buildJedisExceptionInfo(e, "hkeys", type);
            throw new KDException((Throwable)e, exceptionInfo.getKey(), new Object[]{exceptionInfo.getValue()});
        }
        finally {
            this.release(jedisClient, isBroken);
        }
    }

    @Override
    public List<String> getKeysWithPrefix(String prefix) {
        JedisClient jedisClient = this.getJedis();
        boolean isBroken = false;
        try {
            Set set = jedisClient.keys(prefix + "*");
            if (set == null || set.isEmpty()) {
                List<String> list = Collections.emptyList();
                return list;
            }
            ArrayList arrayList = Lists.newArrayList((Iterable)set);
            return arrayList;
        }
        catch (Exception e) {
            isBroken = true;
            Pair<ErrorCode, String> exceptionInfo = this.buildJedisExceptionInfo(e, "keys", prefix + "*");
            throw new KDException((Throwable)e, exceptionInfo.getKey(), new Object[]{exceptionInfo.getValue()});
        }
        finally {
            this.release(jedisClient, isBroken);
        }
    }

    @Override
    public void expireAfter(String keyOrType, int timeout, TimeUnit timeUnit) {
        int timeoutSeconds = this.toExpireTime(timeout, timeUnit);
        try (JedisClient jedisClient = this.getJedis();){
            this._expireKey(jedisClient, keyOrType, timeoutSeconds);
        }
    }

    @Override
    public void expireAfterImmediateEffect(String keyOrType, int timeout, TimeUnit timeUnit) {
        int timeoutSeconds = this.toExpireTime(timeout, timeUnit);
        try (JedisClient jedisClient = this.getJedis();){
            jedisClient.expire(keyOrType, timeoutSeconds);
        }
    }

    private void _expireKey(JedisClient jedisClient, String key, int timeoutSeconds) {
        if (this.timerExpire.touchTimestampMap.putIfAbsent(key, System.currentTimeMillis()) == null) {
            jedisClient.expire(key, timeoutSeconds);
        }
        this.timerExpire.cacheKeyExpried.put(key, timeoutSeconds);
    }

    private void expireByteKey(JedisClient jedisClient, byte[] key, int timeoutSeconds) {
        if (timeoutSeconds > 0) {
            jedisClient.expire(key, timeoutSeconds);
        }
    }

    @Override
    public int addList(String key, String[] values) {
        return this.addList(key, values, this.getDefaultTimeout());
    }

    @Override
    public int addList(String key, String[] values, int timeout, TimeUnit timeUnit) {
        int timeoutSeconds = this.toExpireTime(timeout, timeUnit);
        JedisClient jedisClient = this.getJedis();
        boolean isBroken = false;
        try {
            Long size = jedisClient.rpush(key, values);
            this._expireKey(jedisClient, key, timeoutSeconds);
            int n = size.intValue();
            return n;
        }
        catch (Exception e) {
            isBroken = true;
            Pair<ErrorCode, String> exceptionInfo = this.buildJedisExceptionInfo(e, "rpush", key, values);
            throw new KDException((Throwable)e, exceptionInfo.getKey(), new Object[]{exceptionInfo.getValue()});
        }
        finally {
            this.release(jedisClient, isBroken);
        }
    }

    @Override
    public int resetList(String key, String[] values, int timeout, TimeUnit timeUnit) {
        int timeoutSeconds = this.toExpireTime(timeout, timeUnit);
        JedisClient jedis = this.getJedis();
        boolean isBroken = false;
        try {
            Long size;
            if (this.NOT_LUA || Instance.isLightWeightDeploy()) {
                jedis.del(key);
                if (values != null && values.length > 0) {
                    size = jedis.rpush(key, values);
                    this._expireKey(jedis, key, timeoutSeconds);
                } else {
                    size = 0L;
                }
            } else {
                size = LuaManager.resetList(jedis, key, values, timeoutSeconds);
            }
            int n = size.intValue();
            return n;
        }
        catch (Exception e) {
            isBroken = true;
            Pair<ErrorCode, String> exceptionInfo = this.buildJedisExceptionInfo(e, "rpush", key, values);
            throw new KDException((Throwable)e, exceptionInfo.getKey(), new Object[]{exceptionInfo.getValue()});
        }
        finally {
            this.release(jedis, isBroken);
        }
    }

    @Override
    public int insertList(String key, int index, String[] values) {
        JedisClient jedisClient = this.getJedis();
        boolean isBroken = false;
        try {
            int i;
            String s = jedisClient.lindex(key, (long)index);
            if (s == null) {
                throw new IndexOutOfBoundsException("index:" + index);
            }
            for (i = values.length - 1; i > -1; --i) {
                jedisClient.linsert(key, ListPosition.BEFORE, s, values[i]);
            }
            i = values.length;
            return i;
        }
        catch (Exception e) {
            isBroken = true;
            Pair<ErrorCode, String> exceptionInfo = this.buildJedisExceptionInfo(e, "lindex|linsert", key, index, values);
            throw new KDException((Throwable)e, exceptionInfo.getKey(), new Object[]{exceptionInfo.getValue()});
        }
        finally {
            this.release(jedisClient, isBroken);
        }
    }

    @Override
    public String[] getList(String key) {
        return this.getList(key, 0, Integer.MAX_VALUE);
    }

    @Override
    public String[] getList(String key, int index, int length) {
        JedisClient jedisClient = this.getJedis();
        boolean isBroken = false;
        try {
            List result = jedisClient.lrange(key, (long)index, (long)(index + length - 1));
            if (result != null) {
                String[] stringArray = result.toArray(new String[result.size()]);
                return stringArray;
            }
            String[] stringArray = null;
            return stringArray;
        }
        catch (Exception e) {
            isBroken = true;
            Pair<ErrorCode, String> exceptionInfo = this.buildJedisExceptionInfo(e, "lrange", key, index, index + length - 1);
            throw new KDException((Throwable)e, exceptionInfo.getKey(), new Object[]{exceptionInfo.getValue()});
        }
        finally {
            this.release(jedisClient, isBroken);
        }
    }

    @Override
    public void setListObject(String key, int index, String value) {
        JedisClient jedisClient = this.getJedis();
        boolean isBroken = false;
        try {
            jedisClient.lset(key, (long)index, value);
        }
        catch (Exception e) {
            isBroken = true;
            Pair<ErrorCode, String> exceptionInfo = this.buildJedisExceptionInfo(e, "lset", key, index, value);
            throw new KDException((Throwable)e, exceptionInfo.getKey(), new Object[]{exceptionInfo.getValue()});
        }
        finally {
            this.release(jedisClient, isBroken);
        }
    }

    @Override
    public String getListObject(String key, int index) {
        JedisClient jedisClient = this.getJedis();
        boolean isBroken = false;
        try {
            String string = jedisClient.lindex(key, (long)index);
            return string;
        }
        catch (Exception e) {
            isBroken = true;
            Pair<ErrorCode, String> exceptionInfo = this.buildJedisExceptionInfo(e, "lindex", key, index);
            throw new KDException((Throwable)e, exceptionInfo.getKey(), new Object[]{exceptionInfo.getValue()});
        }
        finally {
            this.release(jedisClient, isBroken);
        }
    }

    @Override
    public void removeListObject(String key, int index) {
        this.removeListObjects(key, index, 1);
    }

    @Override
    public void removeListObjects(String key, int index, int length) {
        JedisClient jedisClient = this.getJedis();
        String payload = "${del}";
        boolean isBroken = false;
        try {
            if (jedisClient.exists(key).booleanValue()) {
                for (int i = 0; i < length; ++i) {
                    jedisClient.lset(key, (long)(i + index), payload);
                }
                jedisClient.lrem(key, (long)length, payload);
            }
        }
        catch (Exception e) {
            isBroken = true;
            Pair<ErrorCode, String> exceptionInfo = this.buildJedisExceptionInfo(e, "exists|lset|lrem", key, index, length);
            throw new KDException((Throwable)e, exceptionInfo.getKey(), new Object[]{exceptionInfo.getValue()});
        }
        finally {
            this.release(jedisClient, isBroken);
        }
    }

    @Override
    public int getListLength(String key) {
        JedisClient jedisClient = this.getJedis();
        boolean isBroken = false;
        try {
            Long size = jedisClient.llen(key);
            int n = size.intValue();
            return n;
        }
        catch (Exception e) {
            isBroken = true;
            Pair<ErrorCode, String> exceptionInfo = this.buildJedisExceptionInfo(e, "llen", key);
            throw new KDException((Throwable)e, exceptionInfo.getKey(), new Object[]{exceptionInfo.getValue()});
        }
        finally {
            this.release(jedisClient, isBroken);
        }
    }

    @Override
    public long inc(String key, int timeout, TimeUnit timeUnit) {
        int timeoutSeconds = this.toExpireTime(timeout, timeUnit);
        JedisClient jedisClient = this.getJedis();
        boolean isBroken = false;
        try {
            long v = jedisClient.incr(key);
            this._expireKey(jedisClient, key, timeoutSeconds);
            long l = v;
            return l;
        }
        catch (Exception e) {
            isBroken = true;
            Pair<ErrorCode, String> exceptionInfo = this.buildJedisExceptionInfo(e, "incr", key);
            throw new KDException((Throwable)e, exceptionInfo.getKey(), new Object[]{exceptionInfo.getValue()});
        }
        finally {
            this.release(jedisClient, isBroken);
        }
    }

    @Override
    public long inc(String key) {
        JedisClient jedisClient = this.getJedis();
        boolean isBroken = false;
        try {
            long l = jedisClient.incr(key);
            return l;
        }
        catch (Exception e) {
            isBroken = true;
            Pair<ErrorCode, String> exceptionInfo = this.buildJedisExceptionInfo(e, "incr", key);
            throw new KDException((Throwable)e, exceptionInfo.getKey(), new Object[]{exceptionInfo.getValue()});
        }
        finally {
            this.release(jedisClient, isBroken);
        }
    }

    @Override
    public long incrBy(String key, int amount) {
        JedisClient jedisClient = this.getJedis();
        boolean isBroken = false;
        try {
            long l = jedisClient.incrBy(key, (long)amount);
            return l;
        }
        catch (Exception e) {
            isBroken = true;
            Pair<ErrorCode, String> exceptionInfo = this.buildJedisExceptionInfo(e, INCRBY, key, amount);
            throw new KDException((Throwable)e, exceptionInfo.getKey(), new Object[]{exceptionInfo.getValue()});
        }
        finally {
            this.release(jedisClient, isBroken);
        }
    }

    @Override
    public long decr(String key, int timeout, TimeUnit timeUnit) {
        int timeoutSeconds = this.toExpireTime(timeout, timeUnit);
        JedisClient jedisClient = this.getJedis();
        boolean isBroken = false;
        try {
            long v = jedisClient.decr(key);
            this._expireKey(jedisClient, key, timeoutSeconds);
            long l = v;
            return l;
        }
        catch (Exception e) {
            isBroken = true;
            Pair<ErrorCode, String> exceptionInfo = this.buildJedisExceptionInfo(e, "decr", key);
            throw new KDException((Throwable)e, exceptionInfo.getKey(), new Object[]{exceptionInfo.getValue()});
        }
        finally {
            this.release(jedisClient, isBroken);
        }
    }

    @Override
    public long decr(String key) {
        JedisClient jedisClient = this.getJedis();
        boolean isBroken = false;
        try {
            long l = jedisClient.decr(key);
            return l;
        }
        catch (Exception e) {
            isBroken = true;
            Pair<ErrorCode, String> exceptionInfo = this.buildJedisExceptionInfo(e, "decr", key);
            throw new KDException((Throwable)e, exceptionInfo.getKey(), new Object[]{exceptionInfo.getValue()});
        }
        finally {
            this.release(jedisClient, isBroken);
        }
    }

    @Override
    public int addToSet(String key, String[] values) {
        JedisClient jedisClient = this.getJedis();
        boolean isBroken = false;
        try {
            Long size = jedisClient.sadd(key, values);
            int n = size.intValue();
            return n;
        }
        catch (Exception e) {
            isBroken = true;
            Pair<ErrorCode, String> exceptionInfo = this.buildJedisExceptionInfo(e, "sadd", key, values);
            throw new KDException((Throwable)e, exceptionInfo.getKey(), new Object[]{exceptionInfo.getValue()});
        }
        finally {
            this.release(jedisClient, isBroken);
        }
    }

    private int toExpireTime(int timeout, TimeUnit timeUnit) {
        int expire = (int)timeUnit.toSeconds(timeout);
        if (expire < 0) {
            expire = this.getDefaultTimeout();
        }
        return expire;
    }

    @Override
    public int addToSet(String key, String[] values, int timeout, TimeUnit timeUnit) {
        int timeoutSeconds = this.toExpireTime(timeout, timeUnit);
        JedisClient jedisClient = this.getJedis();
        boolean isBroken = false;
        try {
            Long size = jedisClient.sadd(key, values);
            this._expireKey(jedisClient, key, timeoutSeconds);
            int n = size.intValue();
            return n;
        }
        catch (Exception e) {
            isBroken = true;
            Pair<ErrorCode, String> exceptionInfo = this.buildJedisExceptionInfo(e, "sadd", key, values);
            throw new KDException((Throwable)e, exceptionInfo.getKey(), new Object[]{exceptionInfo.getValue()});
        }
        finally {
            this.release(jedisClient, isBroken);
        }
    }

    @Override
    public void removeSetValues(String key, String[] values) {
        JedisClient jedisClient = this.getJedis();
        boolean isBroken = false;
        try {
            jedisClient.srem(key, values);
        }
        catch (Exception e) {
            isBroken = true;
            Pair<ErrorCode, String> exceptionInfo = this.buildJedisExceptionInfo(e, "srem", key, values);
            throw new KDException((Throwable)e, exceptionInfo.getKey(), new Object[]{exceptionInfo.getValue()});
        }
        finally {
            this.release(jedisClient, isBroken);
        }
    }

    @Override
    public int getSetLength(String key) {
        JedisClient jedisClient = this.getJedis();
        boolean isBroken = false;
        try {
            Long size = jedisClient.scard(key);
            int n = size.intValue();
            return n;
        }
        catch (Exception e) {
            isBroken = true;
            Pair<ErrorCode, String> exceptionInfo = this.buildJedisExceptionInfo(e, "scard", key);
            throw new KDException((Throwable)e, exceptionInfo.getKey(), new Object[]{exceptionInfo.getValue()});
        }
        finally {
            this.release(jedisClient, isBroken);
        }
    }

    @Override
    public String[] getSetValues(String key) {
        JedisClient jedisClient = this.getJedis();
        boolean isBroken = false;
        try {
            Set members = jedisClient.smembers(key);
            String[] stringArray = members.toArray(new String[members.size()]);
            return stringArray;
        }
        catch (Exception e) {
            isBroken = true;
            Pair<ErrorCode, String> exceptionInfo = this.buildJedisExceptionInfo(e, "smembers", key);
            throw new KDException((Throwable)e, exceptionInfo.getKey(), new Object[]{exceptionInfo.getValue()});
        }
        finally {
            this.release(jedisClient, isBroken);
        }
    }

    @Override
    protected JedisClient createJedisClient() {
        return RedisFactory.getJedisClient((String)this.getRedisUrl());
    }

    public void put(byte[] key, byte[] value) {
        this.put(key, value, this.getDefaultTimeout());
    }

    @Override
    public void put(byte[] key, byte[] value, int timeout) {
        int timeoutSeconds = this.toExpireTime(timeout, TimeUnit.SECONDS);
        JedisClient jedisClient = this.getJedis();
        boolean isBroken = false;
        try {
            if (timeoutSeconds > 0) {
                jedisClient.setex(key, timeoutSeconds, value);
            } else {
                jedisClient.set(key, value);
            }
        }
        catch (Exception e) {
            isBroken = true;
            Pair<ErrorCode, String> exceptionInfo = this.buildJedisExceptionInfo(e, "putbyte", key, value, timeoutSeconds);
            throw new KDException((Throwable)e, exceptionInfo.getKey(), new Object[]{exceptionInfo.getValue()});
        }
        finally {
            this.release(jedisClient, isBroken);
        }
    }

    @Override
    public byte[] get(byte[] key) {
        JedisClient jedisClient = this.getJedis();
        boolean isBroken = false;
        try {
            byte[] byArray = jedisClient.get(key);
            return byArray;
        }
        catch (Exception e) {
            isBroken = true;
            Pair<ErrorCode, String> exceptionInfo = this.buildJedisExceptionInfo(e, "get", new Object[]{key});
            throw new KDException((Throwable)e, exceptionInfo.getKey(), new Object[]{exceptionInfo.getValue()});
        }
        finally {
            this.release(jedisClient, isBroken);
        }
    }

    @Override
    public void hset(String key, byte[] field, byte[] value) {
        this.hset(key.getBytes(StandardCharsets.UTF_8), field, value);
    }

    @Override
    public void hset(String key, byte[] field, byte[] value, int timeoutSeconds) {
        this.hset(key.getBytes(StandardCharsets.UTF_8), field, value, timeoutSeconds);
    }

    @Override
    public void hmset(String key, Map<byte[], byte[]> hash) {
        this.hmset(key.getBytes(StandardCharsets.UTF_8), hash);
    }

    @Override
    public void hmset(String key, Map<byte[], byte[]> hash, int timeoutSeconds) {
        this.hmset(key.getBytes(StandardCharsets.UTF_8), hash, timeoutSeconds);
    }

    @Override
    public byte[] hget(String key, byte[] field) {
        return this.hget(key.getBytes(StandardCharsets.UTF_8), field);
    }

    @Override
    public Map<byte[], byte[]> hgetAll(String key) {
        return this.hgetAll(key.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public List<byte[]> hmget(String key, byte[] ... fields) {
        return this.hmget(key.getBytes(StandardCharsets.UTF_8), fields);
    }

    @Override
    public Object eval(String lua, String key, List<String> params) {
        KDException ex = new KDException(BosErrorCode.redisWrite, new Object[]{"The method of RedisSessionlessCache.eval is forbidden!"});
        if (Boolean.getBoolean(EVAL_ENABLE_KEY)) {
            throw ex;
        }
        this.log.error((Throwable)ex);
        JedisClient jedisClient = this.getJedis();
        boolean isBroken = false;
        try {
            Object object = jedisClient.eval(lua, key, params);
            return object;
        }
        catch (Exception e) {
            isBroken = true;
            Pair<ErrorCode, String> exceptionInfo = this.buildJedisExceptionInfo(e, "eval", key);
            throw new KDException((Throwable)e, exceptionInfo.getKey(), new Object[]{exceptionInfo.getValue()});
        }
        finally {
            this.release(jedisClient, isBroken);
        }
    }

    @Override
    public void put(String key, byte[] value) {
        this.put(key.getBytes(StandardCharsets.UTF_8), value);
    }

    @Override
    public void put(String key, byte[] value, int timeoutSeconds) {
        this.put(key.getBytes(StandardCharsets.UTF_8), value, timeoutSeconds);
    }

    @Override
    public byte[] getByteValue(String key) {
        return this.get(key.getBytes(StandardCharsets.UTF_8));
    }

    public void hset(byte[] key, byte[] field, byte[] value) {
        this.hset(key, field, value, this.getDefaultTimeout());
    }

    public void hset(byte[] key, byte[] field, byte[] value, int timeoutSeconds) {
        JedisClient jedisClient = this.getJedis();
        boolean isBroken = false;
        try {
            jedisClient.hset(key, field, value);
            this.expireByteKey(jedisClient, key, timeoutSeconds);
        }
        catch (Exception e) {
            isBroken = true;
            Pair<ErrorCode, String> exceptionInfo = this.buildJedisExceptionInfo(e, "hset", new Object[]{key});
            throw new KDException((Throwable)e, exceptionInfo.getKey(), new Object[]{exceptionInfo.getValue()});
        }
        finally {
            this.release(jedisClient, isBroken);
        }
    }

    public void hmset(byte[] key, Map<byte[], byte[]> hash) {
        this.hmset(key, hash, this.getDefaultTimeout());
    }

    public void hmset(byte[] key, Map<byte[], byte[]> hash, int timeoutSeconds) {
        JedisClient jedisClient = this.getJedis();
        boolean isBroken = false;
        try {
            jedisClient.hmset(key, hash);
            this.expireByteKey(jedisClient, key, timeoutSeconds);
        }
        catch (Exception e) {
            isBroken = true;
            Pair<ErrorCode, String> exceptionInfo = this.buildJedisExceptionInfo(e, "hmset", new Object[]{key});
            throw new KDException((Throwable)e, exceptionInfo.getKey(), new Object[]{exceptionInfo.getValue()});
        }
        finally {
            this.release(jedisClient, isBroken);
        }
    }

    public byte[] hget(byte[] key, byte[] field) {
        JedisClient jedisClient = this.getJedis();
        boolean isBroken = false;
        try {
            byte[] byArray = jedisClient.hget(key, field);
            return byArray;
        }
        catch (Exception e) {
            isBroken = true;
            Pair<ErrorCode, String> exceptionInfo = this.buildJedisExceptionInfo(e, "hget", new Object[]{key});
            throw new KDException((Throwable)e, exceptionInfo.getKey(), new Object[]{exceptionInfo.getValue()});
        }
        finally {
            this.release(jedisClient, isBroken);
        }
    }

    public Map<byte[], byte[]> hgetAll(byte[] key) {
        JedisClient jedisClient = this.getJedis();
        boolean isBroken = false;
        try {
            Map map = jedisClient.hgetAll(key);
            return map;
        }
        catch (Exception e) {
            isBroken = true;
            Pair<ErrorCode, String> exceptionInfo = this.buildJedisExceptionInfo(e, "hgetAll", new Object[]{key});
            throw new KDException((Throwable)e, exceptionInfo.getKey(), new Object[]{exceptionInfo.getValue()});
        }
        finally {
            this.release(jedisClient, isBroken);
        }
    }

    public List<byte[]> hmget(byte[] key, byte[] ... fields) {
        JedisClient jedisClient = this.getJedis();
        boolean isBroken = false;
        try {
            List list = jedisClient.hmget(key, fields);
            return list;
        }
        catch (Exception e) {
            isBroken = true;
            Pair<ErrorCode, String> exceptionInfo = this.buildJedisExceptionInfo(e, "hmget", new Object[]{key});
            throw new KDException((Throwable)e, exceptionInfo.getKey(), new Object[]{exceptionInfo.getValue()});
        }
        finally {
            this.release(jedisClient, isBroken);
        }
    }

    @Override
    public void remove(byte[] key) {
        JedisClient jedisClient = this.getJedis();
        boolean isBroken = false;
        try {
            jedisClient.del(key);
        }
        catch (Exception e) {
            isBroken = true;
            Pair<ErrorCode, String> exceptionInfo = this.buildJedisExceptionInfo(e, "del", new Object[]{key});
            throw new KDException((Throwable)e, exceptionInfo.getKey(), new Object[]{exceptionInfo.getValue()});
        }
        finally {
            this.release(jedisClient, isBroken);
        }
    }

    @Override
    public boolean isAvailable() {
        return !ComponentStatusManager.isException((String)this.getRedisUrl());
    }
}

