/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cache.redis;

import com.google.common.collect.Lists;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import kd.bos.audit.Audit;
import kd.bos.audit.Auditable;
import kd.bos.cache.CacheConfigKeys;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.cache.redis.CacheLimiter;
import kd.bos.cache.redis.CacheValueLimiter;
import kd.bos.cache.redis.Pair;
import kd.bos.cache.redis.RedisExceptionHelper;
import kd.bos.cache.redis.TruncateUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.redis.JedisClient;
import kd.bos.redis.RedisFactory;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import redis.clients.jedis.ListPosition;
import redis.clients.jedis.commands.MultiKeyCommands;

public class XCacheSessionlessCache
implements DistributeSessionlessCache {
    private static final String DEFAULT_TIMEOUT_KEY = "redis.defaulttimeout";
    private static final String AUDIT_NAMES = "xcache,xcache_sessionless";
    private static final String TRACE_NAME = "XCacheSessionlessCache";
    private static final String VALUE = "value";
    private static final String REMOVE_STR = "remove";
    private static final String CONTAINS_STR = "contains";
    private static final String GET_KEYS_WITH_PREFIX = "getKeysWithPrefix";
    private static final String VALUES = "values";
    private static final String INDEX = "index";
    private static final String INCRBY_STR = "incrBy";
    private static final String ADD_TO_SET = "addToSet";
    public static final String OPT_PUT = "put";
    public static final String OPT_REMOVE_TYPE = "removeType";
    public static final String OPT_PUT_TYPE = "putType";
    public static final String OPT_GET_TYPE = "getType";
    private final String region;
    private final CacheValueLimiter cacheValueLimiter;
    private static final int DEFAULT_TIMEOUT = (int)TimeUnit.HOURS.toSeconds(1L);

    public XCacheSessionlessCache(String region) {
        this.region = region != null ? region : "";
        this.cacheValueLimiter = CacheValueLimiter.getLimiter(this.region);
    }

    @Override
    public void pipelinedMode() {
        throw XCacheSessionlessCache.unSupportedException("pipelinedMode");
    }

    @Override
    public void singleMode() {
    }

    @Override
    public List<Object> syncAndReturn() {
        return Collections.emptyList();
    }

    @Override
    public void put(String key, String value) {
        this.put(key, value, this.getDefaultTimeout());
    }

    private void doJedisRequest(Consumer<JedisClient> consumer, String opt, Object ... args) {
        this.doJedisRequestAndReturn(jedis -> {
            consumer.accept((JedisClient)jedis);
            return null;
        }, opt, args);
    }

    private <T> T doJedisRequestAndReturn(Function<JedisClient, T> function, String opt, Object ... args) {
        String url = CacheConfigKeys.getXCacheUrl(this.region);
        JedisClient jedis = this.getJedis(url);
        boolean isBroken = false;
        try {
            T t = function.apply(jedis);
            return t;
        }
        catch (Exception e) {
            isBroken = true;
            Pair<ErrorCode, String> exceptionInfo = RedisExceptionHelper.buildJedisExceptionInfo(e, opt, url, args);
            throw new KDException((Throwable)e, exceptionInfo.getKey(), new Object[]{exceptionInfo.getValue()});
        }
        finally {
            this.release(jedis, isBroken);
        }
    }

    @Override
    public void put(String key, String value, int timeout, TimeUnit timeUnit) {
        int timeoutSeconds = this.toExpireTime(timeout, timeUnit);
        try (TraceSpan span = Tracer.create((String)TRACE_NAME, (String)OPT_PUT);
             Auditable audit = Audit.audit((String)AUDIT_NAMES, (Object[])new Object[]{OPT_PUT, key});){
            span.addTag("key", key);
            span.addTag(VALUE, TruncateUtils.truncateValue(value));
            span.addTag("timeout", "" + timeoutSeconds);
            byte[] keyBytes = this.cacheValueLimiter.encode(key);
            byte[] valueBytes = this.cacheValueLimiter.checkAndEncodeStringValue(key, value);
            CacheLimiter.checkCountTotalSize(value);
            this.doJedisRequest(jedis -> jedis.setex(keyBytes, timeoutSeconds, valueBytes), "setex", key, timeoutSeconds, value);
        }
    }

    private JedisClient getJedis(String url) {
        return RedisFactory.getJedisClient((String)url);
    }

    /*
     * Exception decompiling
     */
    @Override
    public String get(String key) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<String> get(String type, String[] keys) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void put(String type, Map<String, String> keyValues) {
        this.put(type, keyValues, this.getDefaultTimeout());
    }

    @Override
    public Object eval(String lua, String key, List<String> params) {
        throw XCacheSessionlessCache.unSupportedException("eval");
    }

    @Override
    public void put(String type, Map<String, String> keyValues, int timeout, TimeUnit timeUnit) {
        int timeoutSeconds = this.toExpireTime(timeout, timeUnit);
        try (TraceSpan span = Tracer.create((String)TRACE_NAME, (String)OPT_PUT_TYPE);
             Auditable audit = Audit.audit((String)AUDIT_NAMES, (Object[])new Object[]{OPT_PUT_TYPE, type});){
            span.addTag("type", type);
            span.addTag("keyValue", TruncateUtils.truncateValues(keyValues));
            if (null == keyValues || keyValues.isEmpty()) {
                return;
            }
            byte[] byteType = type.getBytes(StandardCharsets.UTF_8);
            Map<byte[], byte[]> byteKeyValuesMap = this.cacheValueLimiter.checkAndEncodeMapValue(type, keyValues);
            CacheLimiter.checkCountTotalSize(keyValues);
            this.doJedisRequest(jedis -> {
                jedis.hmset(byteType, byteKeyValuesMap);
                this._expireKey((JedisClient)jedis, type, timeoutSeconds);
            }, "hmset", type, keyValues);
        }
    }

    @Override
    public void remove(String key) {
        CacheLimiter.checkCount();
        try (TraceSpan span = Tracer.create((String)TRACE_NAME, (String)REMOVE_STR);
             Auditable audit = Audit.audit((String)AUDIT_NAMES, (Object[])new Object[]{REMOVE_STR, key});){
            span.addTag("key", key);
            this.doJedisRequest(jedis -> jedis.del(key), "del", key);
        }
    }

    @Override
    public void remove(byte[] key) {
        CacheLimiter.checkCount();
        try (TraceSpan span = Tracer.create((String)TRACE_NAME, (String)"removebyte");
             Auditable audit = Audit.audit((String)AUDIT_NAMES, (Object[])new Object[]{"removebyte", key});){
            this.doJedisRequest(jedis -> jedis.del(key), "del", new Object[]{key});
        }
    }

    @Override
    public void remove(String[] keys) {
        CacheLimiter.checkCount();
        try (TraceSpan span = Tracer.create((String)TRACE_NAME, (String)REMOVE_STR);
             Auditable audit = Audit.audit((String)AUDIT_NAMES, (Object[])new Object[]{REMOVE_STR, keys});){
            span.addTag("keys", TruncateUtils.truncateKeys(keys));
            this.doJedisRequest(jedis -> {
                if (jedis instanceof MultiKeyCommands) {
                    ((MultiKeyCommands)jedis).del(keys);
                } else {
                    for (String key : keys) {
                        jedis.del(key);
                    }
                }
            }, "del", keys);
        }
    }

    @Override
    public void remove(String type, String[] keys) {
        CacheLimiter.checkCount();
        try (TraceSpan span = Tracer.create((String)TRACE_NAME, (String)OPT_REMOVE_TYPE);
             Auditable audit = Audit.audit((String)AUDIT_NAMES, (Object[])new Object[]{OPT_REMOVE_TYPE, keys});){
            span.addTag("type", type);
            span.addTag("keys", TruncateUtils.truncateKeys(keys));
            this.doJedisRequest(jedis -> jedis.hdel(type, keys), "hdel", type, keys);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean contains(String key) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void put(String type, String key, String value) {
        this.put(type, key, value, this.getDefaultTimeout());
    }

    @Override
    public void put(String type, String key, String value, int timeout, TimeUnit timeUnit) {
        int timeoutSeconds = this.toExpireTime(timeout, timeUnit);
        try (TraceSpan span = Tracer.create((String)TRACE_NAME, (String)OPT_PUT_TYPE);
             Auditable audit = Audit.audit((String)AUDIT_NAMES, (Object[])new Object[]{OPT_PUT_TYPE, type, key});){
            span.addTag("key", key);
            span.addTag(VALUE, TruncateUtils.truncateValue(value));
            span.addTag("type", type);
            byte[] byteType = this.cacheValueLimiter.encode(type);
            byte[] byteKey = this.cacheValueLimiter.encode(key);
            byte[] byteValue = this.cacheValueLimiter.encode(value);
            this.cacheValueLimiter.checkByteMapItemValue(type, byteKey, byteValue);
            CacheLimiter.checkCountTotalSize(key);
            CacheLimiter.checkCountTotalSize(value);
            this.doJedisRequest(jedis -> {
                jedis.hset(byteType, byteKey, byteValue);
                this._expireKey((JedisClient)jedis, type, timeoutSeconds);
            }, "hset", type, key, value);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public String get(String type, String key) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void remove(String type, String key) {
        CacheLimiter.checkCount();
        try (TraceSpan span = Tracer.create((String)TRACE_NAME, (String)OPT_REMOVE_TYPE);
             Auditable audit = Audit.audit((String)AUDIT_NAMES, (Object[])new Object[]{OPT_REMOVE_TYPE, type, key});){
            span.addTag("key", key);
            span.addTag("type", type);
            this.doJedisRequest(jedis -> jedis.hdel(type, new String[]{key}), "hdel", type, key);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean contains(String type, String key) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void removeType(String type) {
        CacheLimiter.checkCount();
        try (TraceSpan span = Tracer.create((String)TRACE_NAME, (String)OPT_REMOVE_TYPE);
             Auditable audit = Audit.audit((String)AUDIT_NAMES, (Object[])new Object[]{OPT_REMOVE_TYPE, type});){
            span.addTag("type", type);
            this.doJedisRequest(jedis -> jedis.del(type), "del", type);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public Map<String, String> getAll(String type) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public List<String> getKeys(String type) {
        return this.getKeysWithPrefix(type, null);
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<String> getKeysWithPrefix(String type, String prefix) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<String> getKeysWithPrefix(String prefix) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void expireAfter(String keyOrType, int timeout, TimeUnit timeUnit) {
        this.expireAfterImmediateEffect(keyOrType, timeout, timeUnit);
    }

    @Override
    public void expireAfterImmediateEffect(String keyOrType, int timeout, TimeUnit timeUnit) {
        CacheLimiter.checkCount();
        int timeoutSeconds = this.toExpireTime(timeout, timeUnit);
        try (JedisClient jedis = this.getJedis(CacheConfigKeys.getXCacheUrl(this.region));){
            jedis.expire(keyOrType, timeoutSeconds);
        }
    }

    private void _expireKey(JedisClient jedis, String key, int timeoutSeconds) {
        jedis.expire(key, timeoutSeconds);
    }

    private void expireByteKey(JedisClient jedis, byte[] key, int timeoutSeconds) {
        if (timeoutSeconds > 0) {
            jedis.expire(key, timeoutSeconds);
        }
    }

    @Override
    public int addList(String key, String[] values) {
        return this.addList(key, values, this.getDefaultTimeout());
    }

    /*
     * Exception decompiling
     */
    @Override
    public int addList(String key, String[] values, int timeout, TimeUnit timeUnit) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public int resetList(String key, String[] values, int timeout, TimeUnit timeUnit) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public int insertList(String key, int index, String[] values) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public String[] getList(String key) {
        return this.getList(key, 0, Integer.MAX_VALUE);
    }

    /*
     * Exception decompiling
     */
    @Override
    public String[] getList(String key, int index, int length) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void setListObject(String key, int index, String value) {
        try (TraceSpan span = Tracer.create((String)TRACE_NAME, (String)"setListObject");
             Auditable audit = Audit.audit((String)AUDIT_NAMES, (Object[])new Object[]{"setListObject", key, index});){
            span.addTag("key", key);
            span.addTag(VALUE, TruncateUtils.truncateValue(value));
            span.addTag(INDEX, "" + index);
            byte[] byteKey = key.getBytes(StandardCharsets.UTF_8);
            byte[] byteValue = this.cacheValueLimiter.checkAndEncodeStringValue(key, value);
            CacheLimiter.checkCountTotalSize(value);
            this.doJedisRequest(jedis -> jedis.lset(byteKey, (long)index, byteValue), "lset", key, index, value);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public String getListObject(String key, int index) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void removeListObject(String key, int index) {
        this.removeListObjects(key, index, 1);
    }

    @Override
    public void removeListObjects(String key, int index, int length) {
        CacheLimiter.checkCount();
        try (TraceSpan span = Tracer.create((String)TRACE_NAME, (String)"removeListObjects");
             Auditable audit = Audit.audit((String)AUDIT_NAMES, (Object[])new Object[]{"removeListObjects", key, index, length});){
            span.addTag("key", key);
            span.addTag(INDEX, "" + index);
            span.addTag("length", "" + length);
            String payload = "${del}";
            this.doJedisRequest(jedis -> {
                if (jedis.exists(key).booleanValue()) {
                    for (int i = 0; i < length; ++i) {
                        jedis.lset(key, (long)(i + index), payload);
                    }
                    jedis.lrem(key, (long)length, payload);
                }
            }, "exists|lset|lrem", key, index, length);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public int getListLength(String key) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public long inc(String key, int timeout, TimeUnit timeUnit) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public long inc(String key) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public long incrBy(String key, int amount) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public long decr(String key, int timeout, TimeUnit timeUnit) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public long decr(String key) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public int addToSet(String key, String[] values) {
        return this.addToSet(key, values, this.getDefaultTimeout());
    }

    /*
     * Exception decompiling
     */
    @Override
    public int addToSet(String key, String[] values, int timeout, TimeUnit timeUnit) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void removeSetValues(String key, String[] values) {
        CacheLimiter.checkCount();
        try (TraceSpan span = Tracer.create((String)TRACE_NAME, (String)"removeSetValues");
             Auditable audit = Audit.audit((String)AUDIT_NAMES, (Object[])new Object[]{"removeSetValues", key});){
            span.addTag("key", key);
            span.addTag(VALUES, TruncateUtils.truncateValues(values));
            this.doJedisRequest(jedis -> jedis.srem(key, values), "srem", key, values);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public int getSetLength(String key) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public String[] getSetValues(String key) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void put(byte[] key, byte[] value) {
        this.put(key, value, this.getDefaultTimeout());
    }

    @Override
    public void put(byte[] key, byte[] value, int timeout) {
        this.cacheValueLimiter.checkByteValue(key, value);
        CacheLimiter.checkCountTotalSize(key);
        CacheLimiter.checkCountTotalSize(value);
        int timeoutSeconds = this.toExpireTime(timeout, TimeUnit.SECONDS);
        try (TraceSpan span = Tracer.create((String)TRACE_NAME, (String)"putbyte");
             Auditable audit = Audit.audit((String)AUDIT_NAMES, (Object[])new Object[]{"putbyte", key});){
            span.addTag("timeout", "" + timeoutSeconds);
            this.doJedisRequest(jedis -> jedis.setex(key, timeoutSeconds, value), "putbyte", key, value, timeoutSeconds);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public byte[] get(byte[] key) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void hset(String key, byte[] field, byte[] value) {
        this.hset(key.getBytes(StandardCharsets.UTF_8), field, value);
    }

    @Override
    public void hset(String key, byte[] field, byte[] value, int timeoutSeconds) {
        this.hset(key.getBytes(StandardCharsets.UTF_8), field, value, timeoutSeconds);
    }

    @Override
    public void hmset(String key, Map<byte[], byte[]> hash) {
        this.hmset(key.getBytes(StandardCharsets.UTF_8), hash);
    }

    @Override
    public void hmset(String key, Map<byte[], byte[]> hash, int timeoutSeconds) {
        this.hmset(key.getBytes(StandardCharsets.UTF_8), hash, timeoutSeconds);
    }

    @Override
    public byte[] hget(String key, byte[] field) {
        return this.hget(key.getBytes(StandardCharsets.UTF_8), field);
    }

    @Override
    public Map<byte[], byte[]> hgetAll(String key) {
        return this.hgetAll(key.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public List<byte[]> hmget(String key, byte[] ... fields) {
        return this.hmget(key.getBytes(StandardCharsets.UTF_8), fields);
    }

    @Override
    public void put(String key, byte[] value) {
        this.put(key.getBytes(StandardCharsets.UTF_8), value);
    }

    @Override
    public void put(String key, byte[] value, int timeoutSeconds) {
        this.put(key.getBytes(StandardCharsets.UTF_8), value, timeoutSeconds);
    }

    @Override
    public byte[] getByteValue(String key) {
        return this.get(key.getBytes(StandardCharsets.UTF_8));
    }

    private void hset(byte[] key, byte[] field, byte[] value) {
        this.hset(key, field, value, this.getDefaultTimeout());
    }

    private void hset(byte[] key, byte[] field, byte[] value, int timeoutSeconds) {
        this.cacheValueLimiter.checkByteMapItemValue(key, field, value);
        CacheLimiter.checkCountTotalSize(field);
        CacheLimiter.checkCountTotalSize(value);
        try (TraceSpan span = Tracer.create((String)TRACE_NAME, (String)"hset");
             Auditable audit = Audit.audit((String)AUDIT_NAMES, (Object[])new Object[]{"hset", key});){
            this.doJedisRequest(jedis -> {
                jedis.hset(key, field, value);
                this.expireByteKey((JedisClient)jedis, key, timeoutSeconds);
            }, "hset", new Object[]{key});
        }
    }

    public void hmset(byte[] key, Map<byte[], byte[]> hash) {
        this.hmset(key, hash, this.getDefaultTimeout());
    }

    public void hmset(byte[] key, Map<byte[], byte[]> hash, int timeoutSeconds) {
        this.cacheValueLimiter.checkByteMapValue(key, hash);
        CacheLimiter.checkCountTotalByteSize(hash);
        try (TraceSpan span = Tracer.create((String)TRACE_NAME, (String)"hmset");
             Auditable audit = Audit.audit((String)AUDIT_NAMES, (Object[])new Object[]{"hmset", key});){
            this.doJedisRequest(jedis -> {
                jedis.hmset(key, hash);
                this.expireByteKey((JedisClient)jedis, key, timeoutSeconds);
            }, "hmset", new Object[]{key});
        }
    }

    /*
     * Exception decompiling
     */
    public byte[] hget(byte[] key, byte[] field) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public Map<byte[], byte[]> hgetAll(byte[] key) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public List<byte[]> hmget(byte[] key, byte[] ... fields) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void release(JedisClient jedis, boolean isBroken) {
        if (jedis != null) {
            jedis.close();
        }
    }

    private static UnsupportedOperationException unSupportedException(String methodName) {
        return new UnsupportedOperationException(String.format("XCache not supported this method[%s]", methodName));
    }

    private int toExpireTime(int timeout, TimeUnit timeUnit) {
        int expire = (int)timeUnit.toSeconds(timeout);
        if (expire < 0) {
            expire = this.getDefaultTimeout();
        }
        return expire;
    }

    private int getDefaultTimeout() {
        return Integer.getInteger(DEFAULT_TIMEOUT_KEY, DEFAULT_TIMEOUT);
    }

    private static /* synthetic */ List lambda$hmget$41(byte[] key, byte[][] fields, JedisClient jedis) {
        return jedis.hmget(key, fields);
    }

    private static /* synthetic */ Map lambda$hgetAll$40(byte[] key, JedisClient jedis) {
        return jedis.hgetAll(key);
    }

    private static /* synthetic */ byte[] lambda$hget$39(byte[] key, byte[] field, JedisClient jedis) {
        return jedis.hget(key, field);
    }

    private static /* synthetic */ byte[] lambda$get$36(byte[] key, JedisClient jedis) {
        return jedis.get(key);
    }

    private static /* synthetic */ String[] lambda$getSetValues$34(String key, JedisClient jedis) {
        Set members = jedis.smembers(key);
        return members.toArray(new String[members.size()]);
    }

    private static /* synthetic */ Integer lambda$getSetLength$33(String key, JedisClient jedis) {
        return jedis.scard(key).intValue();
    }

    private /* synthetic */ Integer lambda$addToSet$31(byte[] byteKey, byte[][] byteValues, String key, int timeoutSeconds, JedisClient jedis) {
        Long size = jedis.sadd(byteKey, byteValues);
        this._expireKey(jedis, key, timeoutSeconds);
        return size.intValue();
    }

    private static /* synthetic */ Long lambda$decr$30(String key, JedisClient jedis) {
        return jedis.decr(key);
    }

    private /* synthetic */ Long lambda$decr$29(String key, int timeoutSeconds, JedisClient jedis) {
        long v = jedis.decr(key);
        this._expireKey(jedis, key, timeoutSeconds);
        return v;
    }

    private static /* synthetic */ Long lambda$incrBy$28(String key, int amount, JedisClient jedis) {
        return jedis.incrBy(key, (long)amount);
    }

    private static /* synthetic */ Long lambda$inc$27(String key, JedisClient jedis) {
        return jedis.incr(key);
    }

    private /* synthetic */ Long lambda$inc$26(String key, int timeoutSeconds, JedisClient jedis) {
        long v = jedis.incr(key);
        this._expireKey(jedis, key, timeoutSeconds);
        return v;
    }

    private static /* synthetic */ Integer lambda$getListLength$25(String key, JedisClient jedis) {
        return jedis.llen(key).intValue();
    }

    private static /* synthetic */ String lambda$getListObject$23(String key, int index, JedisClient jedis) {
        return jedis.lindex(key, (long)index);
    }

    private static /* synthetic */ String[] lambda$getList$21(String key, int index, long stop, JedisClient jedis) {
        List result = jedis.lrange(key, (long)index, stop);
        return result.toArray(new String[result.size()]);
    }

    private static /* synthetic */ Integer lambda$insertList$20(byte[] byteKey, int index, byte[][] byteValues, String[] values, JedisClient jedis) {
        byte[] byteS = jedis.lindex(byteKey, (long)index);
        if (byteS == null) {
            throw new IndexOutOfBoundsException(String.format("index: %s", index));
        }
        for (int i = byteValues.length - 1; i > -1; --i) {
            jedis.linsert(byteKey, ListPosition.BEFORE, byteS, byteValues[i]);
        }
        return values.length;
    }

    private /* synthetic */ Integer lambda$resetList$19(String key, String[] values, int timeoutSeconds, JedisClient jedis) {
        Long size = 0L;
        jedis.del(key);
        if (values != null && values.length > 0) {
            size = jedis.rpush(key, values);
            this._expireKey(jedis, key, timeoutSeconds);
        }
        return size.intValue();
    }

    private /* synthetic */ Integer lambda$addList$18(byte[] byteKey, byte[][] byteValues, String key, int timeoutSeconds, JedisClient jedis) {
        Long size = jedis.rpush(byteKey, byteValues);
        this._expireKey(jedis, key, timeoutSeconds);
        return size.intValue();
    }

    private static /* synthetic */ List lambda$getKeysWithPrefix$17(String prefix, JedisClient jedis) {
        Set set = jedis.keys(prefix + "*");
        if (set == null || set.isEmpty()) {
            return Collections.emptyList();
        }
        return Lists.newArrayList((Iterable)set);
    }

    private static /* synthetic */ List lambda$getKeysWithPrefix$16(String type, String prefix, JedisClient jedis) {
        Set set = jedis.hkeys(type);
        if (set == null) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        if (prefix == null) {
            result.addAll(set);
        } else {
            for (String key : set) {
                if (!key.startsWith(prefix)) continue;
                result.add(key);
            }
        }
        return result;
    }

    private static /* synthetic */ Map lambda$getAll$15(String type, JedisClient jedis) {
        return jedis.hgetAll(type);
    }

    private static /* synthetic */ Boolean lambda$contains$13(String type, String key, JedisClient jedis) {
        return jedis.hexists(type, key);
    }

    private static /* synthetic */ String lambda$get$11(String type, String key, JedisClient jedis) {
        return jedis.hget(type, key);
    }

    private static /* synthetic */ Boolean lambda$contains$9(String key, JedisClient jedis) {
        return jedis.exists(key);
    }

    private static /* synthetic */ List lambda$get$3(String type, String[] keys, JedisClient jedis) {
        return jedis.hmget(type, keys);
    }

    private static /* synthetic */ String lambda$get$2(String key, JedisClient jedis) {
        return jedis.get(key);
    }
}

