/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cache.redis.backendcheck;

import java.lang.reflect.Method;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.LockSupport;
import kd.bos.cache.redis.backendcheck.ClusterJedisScanClient;
import kd.bos.cache.redis.backendcheck.JedisScanClient;
import kd.bos.cache.redis.backendcheck.ScanClient;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.redis.RedisFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;
import redis.clients.jedis.ShardedJedis;

public class RedisBackendCheckService {
    private static Log log = LogFactory.getLog(RedisBackendCheckService.class);
    public static final String DEFAULT_DATE = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE_YYYY_MM_DD = "yyyy-MM-dd";
    private static Set<String> redisUrls = new HashSet<String>(2);
    private static volatile boolean isStop = false;
    private static String ENABLE_KEY = "redis.backendcheck.enable";
    private static String STARTAT_KEY = "redis.backendcheck.startat";
    private static String RUNNINGAPPID_KEY = "redis.backendcheck.run.appid";
    private static String PERIOD_KEY = "redis.backendcheck.period.second";
    private static String SCANSIZE_KEY = "redis.backendcheck.scansize";
    private static Method registerByMapMethod;
    private static Class<?> backendTaskManageClass;

    public static synchronized void register(String redisUrl, long defaltTimeOut) {
        if (!"true".equals(System.getProperty(ENABLE_KEY, "true"))) {
            return;
        }
        if (redisUrls.add(redisUrl)) {
            HashMap<String, Object> taskProperties = new HashMap<String, Object>(4);
            long periodSecond = Integer.getInteger(PERIOD_KEY, 86400).intValue();
            long initDelay = RedisBackendCheckService.getTimeMillis(System.getProperty(STARTAT_KEY, "01:00:00")) - System.currentTimeMillis();
            initDelay = initDelay > 0L ? initDelay : 86400000L + initDelay;
            String runappidStr = System.getProperty(RUNNINGAPPID_KEY, "bos");
            String[] runappIds = runappidStr.split(",|;");
            HashSet<String> appIds = new HashSet<String>(2);
            for (String runAppid : runappIds) {
                appIds.add(runAppid);
            }
            String reidsUrlForShow = redisUrl;
            int index = reidsUrlForShow.indexOf("/");
            if (index > 0) {
                reidsUrlForShow = reidsUrlForShow.substring(0, index);
            }
            taskProperties.put("runAppids", appIds);
            taskProperties.put("taskId", RedisBackendCheckService.class.getSimpleName() + reidsUrlForShow);
            taskProperties.put("delaySecond", initDelay / 1000L);
            taskProperties.put("periodSecond", periodSecond);
            taskProperties.put("isSingleTask", true);
            Runnable rtask = () -> {
                Object clientObj = RedisFactory.$getJedisClientOriginal((String)redisUrl);
                String scan_start = ScanParams.SCAN_POINTER_START;
                ScanParams scanParams = new ScanParams().count(Integer.getInteger(SCANSIZE_KEY, 10000));
                if (clientObj instanceof Jedis || clientObj instanceof JedisCluster) {
                    try (ScanClient scanclient = clientObj instanceof Jedis ? new JedisScanClient((Jedis)clientObj) : new ClusterJedisScanClient((JedisCluster)clientObj);){
                        log.info("begin this backendcheck task");
                        int totalkeys = 0;
                        while (!isStop) {
                            ScanResult<String> scanResult = scanclient.scan(scan_start, scanParams);
                            List keysLs = scanResult.getResult();
                            log.info("doing this backendcheck task:" + (totalkeys += keysLs.size()));
                            scan_start = scanResult.getCursor();
                            try {
                                LockSupport.parkNanos(10000000000L);
                                RedisBackendCheckService.scanKeys(scanclient, keysLs, defaltTimeOut);
                            }
                            catch (Exception e) {
                                log.info(e.getMessage(), (Object)e);
                            }
                            if (!ScanParams.SCAN_POINTER_START.endsWith(scan_start)) continue;
                        }
                        log.info("finish this backendcheck task");
                    }
                    catch (Throwable e) {
                        log.error("doing this backendcheck error", e);
                    }
                } else if (clientObj instanceof ShardedJedis) {
                    log.info(" this backendcheck task not support in ShardedJedis");
                    ShardedJedis jedis = (ShardedJedis)clientObj;
                    jedis.close();
                }
            };
            try {
                registerByMapMethod.invoke(backendTaskManageClass, taskProperties, rtask);
            }
            catch (Exception e) {
                log.error("invoke registerByMap error", (Throwable)e);
            }
        }
    }

    private static void scanKeys(ScanClient scanclient, List<String> keysLs, long defaltTimeOut) {
        if (scanclient.isSupportEval()) {
            int batchSize = scanclient.batchSize();
            ArrayList<String> args = new ArrayList<String>(2);
            ArrayList<String> keys = new ArrayList<String>(2);
            args.add(String.valueOf(defaltTimeOut));
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < keysLs.size(); ++i) {
                keys.add(keysLs.get(i));
                int j = keys.size();
                sb.append("local keytype = redis.call('type',KEYS[").append(j).append("]).ok;");
                sb.append(" if keytype=='list' or  keytype=='set' or keytype=='zset' or keytype=='hash' ");
                sb.append("then  local keyttl = tonumber(redis.call('ttl',KEYS[").append(j).append("])); ");
                sb.append(" if keyttl==-1 then redis.call('expire',KEYS[").append(j).append("],tonumber(ARGV[1])) ");
                sb.append("end ");
                sb.append(" end ;");
                if (j < batchSize) continue;
                scanclient.eval(sb.toString(), keys, args);
                sb.setLength(0);
                keys.clear();
                LockSupport.parkNanos(10000L * (long)batchSize);
            }
            if (keys.size() > 0) {
                scanclient.eval(sb.toString(), keys, args);
            }
        } else {
            HashSet<String> keys = new HashSet<String>(2);
            for (String key : keysLs) {
                String type = scanclient.type(key);
                if (!"list".equals(type) && !"set".equals(type) && !"zset".equals(type) && !"hash".equals(type)) continue;
                keys.add(key);
            }
            for (String key : keys) {
                Long ttl = scanclient.ttl(key);
                if (ttl != -1L) continue;
                scanclient.expire(key, defaltTimeOut);
            }
        }
    }

    public static void stop() {
        isStop = true;
    }

    private static long getTimeMillis(String time) {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat(DEFAULT_DATE);
            SimpleDateFormat dayFormat = new SimpleDateFormat(DATE_YYYY_MM_DD);
            Date curDate = dateFormat.parse(dayFormat.format(new Date()) + " " + time);
            return curDate.getTime();
        }
        catch (ParseException e) {
            log.error("getTimeMillis ParseException error", (Throwable)e);
            return 0L;
        }
    }

    static {
        try {
            Method[] methods;
            backendTaskManageClass = Class.forName("kd.bos.framework.task.BackendTaskManage");
            for (Method m : methods = backendTaskManageClass.getDeclaredMethods()) {
                if (!m.getName().equals("registerByMap")) continue;
                registerByMapMethod = m;
                break;
            }
        }
        catch (Exception e) {
            log.error("get method registerByMap error", (Throwable)e);
        }
    }
}

