/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cache.redis.lua;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.redis.JedisClient;

public class LuaManager {
    public static void hmset(JedisClient jedis, String type, Map<String, String> keyValues, int timeout) {
        if (null == keyValues || keyValues.isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("redis.call('hmset',KEYS[1]");
        int i = 2;
        ArrayList<String> list = new ArrayList<String>(8);
        list.add(String.valueOf(timeout));
        for (Map.Entry<String, String> entry : keyValues.entrySet()) {
            list.add(entry.getKey());
            list.add(entry.getValue());
            sb.append(",ARGV[");
            sb.append(i);
            sb.append("],ARGV[");
            sb.append(i + 1);
            sb.append("]");
            i += 2;
        }
        String hLua = sb.append(") return redis.call('expire', KEYS[1], ARGV[1])").toString();
        try {
            jedis.eval(hLua, type, list);
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.redisWrite, "LuaManager.hmset error,hLua:" + hLua + ",type:" + type + ",list:" + list, (Throwable)e);
        }
    }

    public static void hset(JedisClient jedis, String type, String key, String value, int timeout) {
        String hLua = "redis.call('hset',KEYS[1],ARGV[1],ARGV[2])\nreturn redis.call('expire', KEYS[1], ARGV[3])\n";
        try {
            jedis.eval(hLua, type, Arrays.asList(key, value, String.valueOf(timeout)));
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.redisWrite, "LuaManager.hset error,hLua:" + hLua + ",key:" + key + ",value:" + value, (Throwable)e);
        }
    }

    public static Long rpush(JedisClient jedis, String key, String[] values, int timeout) {
        if (null == values || values.length == 0) {
            return 0L;
        }
        StringBuilder rsb = new StringBuilder();
        rsb.append("local num = redis.call('rpush',KEYS[1]");
        ArrayList<String> rlist = new ArrayList<String>(8);
        rlist.add(String.valueOf(timeout));
        for (int i = 0; i < values.length; ++i) {
            rsb.append(",ARGV[");
            rsb.append(i + 2);
            rsb.append("]");
            rlist.add(values[i]);
        }
        String rlua = rsb.append(") redis.call('expire', KEYS[1], ARGV[1]) return num").toString();
        try {
            return (Long)jedis.eval(rlua, key, rlist);
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.redisWrite, "LuaManager.rpush error,rlua:" + rlua + ",key:" + key + ",values:" + Arrays.toString(values), (Throwable)e);
        }
    }

    public static Long sadd(JedisClient jedis, String key, String[] values, int timeout) {
        if (null == values || values.length == 0) {
            return 0L;
        }
        StringBuilder rsb = new StringBuilder();
        rsb.append("local num = redis.call('sadd',KEYS[1]");
        ArrayList<String> rlist = new ArrayList<String>(8);
        rlist.add(String.valueOf(timeout));
        for (int i = 0; i < values.length; ++i) {
            rsb.append(",ARGV[");
            rsb.append(i + 2);
            rsb.append("]");
            rlist.add(values[i]);
        }
        String slua = rsb.append(") redis.call('expire', KEYS[1], ARGV[1]) return num").toString();
        try {
            return (Long)jedis.eval(slua, key, rlist);
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.redisWrite, "LuaManager.rpush error,slua:" + slua + ",key:" + key + ",values:" + Arrays.toString(values), (Throwable)e);
        }
    }

    public static Long incr(JedisClient jedis, String key, int timeout) {
        String iLua = "local num = redis.call('incr',KEYS[1])\nredis.call('expire', KEYS[1], ARGV[1]) return num\n";
        try {
            return (Long)jedis.eval(iLua, key, Collections.singletonList(String.valueOf(timeout)));
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.redisWrite, "LuaManager.incr error,iLua:" + iLua + ",key:" + key, (Throwable)e);
        }
    }

    public static Long decr(JedisClient jedis, String key, int timeout) {
        String dLua = "local num = redis.call('decr',KEYS[1])\nredis.call('expire', KEYS[1], ARGV[1]) return num\n";
        try {
            return (Long)jedis.eval(dLua, key, Collections.singletonList(String.valueOf(timeout)));
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.redisWrite, "LuaManager.decr error,dLua:" + dLua + ",key:" + key, (Throwable)e);
        }
    }

    public static long resetList(JedisClient jedis, String key, String[] values, int timeout) {
        if (null == values || values.length == 0) {
            jedis.del(key);
            return 0L;
        }
        ArrayList<String> rlist = new ArrayList<String>(8);
        for (int i = 0; i < values.length; ++i) {
            rlist.add(values[i]);
        }
        rlist.add(String.valueOf(timeout));
        StringBuilder rsb = new StringBuilder();
        rsb.append("redis.call('del', KEYS[1])\n");
        rsb.append("local totalArgs = #ARGV-1\n");
        rsb.append("local batchSize = 1000\n");
        rsb.append("local count=0\n");
        rsb.append("for i = 1, totalArgs, batchSize do\n");
        rsb.append("count = count+redis.call('rpush', KEYS[1], unpack(ARGV, i, math.min(i + batchSize - 1, totalArgs)))\n");
        rsb.append("end\n");
        rsb.append("redis.call('expire', KEYS[1], ARGV[#ARGV])\n");
        rsb.append("return count");
        String rlua = rsb.toString();
        try {
            return (Long)jedis.eval(rlua, key, rlist);
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.redisWrite, "LuaManager.rpush error,rlua:" + rlua + ",key:" + key + ",values:" + Arrays.toString(values), (Throwable)e);
        }
    }
}

