/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cache.redis.pipeline;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.cache.redis.pipeline.ClusterJedisPipeLine;
import kd.bos.cache.redis.pipeline.CommonJedisPipeLine;
import kd.bos.cache.redis.pipeline.PipeLine;
import kd.bos.cache.redis.pipeline.ShardedJedisPipeLine;
import kd.bos.redis.JedisClient;
import kd.bos.redis.wrapper.ClusterJedisClient;
import kd.bos.redis.wrapper.CommonJedisClient;
import kd.bos.redis.wrapper.MultiJedisClient;
import kd.bos.redis.wrapper.ShardedJedisClient;
import redis.clients.jedis.GeoCoordinate;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.PipelineBase;
import redis.clients.jedis.StreamEntry;
import redis.clients.jedis.StreamEntryID;
import redis.clients.jedis.StreamPendingEntry;
import redis.clients.jedis.StreamPendingSummary;
import redis.clients.jedis.Tuple;
import redis.clients.jedis.params.GeoAddParams;
import redis.clients.jedis.params.GetExParams;
import redis.clients.jedis.params.LPosParams;
import redis.clients.jedis.params.RestoreParams;
import redis.clients.jedis.params.StrAlgoLCSParams;
import redis.clients.jedis.params.XAddParams;
import redis.clients.jedis.params.XAutoClaimParams;
import redis.clients.jedis.params.XClaimParams;
import redis.clients.jedis.params.XPendingParams;
import redis.clients.jedis.params.XTrimParams;
import redis.clients.jedis.params.ZAddParams;
import redis.clients.jedis.resps.KeyedListElement;
import redis.clients.jedis.resps.LCSMatchResult;

public class MultiJedisPipeLine
extends PipeLine {
    private MultiJedisClient jedis;
    private Map<String, JedisClient> jedisMap = new ConcurrentHashMap<String, JedisClient>();
    private Map<String, PipeLine> pipilineMap = new ConcurrentHashMap<String, PipeLine>();
    private List<String> commondOrder = new ArrayList<String>();

    public MultiJedisPipeLine(MultiJedisClient multiJedisClient) {
        this.jedis = multiJedisClient;
        this.init(multiJedisClient);
    }

    private void init(MultiJedisClient client) {
        Map nodeMap;
        this.jedisMap = nodeMap = client.getAllJedisClient();
        PipeLine pipeLine = null;
        for (Map.Entry entry : nodeMap.entrySet()) {
            String url = (String)entry.getKey();
            JedisClient jedis = (JedisClient)entry.getValue();
            if (jedis instanceof CommonJedisClient) {
                pipeLine = new CommonJedisPipeLine((CommonJedisClient)jedis);
            } else if (jedis instanceof ShardedJedisClient) {
                pipeLine = new ShardedJedisPipeLine((ShardedJedisClient)jedis);
            } else if (jedis instanceof ClusterJedisClient) {
                pipeLine = new ClusterJedisPipeLine((ClusterJedisClient)jedis);
            }
            if (pipeLine == null) continue;
            this.pipilineMap.put(url, pipeLine);
        }
    }

    @Override
    public List<Object> syncAndReturn() {
        Object[] o = new Object[this.commondOrder.size()];
        ArrayList<Object> list = new ArrayList<Object>();
        this.pipilineMap.forEach((k, v) -> {
            List<Object> ls = v.syncAndReturn();
            list.addAll(ls);
            int j = 0;
            for (int i = 0; i < this.commondOrder.size(); ++i) {
                if (!this.commondOrder.get(i).equals(k)) continue;
                o[i] = ls.get(j++);
            }
        });
        this.commondOrder.clear();
        this.jedisMap.forEach((k, v) -> v.close());
        return list;
    }

    protected Pipeline getPipeline(String key) {
        String node = this.jedis.routeNode(key);
        this.commondOrder.add(node);
        PipelineBase base = this.pipilineMap.get(node).getPipeline(key);
        return (Pipeline)base;
    }

    @Override
    protected JedisClient getJedisClient() {
        return this.jedis;
    }

    public byte[] getDel(byte[] key) {
        return new byte[0];
    }

    public byte[] getEx(byte[] key, GetExParams params) {
        return new byte[0];
    }

    public String restore(byte[] key, long ttl, byte[] serializedValue) {
        return null;
    }

    public String restoreReplace(byte[] key, long ttl, byte[] serializedValue) {
        return null;
    }

    public String restore(byte[] key, long ttl, byte[] serializedValue, RestoreParams params) {
        return null;
    }

    public Long expire(byte[] key, long seconds) {
        return null;
    }

    public String setex(byte[] key, long seconds, byte[] value) {
        return null;
    }

    public byte[] hrandfield(byte[] key) {
        return new byte[0];
    }

    public List<byte[]> hrandfield(byte[] key, long count) {
        return null;
    }

    public Map<byte[], byte[]> hrandfieldWithValues(byte[] key, long count) {
        return null;
    }

    public List<byte[]> lpop(byte[] key, int count) {
        return null;
    }

    public Long lpos(byte[] key, byte[] element) {
        return null;
    }

    public Long lpos(byte[] key, byte[] element, LPosParams params) {
        return null;
    }

    public List<Long> lpos(byte[] key, byte[] element, LPosParams params, long count) {
        return null;
    }

    public List<byte[]> rpop(byte[] key, int count) {
        return null;
    }

    public List<Boolean> smismember(byte[] key, byte[] ... members) {
        return null;
    }

    public Double zaddIncr(byte[] key, double score, byte[] member, ZAddParams params) {
        return null;
    }

    public byte[] zrandmember(byte[] key) {
        return new byte[0];
    }

    public Set<byte[]> zrandmember(byte[] key, long count) {
        return null;
    }

    public Set<Tuple> zrandmemberWithScores(byte[] key, long count) {
        return null;
    }

    public List<Double> zmscore(byte[] key, byte[] ... members) {
        return null;
    }

    public Long geoadd(byte[] key, GeoAddParams params, Map<byte[], GeoCoordinate> memberCoordinateMap) {
        return null;
    }

    public byte[] xadd(byte[] key, Map<byte[], byte[]> hash, XAddParams params) {
        return new byte[0];
    }

    public List<byte[]> xrange(byte[] key, byte[] start, byte[] end) {
        return null;
    }

    public List<byte[]> xrange(byte[] key, byte[] start, byte[] end, int count) {
        return null;
    }

    public List<byte[]> xrevrange(byte[] key, byte[] end, byte[] start) {
        return null;
    }

    public Long xtrim(byte[] key, XTrimParams params) {
        return null;
    }

    public Object xpending(byte[] key, byte[] groupname) {
        return null;
    }

    public List<Object> xpending(byte[] key, byte[] groupname, XPendingParams params) {
        return null;
    }

    public List<byte[]> xclaim(byte[] key, byte[] group, byte[] consumername, long minIdleTime, XClaimParams params, byte[] ... ids) {
        return null;
    }

    public List<byte[]> xclaimJustId(byte[] key, byte[] group, byte[] consumername, long minIdleTime, XClaimParams params, byte[] ... ids) {
        return null;
    }

    public List<Object> xautoclaim(byte[] key, byte[] groupName, byte[] consumerName, long minIdleTime, byte[] start, XAutoClaimParams params) {
        return null;
    }

    public List<Object> xautoclaimJustId(byte[] key, byte[] groupName, byte[] consumerName, long minIdleTime, byte[] start, XAutoClaimParams params) {
        return null;
    }

    public Object xinfoStreamBinary(byte[] key) {
        return null;
    }

    public List<Object> xinfoGroupBinary(byte[] key) {
        return null;
    }

    public List<Object> xinfoConsumersBinary(byte[] key, byte[] group) {
        return null;
    }

    public LCSMatchResult strAlgoLCSStrings(byte[] strA, byte[] strB, StrAlgoLCSParams params) {
        return null;
    }

    public String getDel(String key) {
        return null;
    }

    public String getEx(String key, GetExParams params) {
        return null;
    }

    public String restore(String key, long ttl, byte[] serializedValue) {
        return null;
    }

    public String restoreReplace(String key, long ttl, byte[] serializedValue) {
        return null;
    }

    public String restore(String key, long ttl, byte[] serializedValue, RestoreParams params) {
        return null;
    }

    public Long expire(String key, long seconds) {
        return null;
    }

    public String setex(String key, long seconds, String value) {
        return null;
    }

    public String hrandfield(String key) {
        return null;
    }

    public List<String> hrandfield(String key, long count) {
        return null;
    }

    public Map<String, String> hrandfieldWithValues(String key, long count) {
        return null;
    }

    public List<String> lpop(String key, int count) {
        return null;
    }

    public Long lpos(String key, String element) {
        return null;
    }

    public Long lpos(String key, String element, LPosParams params) {
        return null;
    }

    public List<Long> lpos(String key, String element, LPosParams params, long count) {
        return null;
    }

    public List<String> rpop(String key, int count) {
        return null;
    }

    public List<Boolean> smismember(String key, String ... members) {
        return null;
    }

    public Double zaddIncr(String key, double score, String member, ZAddParams params) {
        return null;
    }

    public String zrandmember(String key) {
        return null;
    }

    public Set<String> zrandmember(String key, long count) {
        return null;
    }

    public Set<Tuple> zrandmemberWithScores(String key, long count) {
        return null;
    }

    public List<Double> zmscore(String key, String ... members) {
        return null;
    }

    public KeyedListElement blpop(double timeout, String key) {
        return null;
    }

    public KeyedListElement brpop(double timeout, String key) {
        return null;
    }

    public Long geoadd(String key, GeoAddParams params, Map<String, GeoCoordinate> memberCoordinateMap) {
        return null;
    }

    public StreamEntryID xadd(String key, Map<String, String> hash, XAddParams params) {
        return null;
    }

    public List<StreamEntry> xrange(String key, StreamEntryID start, StreamEntryID end) {
        return null;
    }

    public List<StreamEntry> xrevrange(String key, StreamEntryID end, StreamEntryID start) {
        return null;
    }

    public StreamPendingSummary xpending(String key, String groupname) {
        return null;
    }

    public List<StreamPendingEntry> xpending(String key, String groupname, XPendingParams params) {
        return null;
    }

    public long xtrim(String key, XTrimParams params) {
        return 0L;
    }

    public List<StreamEntry> xclaim(String key, String group, String consumername, long minIdleTime, XClaimParams params, StreamEntryID ... ids) {
        return null;
    }

    public List<StreamEntryID> xclaimJustId(String key, String group, String consumername, long minIdleTime, XClaimParams params, StreamEntryID ... ids) {
        return null;
    }

    public Map.Entry<StreamEntryID, List<StreamEntry>> xautoclaim(String key, String group, String consumerName, long minIdleTime, StreamEntryID start, XAutoClaimParams params) {
        return null;
    }

    public Map.Entry<StreamEntryID, List<StreamEntryID>> xautoclaimJustId(String key, String group, String consumerName, long minIdleTime, StreamEntryID start, XAutoClaimParams params) {
        return null;
    }

    public LCSMatchResult strAlgoLCSStrings(String strA, String strB, StrAlgoLCSParams params) {
        return null;
    }
}

