/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cache.tempfile.extesion;

import java.util.ArrayList;
import java.util.List;
import kd.bos.cache.tempfile.extesion.DefaultTempFileCacheExtImpl;
import kd.bos.cache.tempfile.extesion.TempFileCacheExt;
import kd.bos.cache.tempfile.extesion.TempFileCacheExtFilter;
import kd.bos.cache.tempfile.extesion.TempFileCacheExtHandler;
import kd.bos.cache.tempfile.filter.AlgoTempFileFilter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class TempFileCacheExtHandlerFactory {
    private static Log logger = LogFactory.getLog(TempFileCacheExtHandlerFactory.class);
    private static final String CLASSNAME_KEY = "tempfilecache.extension.impl.classname";

    public static TempFileCacheExtHandler createHandler() {
        TempFileCacheExt tempFileCacheExt;
        boolean isDefault = false;
        String className = System.getProperty(CLASSNAME_KEY, "");
        if (!className.isEmpty()) {
            try {
                tempFileCacheExt = (TempFileCacheExt)Class.forName(className).newInstance();
            }
            catch (Exception e) {
                logger.error("create instance failed, class:" + className + " error:", (Throwable)e);
                tempFileCacheExt = new DefaultTempFileCacheExtImpl();
                isDefault = true;
            }
        } else {
            tempFileCacheExt = new DefaultTempFileCacheExtImpl();
            isDefault = true;
        }
        List<TempFileCacheExtFilter> filters = TempFileCacheExtHandlerFactory.getDefaultFilters();
        return new TempFileCacheExtHandler(isDefault, tempFileCacheExt, filters);
    }

    private static List<TempFileCacheExtFilter> getDefaultFilters() {
        ArrayList<TempFileCacheExtFilter> filters = new ArrayList<TempFileCacheExtFilter>();
        filters.add(new AlgoTempFileFilter());
        return filters;
    }
}

