/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.id;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import kd.bos.bundle.Resources;
import kd.bos.id.IDRange;
import kd.bos.id.IDService;
import kd.bos.id.IDServiceAssignerConfig;
import kd.bos.id.IDServiceLog;
import kd.bos.id.worker.WorkerAssigner;
import kd.bos.id.worker.WorkerAssignerFactory;
import kd.bos.id.worker.service.CleanExpireWorkerIdService;
import kd.bos.lock.DLockUtil;

public final class IDServiceAssignerImpl
implements IDService {
    private final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private final AtomicBoolean terminated = new AtomicBoolean(false);
    private final AtomicInteger noWaitRound = new AtomicInteger();
    private final BlockingQueue<WorkerAssigner> freeWorkerQueue;
    private final List<WorkerAssigner> allWorkerList;
    private final String groupId = UUID.randomUUID().toString();
    private final AtomicLong genTimes = new AtomicLong();
    private final Date startTime;
    private final Date startupTime;
    private int workerCount;
    private final Object stopSemaphoreLock = new byte[0];
    private final IDServiceAssignerConfig idServiceAssignerConfig;

    public IDServiceAssignerImpl(IDServiceAssignerConfig idServiceAssignerConfig) {
        this.idServiceAssignerConfig = idServiceAssignerConfig;
        this.startTime = new Date();
        this.workerCount = idServiceAssignerConfig.getGroupWorkers();
        IDServiceLog.debug(Resources.get((String)"bos-id", (String)"IDServiceImpl_0", (String)"Start IDService: ", (Object[])new Object[0]) + "WorkerCount=" + this.workerCount + "...");
        this.freeWorkerQueue = new LinkedBlockingQueue<WorkerAssigner>(1000);
        this.allWorkerList = new ArrayList<WorkerAssigner>(this.workerCount);
        for (int i = 0; i < this.workerCount; ++i) {
            WorkerAssigner workerIdAssigner = WorkerAssignerFactory.getInstance().getWorkerIdAssigner(idServiceAssignerConfig);
            this.freeWorkerQueue.add(workerIdAssigner);
        }
        this.allWorkerList.addAll(this.freeWorkerQueue);
        TreeSet<Integer> workerIdSet = new TreeSet<Integer>();
        for (WorkerAssigner worker : this.allWorkerList) {
            workerIdSet.add(worker.getWorkerId());
        }
        IDServiceLog.debug(Resources.get((String)"bos-id", (String)"IDServiceImpl_1", (String)"IDService started: GroupId=", (Object[])new Object[0]) + this.groupId + ", WorkerId=" + workerIdSet + ".");
        this.startupTime = new Date();
        this.startLogStatus();
        CleanExpireWorkerIdService.getInstance().start(idServiceAssignerConfig);
    }

    private void startLogStatus() {
        int logStatusInterval = this.idServiceAssignerConfig.getLogStatusInterval();
        if (logStatusInterval > 0) {
            Thread t = new Thread(() -> {
                while (!this.terminated.get()) {
                    IDServiceLog.debug(this.getStatus());
                    Object object = this.stopSemaphoreLock;
                    synchronized (object) {
                        try {
                            this.stopSemaphoreLock.wait(logStatusInterval);
                        }
                        catch (InterruptedException e) {
                            break;
                        }
                    }
                }
            });
            t.setName("ID-Assigner-Worker-LOG");
            t.setDaemon(true);
            t.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T gen(CallWorker<T> cw, boolean noWait) {
        if (this.terminated.get()) {
            throw new IllegalStateException(Resources.getString((String)"bos-id", (String)"IDServiceImpl_3", (Object[])new Object[0]) + this.groupId + ")");
        }
        this.genTimes.incrementAndGet();
        if (noWait) {
            if (this.workerCount == 1) {
                return cw.genId(this.allWorkerList.get(0));
            }
            if (this.workerCount != 0) return cw.genId(this.allWorkerList.get(Math.abs(this.noWaitRound.getAndIncrement() % this.workerCount)));
            throw new IllegalStateException(Resources.getString((String)"bos-id", (String)"IDServiceImpl_4", (Object[])new Object[0]) + this.groupId + ")");
        }
        try {
            WorkerAssigner workerAssigner = this.freeWorkerQueue.take();
            try {
                T t = cw.genId(workerAssigner);
                return t;
            }
            finally {
                this.freeWorkerQueue.put(workerAssigner);
            }
        }
        catch (Exception e) {
            throw DLockUtil.asRuntimeException(e);
        }
    }

    @Override
    public int genIntId(String tenantId, String tablename) {
        return this.gen(w -> w.genIntId(tenantId, tablename), false);
    }

    @Override
    public int[] genIntIds(String tenantId, String tablename, int count) {
        return this.gen(w -> w.genIntIds(tenantId, tablename, count), false);
    }

    @Override
    public long genLongId() {
        return this.gen(w -> w.genLongId(), true);
    }

    @Override
    public long[] genLongIds(int count) {
        return this.gen(w -> w.genLongIds(count), true);
    }

    @Override
    public Date getCreateTime(long id) {
        return this.gen(w -> w.getCreateTime(id), true);
    }

    @Override
    public IDRange getIDRangeOfDay(Date date) {
        return this.gen(w -> w.getIDRangeOfDay(date), true);
    }

    @Override
    public String getStatus() {
        StringBuilder ss = new StringBuilder(1024);
        ss.append("\r\n[conf]");
        ss.append(this.idServiceAssignerConfig.getStatus());
        ss.append("\r\n[group]");
        ss.append("\r\n    groupId=").append(this.groupId);
        ss.append("\r\n    startTime=").append(this.sdf.format(this.startTime));
        ss.append("\r\n    startupTime=").append(this.sdf.format(this.startupTime));
        ss.append("\r\n    active=").append(!this.terminated.get());
        ss.append("\r\n    genTimes=").append(this.genTimes.get());
        ss.append("\r\n    busyWorker=").append(this.allWorkerList.size() - this.freeWorkerQueue.size());
        ss.append("\r\n    healthyWorker=").append(this.allWorkerList.size());
        ss.append("\r\n    deadWorker=").append(this.idServiceAssignerConfig.getGroupWorkers() - this.workerCount);
        int i = 1;
        for (WorkerAssigner worker : this.allWorkerList) {
            ss.append("\r\n[worker-").append(i++).append(']');
            ss.append(worker.getStatus());
        }
        return ss.toString();
    }

    private static interface CallWorker<T> {
        public T genId(IDService var1);
    }
}

