/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.id;

import kd.bos.bundle.Resources;
import kd.bos.dlock.CrossCluster;
import kd.bos.id.IDServiceConf;
import kd.bos.zk.ZKFactory;

class IDServiceConf2ZK {
    public static final String idService_store_zookeeper = "IDService.store.zookeeper";
    public static final String idService_store_path = "IDService.store.path";
    public static final String idService_worker = "IDService.worker";
    public static final String idSevice_support_different_zk_clusters_enable = "IDService.support.different.zk.clusters.enable";
    public static final String idService_cluster_number = "IDService.cluster.number";
    public static final String idService_cluster_number_bits = "IDService.cluster.number.bits";
    public static final int default_idService_cluster_number_bits = 3;
    public static final int min_idService_cluster_number_bits = 1;
    public static final int max_idService_cluster_number_bits = 5;

    IDServiceConf2ZK() {
    }

    private static String getRootPath() {
        return "/" + CrossCluster.getClusterNameForPath() + "/runtime/ids";
    }

    public static IDServiceConf conf() {
        IDServiceConf conf = IDServiceConf.createDefault();
        String zookeeper = System.getProperty(idService_store_zookeeper);
        if (zookeeper == null) {
            zookeeper = System.getProperty("configUrl");
        }
        conf.setServer(zookeeper);
        String rootPath = null;
        if (CrossCluster.getClusterNameForPath() != null) {
            rootPath = IDServiceConf2ZK.getRootPath();
        } else {
            rootPath = System.getProperty(idService_store_path);
            if (rootPath == null || rootPath.length() == 0) {
                throw new IllegalArgumentException(Resources.getString((String)"bos-id", (String)"IDServiceConf2ZK_0", (Object[])new Object[0]) + idService_store_zookeeper + "\u3002");
            }
        }
        String zkroot = ZKFactory.getZkRootPath((String)zookeeper);
        rootPath = rootPath.startsWith("/") ? zkroot + rootPath.substring(1) : zkroot + rootPath;
        conf.setRootPath(rootPath);
        String worker = System.getProperty(idService_worker, "0");
        int workers = 0;
        if (worker != null && worker.matches("\\d+")) {
            workers = Integer.parseInt(worker);
        }
        if (workers > 0) {
            conf.setGroupWorkers(workers);
        }
        return conf;
    }

    public static boolean isEnableDifferentCluster() {
        return Boolean.getBoolean(idSevice_support_different_zk_clusters_enable);
    }

    public static int getClusterNumberBits() {
        int clusterNumberBits = Integer.getInteger(idService_cluster_number_bits, 3);
        if (clusterNumberBits < 1 || clusterNumberBits > 5) {
            throw new IllegalStateException(String.format(Resources.getString((String)"bos-id", (String)"IDServiceConf2ZK_2", (Object[])new Object[0]), clusterNumberBits, "[1,5]"));
        }
        return clusterNumberBits;
    }

    public static int getClusterNumber() {
        Integer clusterNumber = Integer.getInteger(idService_cluster_number);
        int minNumber = 0;
        int maxNumber = (1 << IDServiceConf2ZK.getClusterNumberBits()) - 1;
        if (clusterNumber == null || clusterNumber < minNumber || clusterNumber > maxNumber) {
            throw new IllegalStateException(String.format(Resources.getString((String)"bos-id", (String)"IDServiceConf2ZK_1", (Object[])new Object[0]), System.getProperty(idService_cluster_number), "[" + minNumber + "," + maxNumber + "]"));
        }
        return clusterNumber;
    }
}

