/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.id;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import kd.bos.bundle.Resources;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.id.IDRange;
import kd.bos.id.IDService;
import kd.bos.id.IDServiceConf;
import kd.bos.id.IDServiceImplWorker;
import kd.bos.id.IDServiceLog;
import kd.bos.lock.DLockUtil;

class IDServiceImpl
implements IDService,
AutoCloseable {
    private final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private final AtomicBoolean terminaled = new AtomicBoolean(false);
    private final AtomicInteger noWaitRound = new AtomicInteger();
    private final IDServiceConf conf;
    private final BlockingQueue<IDServiceImplWorker> freeWorkerQueue;
    private final List<IDServiceImplWorker> allWorkerList;
    private final String groupId = UUID.randomUUID().toString();
    private final AtomicLong genTimes = new AtomicLong();
    private final Date startTime;
    private final Date startupTime;
    private int workerCount;
    private final Object stopSemaphoreLock = new byte[0];

    @Deprecated
    public IDServiceImpl() {
        this.conf = null;
        this.freeWorkerQueue = null;
        this.allWorkerList = null;
        this.startTime = null;
        this.startupTime = null;
        this.workerCount = 0;
    }

    public IDServiceImpl(IDServiceConf conf) throws KDException {
        this.startTime = new Date();
        this.conf = conf;
        this.workerCount = conf.getGroupWorkers();
        IDServiceLog.debug(Resources.get((String)"bos-id", (String)"IDServiceImpl_0", (String)"Start IDService: ", (Object[])new Object[0]) + "WorkerCount=" + this.workerCount + "...");
        this.freeWorkerQueue = new LinkedBlockingQueue<IDServiceImplWorker>(1000);
        this.allWorkerList = new ArrayList<IDServiceImplWorker>(this.workerCount);
        for (int i = 0; i < this.workerCount; ++i) {
            this.freeWorkerQueue.add(new IDServiceImplWorker(conf, worker -> this.removeWorker(worker), this));
        }
        this.allWorkerList.addAll(this.freeWorkerQueue);
        TreeSet<Integer> workerIdSet = new TreeSet<Integer>();
        for (IDServiceImplWorker worker2 : this.allWorkerList) {
            workerIdSet.add(worker2.getWorkerId());
        }
        IDServiceLog.debug(Resources.get((String)"bos-id", (String)"IDServiceImpl_1", (String)"IDService started: GroupId=", (Object[])new Object[0]) + this.groupId + ", WorkerId=" + workerIdSet + ".");
        this.startupTime = new Date();
        this.startLogStatus();
    }

    private void startLogStatus() {
        final int logStatusInterval = this.conf.getLogStatusInterval();
        if (logStatusInterval > 0) {
            Thread t = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    while (!IDServiceImpl.this.terminaled.get()) {
                        IDServiceLog.debug(IDServiceImpl.this.getStatus());
                        Object object = IDServiceImpl.this.stopSemaphoreLock;
                        synchronized (object) {
                            try {
                                IDServiceImpl.this.stopSemaphoreLock.wait(logStatusInterval);
                            }
                            catch (InterruptedException e) {
                                break;
                            }
                        }
                    }
                }
            };
            t.setDaemon(true);
            t.start();
        }
    }

    private synchronized void removeWorker(IDServiceImplWorker worker) {
        --this.workerCount;
        this.allWorkerList.remove(worker);
        this.freeWorkerQueue.remove(worker);
        IDServiceLog.debug(Resources.getString((String)"bos-id", (String)"IDServiceImpl_2", (Object[])new Object[0]) + worker + "\u3002(GroupId=" + this.groupId + ")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T gen(CallWoker<T> cw, boolean noWait) {
        if (this.terminaled.get()) {
            throw new IllegalStateException(Resources.getString((String)"bos-id", (String)"IDServiceImpl_3", (Object[])new Object[0]) + this.groupId + ")");
        }
        this.genTimes.incrementAndGet();
        if (noWait) {
            if (this.workerCount == 1) {
                return cw.genId(this.allWorkerList.get(0));
            }
            if (this.workerCount != 0) return cw.genId(this.allWorkerList.get(Math.abs(this.noWaitRound.getAndIncrement() % this.workerCount)));
            throw new IllegalStateException(Resources.getString((String)"bos-id", (String)"IDServiceImpl_4", (Object[])new Object[0]) + this.groupId + ")");
        }
        try {
            IDServiceImplWorker ws = this.freeWorkerQueue.take();
            try {
                T t = cw.genId(ws);
                return t;
            }
            finally {
                if (!ws.isClosed()) {
                    this.freeWorkerQueue.put(ws);
                }
            }
        }
        catch (Exception e) {
            throw DLockUtil.asRuntimeException(e);
        }
    }

    @Override
    public int genIntId(String tenantId, String tablename) {
        return this.gen(w -> w.genIntId(tenantId, tablename), false);
    }

    @Override
    public int[] genIntIds(String tenantId, String tablename, int count) {
        return this.gen(w -> w.genIntIds(tenantId, tablename, count), false);
    }

    @Override
    public long genLongId() {
        return this.gen(w -> w.genLongId(), true);
    }

    @Override
    public long[] genLongIds(int count) {
        return this.gen(w -> w.genLongIds(count), true);
    }

    @Override
    public Date getCreateTime(long id) {
        return this.gen(w -> w.getCreateTime(id), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws KDException {
        IDServiceLog.debug(Resources.getString((String)"bos-id", (String)"IDServiceImpl_5", (Object[])new Object[0]) + this.groupId + ")");
        this.terminaled.set(true);
        Object object = this.stopSemaphoreLock;
        synchronized (object) {
            this.stopSemaphoreLock.notifyAll();
        }
        object = this.freeWorkerQueue;
        synchronized (object) {
            while (this.freeWorkerQueue.size() < this.workerCount) {
                try {
                    this.freeWorkerQueue.wait();
                }
                catch (InterruptedException e) {
                    throw new KDException(BosErrorCode.bosId, e.getMessage(), (Throwable)e);
                }
            }
        }
        for (IDServiceImplWorker w : this.freeWorkerQueue) {
            w.close();
        }
        IDServiceLog.debug(Resources.getString((String)"bos-id", (String)"IDServiceImpl_6", (Object[])new Object[0]) + this.getStatus());
        IDServiceLog.debug(Resources.getString((String)"bos-id", (String)"IDServiceImpl_7", (Object[])new Object[0]) + this.groupId + ")");
    }

    @Override
    public String getStatus() {
        StringBuilder ss = new StringBuilder(1024);
        ss.append("\r\n[conf]");
        ss.append(this.conf.getStatus());
        ss.append("\r\n[group]");
        ss.append("\r\n    groupId=").append(this.groupId);
        ss.append("\r\n    startTime=").append(this.sdf.format(this.startTime));
        ss.append("\r\n    startupTime=").append(this.sdf.format(this.startupTime));
        ss.append("\r\n    active=").append(!this.terminaled.get());
        ss.append("\r\n    genTimes=").append(this.genTimes.get());
        ss.append("\r\n    busyWorker=").append(this.allWorkerList.size() - this.freeWorkerQueue.size());
        ss.append("\r\n    healthyWorker=").append(this.allWorkerList.size());
        ss.append("\r\n    deadWorker=").append(this.conf.getGroupWorkers() - this.workerCount);
        int i = 1;
        for (IDServiceImplWorker worker : this.allWorkerList) {
            ss.append("\r\n[worker-").append(i++).append(']');
            ss.append(worker.getStatus());
        }
        return ss.toString();
    }

    public List<IDServiceImplWorker> getAllWorkerList() {
        return Collections.unmodifiableList(this.allWorkerList);
    }

    public String toString() {
        return "IDService-" + this.groupId + ": free=" + this.freeWorkerQueue + " total=" + this.workerCount;
    }

    @Override
    public IDRange getIDRangeOfDay(Date date) {
        return this.gen(w -> w.getIDRangeOfDay(date), true);
    }

    @FunctionalInterface
    static interface CallWoker<T> {
        public T genId(IDService var1);
    }
}

