/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.id;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.bundle.Resources;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.id.IDClockBackStrategy;
import kd.bos.id.IDGenner;
import kd.bos.id.IDRange;
import kd.bos.id.IDService;
import kd.bos.id.IDServiceConf;
import kd.bos.id.IDServiceImpl;
import kd.bos.id.IDServiceLog;
import kd.bos.id.IDWorkerClockChecker;
import kd.bos.lock.DLock;
import kd.bos.lock.DLockHandler;
import kd.bos.lock.DLockListener;
import kd.bos.lock.DLockProvider;
import kd.bos.lock.DLockRestarting;
import kd.bos.lock.DLockUtil;
import kd.bos.util.DisCardUtil;

class IDServiceImplWorker
implements IDService,
DLockListener,
AutoCloseable {
    private final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private IDServiceConf conf;
    private IDGenner genner;
    private DLock lock;
    private int workerId;
    private Map<String, LinkedList<Integer>> cachedIntIdMap = new ConcurrentHashMap<String, LinkedList<Integer>>();
    private final int batchSize;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final AtomicBoolean startupped = new AtomicBoolean(false);
    private CountDownLatch startupCD;
    private IDWorkerClockChecker clockChecker;
    private long lastTimestamp = -1L;
    private long lastCheckTimestamp = -1L;
    private String clockPath;
    private ClockBackHandler removeMeCaseByClockBack;
    private int restartTimes = -1;
    private final AtomicLong genTimes = new AtomicLong();
    private final long reuseDelay;
    private final IDServiceImpl idServiceImpl;

    public IDServiceImplWorker(IDServiceConf conf, ClockBackHandler removeMeCaseByClockBack, IDServiceImpl idServiceImpl) throws KDException {
        this.conf = conf;
        this.removeMeCaseByClockBack = removeMeCaseByClockBack;
        this.idServiceImpl = idServiceImpl;
        this.batchSize = conf.getBatchGenIntSize();
        this.reuseDelay = 1800000L;
        this.restart();
    }

    private void restart() throws KDException {
        this.startupped.set(false);
        this.closed.set(false);
        if (this.startupCD != null) {
            this.startupCD.countDown();
        }
        this.startupCD = new CountDownLatch(1);
        this.lock = DLockProvider.createDLock(this.conf.getLockProvider(), this.conf.getServer(), this.conf.getSessionTimeout(), this);
        try {
            ((DLockRestarting)((Object)this.lock)).restarting(true);
            this.workerId = this.registWorkerId(this.conf.getLongLockPath(), this.conf.getLongWorkerListPath());
            this.clockPath = this.conf.getLongWorkerTimePath(this.workerId);
            this.updateAndCheckClock(true);
            ++this.restartTimes;
            String startupDesc = this.restartTimes == 0 ? "--first startup" : "--restartTimes=" + this.restartTimes;
            this.genner = new IDGenner(this.workerId, this.conf.getSessionTimeout(), startupDesc);
            this.startupped.set(true);
        }
        finally {
            ((DLockRestarting)((Object)this.lock)).restarting(false);
        }
        this.clockChecker = this.startupUpdateAndCheckClock();
        this.startupCD.countDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAndCheckClock(boolean tryCompensate) throws KDException {
        if (((DLockRestarting)((Object)this.lock)).isRestarting()) {
            return;
        }
        this.lastCheckTimestamp = System.currentTimeMillis();
        String v = this.lock.get(this.clockPath);
        if (v != null && v.matches("\\d+")) {
            this.lastTimestamp = Long.parseLong(v);
        }
        if (this.lastTimestamp > this.lastCheckTimestamp) {
            long offset = this.lastTimestamp - this.lastCheckTimestamp;
            if (tryCompensate && offset <= (long)this.conf.getSessionTimeout()) {
                try {
                    IDServiceImplWorker iDServiceImplWorker = this;
                    synchronized (iDServiceImplWorker) {
                        this.wait(offset << 1);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.updateAndCheckClock(false);
                return;
            }
            this.handleOnClockBack(this.lastCheckTimestamp, offset);
        } else {
            this.lock.set(this.clockPath, String.valueOf(this.lastCheckTimestamp));
        }
    }

    private void handleOnClockBack(long now, long offset) throws KDException {
        String msg = this + Resources.get((String)"bos-id", (String)"IDServiceImplWorker_0", (String)"\u65f6\u949f\u88ab\u56de\u62e8%1$sms(%2$s\u6700\u540e\u8bb0\u5f55\u65f6\u95f4\u4e3a%3$s)\uff0c\u8bf7\u7ea0\u6b63\u670d\u52a1\u8282\u70b9\u65f6\u95f4\uff0c\u5f53\u524d\u670d\u52a1\u8282\u70b9\u65f6\u95f4\u4e3a %4$s (%5$sms)\u3002", (Object[])new Object[]{offset, this.clockPath, this.sdf.format(new Date(this.lastTimestamp)), this.sdf.format(now), now});
        IDServiceLog.debug(msg);
        IDClockBackStrategy clockBackStrategy = this.conf.getClockBackStrategy();
        IDServiceLog.debug(Resources.getString((String)"bos-id", (String)"IDServiceImplWorker_3", (Object[])new Object[0]) + (Object)((Object)clockBackStrategy));
        switch (clockBackStrategy) {
            case abandon_then_restart: {
                this.doClose(true, false);
                this.restart();
                break;
            }
            case ignore_then_continue: {
                this.lock.set(this.clockPath, String.valueOf(now));
                break;
            }
            default: {
                this.doClose(true, true);
                if (this.removeMeCaseByClockBack != null) {
                    this.removeMeCaseByClockBack.removeMeCaseByClockBack(this);
                }
                throw new KDException(BosErrorCode.bosId, new Object[]{msg});
            }
        }
    }

    private IDWorkerClockChecker startupUpdateAndCheckClock() {
        return new IDWorkerClockChecker(this.workerId, () -> {
            try {
                this.updateAndCheckClock(true);
            }
            catch (Exception e) {
                IDServiceLog.debug(e.getMessage());
            }
        }).start(this.workerId, this.conf.getSessionTimeout());
    }

    private void checkStartup() {
        while (!this.startupped.get()) {
            try {
                this.startupCD.await(1L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                throw DLockUtil.asRuntimeException(Resources.getString((String)"bos-id", (String)"IDServiceImplWorker_4", (Object[])new Object[0]) + "): " + e.getMessage(), e);
            }
        }
        this.genTimes.incrementAndGet();
    }

    @Override
    public <T> T retryOnDisconnected(Function<DLock, T> reconnectCallBack) throws KDException {
        if (!this.closed.get()) {
            int N = this.conf.getSessionReconnectCount();
            for (int i = 0; i < N; ++i) {
                try {
                    this.doClose(false, false);
                    break;
                }
                catch (Exception e) {
                    DisCardUtil.discard();
                    continue;
                }
            }
            Exception exception = null;
            for (int i = 0; i < N; ++i) {
                try {
                    this.doClose(false, false);
                    this.restart();
                }
                catch (Exception e) {
                    exception = e;
                    continue;
                }
                return reconnectCallBack.apply(this.lock);
            }
            if (exception != null) {
                throw new KDException(BosErrorCode.bosId, exception.getMessage(), (Throwable)exception);
            }
        }
        throw new KDException(BosErrorCode.bosId, new Object[]{this + Resources.getString((String)"bos-id", (String)"IDServiceImplWorker_5", (Object[])new Object[0])});
    }

    @Override
    public int genIntId(String tenantId, String tablename) {
        return this.genIntIds(tenantId, tablename, 1)[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] genIntIds(String tenantId, String tablename, int count) {
        this.checkStartup();
        tenantId = tenantId == null ? null : tenantId.toLowerCase();
        String string = tablename = tablename == null ? null : tablename.toLowerCase();
        if (this.batchSize <= 1) {
            return this.batchGenIntIds(tenantId, tablename, count);
        }
        String key = tenantId + "#" + tablename;
        LinkedList cachedIds = this.cachedIntIdMap.get(key);
        if (cachedIds == null) {
            cachedIds = this.cachedIntIdMap.computeIfAbsent(key, k -> new LinkedList());
        }
        LinkedList linkedList = cachedIds;
        synchronized (linkedList) {
            if (cachedIds.size() < count) {
                int fetchSize = Math.max(this.batchSize, count);
                int[] ids = this.batchGenIntIds(tenantId, tablename, fetchSize);
                for (int i = count; i < ids.length; ++i) {
                    cachedIds.add(ids[i]);
                }
                if (count == 1) {
                    return new int[]{ids[0]};
                }
                int[] ret = new int[count];
                System.arraycopy(ids, 0, ret, 0, count);
                return ret;
            }
            int[] ret = new int[count];
            for (int i = 0; i < count; ++i) {
                ret[i] = (Integer)cachedIds.removeFirst();
            }
            return ret;
        }
    }

    private int[] batchGenIntIds(String tenantId, String tablename, int count) {
        try {
            String lockPath = this.conf.getIntLockPath(tenantId, tablename);
            String valuePath = this.conf.getIntValuePath(tenantId, tablename);
            int from = this.getThenIncrement(lockPath, valuePath, count);
            if (count == 1) {
                return new int[]{from};
            }
            int[] ret = new int[count];
            for (int i = 0; i < count; ++i) {
                ret[i] = from + i;
            }
            return ret;
        }
        catch (Exception e) {
            throw DLockUtil.asRuntimeException(e);
        }
    }

    @Override
    public long genLongId() {
        this.checkStartup();
        return this.genner.nextId();
    }

    @Override
    public long[] genLongIds(int count) {
        this.checkStartup();
        long[] ids = new long[count];
        for (int i = 0; i < count; ++i) {
            ids[i] = this.genner.nextId();
        }
        return ids;
    }

    @Override
    public Date getCreateTime(long id) {
        return this.genner.getCreateTime(id);
    }

    private String getWorkerRootPath(String listPath, int workderId) {
        return listPath + "/" + workderId;
    }

    private int registWorkerId(String lockPath, final String workerListPath) throws KDException {
        return this.lock.lock(lockPath, new DLockHandler<Integer>(){

            /*
             * WARNING - void declaration
             */
            @Override
            public Integer handle() throws KDException {
                List<IDServiceImplWorker> workerList;
                Set withTimeNodeNames = IDServiceImplWorker.this.lock.getChildren(IDServiceImplWorker.this.conf.getLongWorkerTimePath()).stream().collect(Collectors.toSet());
                Set activingNodeNames = IDServiceImplWorker.this.lock.getChildren(workerListPath).stream().collect(Collectors.toSet());
                if (((DLockRestarting)((Object)IDServiceImplWorker.this.lock)).isRestarting() && IDServiceImplWorker.this.idServiceImpl != null && IDServiceImplWorker.this.restartTimes > -1 && (workerList = IDServiceImplWorker.this.idServiceImpl.getAllWorkerList()) != null && !workerList.isEmpty()) {
                    for (IDServiceImplWorker iDServiceImplWorker : workerList) {
                        withTimeNodeNames.remove(String.valueOf(iDServiceImplWorker.getWorkerId()));
                    }
                }
                int v = -1;
                ArrayList abandonNodeNames = new ArrayList(withTimeNodeNames);
                abandonNodeNames.removeAll(activingNodeNames);
                for (String abandonNodeName : abandonNodeNames) {
                    if (!abandonNodeName.matches("\\d+")) continue;
                    int workerId = Integer.parseInt(abandonNodeName);
                    String ts = IDServiceImplWorker.this.lock.get(IDServiceImplWorker.this.conf.getLongWorkerTimePath(workerId));
                    if (ts == null || !ts.matches("\\d+") || Long.parseLong(ts) + IDServiceImplWorker.this.reuseDelay > System.currentTimeMillis()) continue;
                    v = workerId;
                    break;
                }
                if (v == -1) {
                    HashSet hashSet = new HashSet(withTimeNodeNames.size() + 1);
                    hashSet.addAll(withTimeNodeNames);
                    hashSet.addAll(activingNodeNames);
                    HashSet<Integer> idSet = new HashSet<Integer>(hashSet.size());
                    for (String nodeName : hashSet) {
                        if (!nodeName.matches("\\d+")) continue;
                        idSet.add(Integer.valueOf(nodeName));
                    }
                    int n = IDServiceImplWorker.this.conf.getMaxWorkerCount();
                    for (int i = 0; i < n; ++i) {
                        if (idSet.contains(i)) continue;
                        v = i;
                        break;
                    }
                }
                if (v == -1) {
                    void var5_12;
                    String string = Resources.get((String)"bos-id", (String)"IDServiceImplWorker_6", (String)"WorkerId\u5df2\u7528\u5b8c(%1$s)", (Object[])new Object[]{IDServiceImplWorker.this.conf.getMaxWorkerCount()});
                    if (abandonNodeNames.size() > 0) {
                        String string2 = string + Resources.get((String)"bos-id", (String)"IDServiceImplWorker_7", (String)"\u56e0\u65f6\u949f\u56de\u62e8\u4e0d\u53ef\u7528\u8282\u70b9\uff1a%1$s", (Object[])new Object[]{abandonNodeNames});
                    }
                    String string3 = (String)var5_12 + "\u3002";
                    throw new KDException(BosErrorCode.bosId, new Object[]{string3});
                }
                IDServiceImplWorker.this.lock.setEphemeral(IDServiceImplWorker.this.getWorkerRootPath(workerListPath, v), DLockUtil.getIpAddress());
                return v;
            }
        });
    }

    private int getThenIncrement(String lockPath, final String valuePath, final int count) throws KDException {
        return this.lock.lock(lockPath, new DLockHandler<Integer>(){

            @Override
            public Integer handle() throws KDException {
                String s = IDServiceImplWorker.this.lock.get(valuePath);
                int v = IDServiceImplWorker.this.conf.getIntIdMinValue();
                if (s != null && s.matches("\\d+")) {
                    v = Integer.parseInt(s);
                }
                if (v < 0 || v > Integer.MAX_VALUE - count) {
                    throw new KDException(BosErrorCode.bosId, new Object[]{Resources.getString((String)"bos-id", (String)"IDServiceImplWorker_8", (Object[])new Object[0]) + v + "\uff0cgenIntId count=" + count + " @" + valuePath + "\u3002"});
                }
                IDServiceImplWorker.this.lock.set(valuePath, String.valueOf(v + count));
                return v;
            }
        });
    }

    @Override
    public void close() throws KDException {
        this.doClose(true, true);
    }

    private void doClose(boolean clearCache, boolean markClosed) throws KDException {
        try {
            this.startupped.set(false);
            if (markClosed) {
                this.closed.set(true);
            }
            if (this.lock != null) {
                this.lock.close();
            }
            if (this.clockChecker != null) {
                this.clockChecker.stop();
            }
            if (clearCache) {
                this.cachedIntIdMap.clear();
            }
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.bosId, e.getMessage(), (Throwable)e);
        }
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public int getWorkerId() {
        return this.workerId;
    }

    @Override
    public String getStatus() {
        StringBuilder ss = new StringBuilder();
        ss.append("\r\n    workerId=").append(this.workerId);
        ss.append("\r\n    clockPath=").append(this.clockPath);
        ss.append("\r\n    startupped=").append(this.startupped.get());
        ss.append("\r\n    active=").append(!this.closed.get());
        ss.append("\r\n    restartTimes=").append(this.restartTimes);
        ss.append("\r\n    genTimes=").append(this.genTimes.get());
        ss.append("\r\n    lastCheckTimestamp=").append(this.lastCheckTimestamp == -1L ? "-" : this.sdf.format(new Date(this.lastCheckTimestamp)));
        ss.append("\r\n    genner=").append(this.genner.getDescription());
        return ss.toString();
    }

    public String toString() {
        return "IDServiceWorker-" + this.workerId;
    }

    @Override
    public IDRange getIDRangeOfDay(Date date) {
        return this.genner.getIDRangeOfDay(date);
    }

    @FunctionalInterface
    static interface ClockBackHandler {
        public void removeMeCaseByClockBack(IDServiceImplWorker var1);
    }
}

