/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.id.worker;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import kd.bos.bundle.Resources;
import kd.bos.exception.KDException;
import kd.bos.id.IDGenner;
import kd.bos.id.IDRange;
import kd.bos.id.IDServiceAssignerConfig;
import kd.bos.id.IDServiceLog;
import kd.bos.id.worker.AssignerType;
import kd.bos.id.worker.WorkerAssigner;
import kd.bos.instance.Instance;
import kd.bos.lock.DLockUtil;
import kd.bos.util.ConfigurationUtil;
import kd.bos.util.DisCardUtil;
import kd.bos.util.NetAddressUtils;

public abstract class AbstractWorkerAssigner
implements WorkerAssigner,
AutoCloseable {
    private final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    protected static final char SPLIT_DELIMIT = '#';
    protected final IDServiceAssignerConfig idServiceAssignerConfig;
    private IDGenner idGenner;
    private int workerId;
    private Map<String, LinkedList<Integer>> cachedIntIdMap = new ConcurrentHashMap<String, LinkedList<Integer>>();
    private final int batchSize;
    protected final String instanceInfo;
    protected final AtomicBoolean startUpped = new AtomicBoolean(false);
    private CountDownLatch startupCD;
    private boolean useForwardTime = ConfigurationUtil.getBoolean((String)"IDService.useForwardTime", (Boolean)true);
    private long lastTimestamp = -1L;
    private long lastCheckTimestamp = -1L;
    private String clockPath;
    private int restartTimes = -1;
    private volatile boolean restarting = false;
    private final AtomicLong genTimes = new AtomicLong();
    private AtomicBoolean report = new AtomicBoolean(true);

    public AbstractWorkerAssigner(IDServiceAssignerConfig idServiceAssignerConfig) {
        this.idServiceAssignerConfig = idServiceAssignerConfig;
        this.batchSize = idServiceAssignerConfig.getBatchGenIntSize();
        this.instanceInfo = Instance.getInstanceId() + '#' + NetAddressUtils.getLocalIpAddress();
        this.register();
    }

    private final void register() {
        this.startUpped.set(false);
        if (this.startupCD != null) {
            this.startupCD.countDown();
        }
        this.startupCD = new CountDownLatch(1);
        try {
            this.restarting = true;
            this.workerId = this.registerWorkerId();
            this.clockPath = this.idServiceAssignerConfig.getLongWorkerTimePath(this.workerId);
            ++this.restartTimes;
            String startupDesc = this.restartTimes == 0 ? "--first startup" : "--restartTimes=" + this.restartTimes;
            this.idGenner = new IDGenner(this.workerId, this.idServiceAssignerConfig.getTolerantClockBackTimestamp(), startupDesc, this.useForwardTime);
            this.startUpped.set(true);
            this.reportWorkerIdServiceAndCheckClock();
        }
        finally {
            this.restarting = false;
        }
        this.startupCD.countDown();
    }

    private void reportWorkerIdServiceAndCheckClock() {
        Thread thread = new Thread(() -> {
            while (this.report.get() && !Thread.currentThread().isInterrupted()) {
                try {
                    String assignerType = this.idServiceAssignerConfig.getWorkerIdAssignerType();
                    AssignerType type = AssignerType.from(assignerType);
                    Thread.sleep(this.idServiceAssignerConfig.getTolerantClockBackTimestamp() << 1);
                    this.updateAndCheckClock(true);
                    boolean needRetryRegister = this.ifNeedRetryRegisterAndReportWorker();
                    if (!needRetryRegister) continue;
                    this.register();
                }
                catch (InterruptedException e) {
                    DisCardUtil.discard();
                }
            }
        });
        thread.setName("ID-Worker-Clock-Checker-And-Report-" + this.workerId);
        thread.setDaemon(true);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAndCheckClock(boolean tryCompensate) throws KDException {
        if (this.restarting) {
            return;
        }
        this.lastCheckTimestamp = System.currentTimeMillis();
        String v = this.getWorkerIdAssignedTime();
        if (v != null && v.matches("\\d+")) {
            this.lastTimestamp = Long.parseLong(v);
        }
        if (this.lastTimestamp > this.lastCheckTimestamp) {
            long offset = this.lastTimestamp - this.lastCheckTimestamp;
            if (tryCompensate && offset <= this.idServiceAssignerConfig.getTolerantClockBackTimestamp()) {
                try {
                    AbstractWorkerAssigner abstractWorkerAssigner = this;
                    synchronized (abstractWorkerAssigner) {
                        this.wait(offset << 1);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.updateAndCheckClock(false);
                return;
            }
            String msg = this + Resources.get((String)"bos-id", (String)"IDServiceImplWorker_0", (String)"\u65f6\u949f\u88ab\u56de\u62e8%1$sms(%2$s\u6700\u540e\u8bb0\u5f55\u65f6\u95f4\u4e3a%3$s)\uff0c\u8bf7\u7ea0\u6b63\u670d\u52a1\u8282\u70b9\u65f6\u95f4\uff0c\u5f53\u524d\u670d\u52a1\u8282\u70b9\u65f6\u95f4\u4e3a %4$s (%5$sms)\u3002", (Object[])new Object[]{offset, this.clockPath, this.sdf.format(new Date(this.lastTimestamp)), this.sdf.format(this.lastCheckTimestamp), this.lastCheckTimestamp});
            IDServiceLog.debug(msg);
            this.close();
            this.register();
        } else {
            this.setWorkerIdAssignTime(String.valueOf(this.lastCheckTimestamp));
        }
    }

    @Override
    public void close() throws KDException {
        this.report.set(false);
        if (this.cachedIntIdMap != null) {
            this.cachedIntIdMap.clear();
        }
    }

    protected abstract String getWorkerIdAssignedTime();

    protected abstract void setWorkerIdAssignTime(String var1);

    protected abstract boolean ifNeedRetryRegisterAndReportWorker();

    protected abstract int getThenIncrement(String var1, String var2, int var3);

    @Override
    public final int genIntId(String tenantId, String tableName) {
        return this.genIntIds(tenantId, tableName, 1)[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int[] genIntIds(String tenantId, String tableName, int count) {
        this.checkStartup();
        tenantId = tenantId == null ? null : tenantId.toLowerCase();
        String string = tableName = tableName == null ? null : tableName.toLowerCase();
        if (this.batchSize <= 1) {
            return this.batchGenIntIds(tenantId, tableName, count);
        }
        String key = tenantId + "#" + tableName;
        LinkedList cachedIds = this.cachedIntIdMap.get(key);
        if (cachedIds == null) {
            cachedIds = this.cachedIntIdMap.computeIfAbsent(key, k -> new LinkedList());
        }
        LinkedList linkedList = cachedIds;
        synchronized (linkedList) {
            if (cachedIds.size() < count) {
                int fetchSize = Math.max(this.batchSize, count);
                int[] ids = this.batchGenIntIds(tenantId, tableName, fetchSize);
                for (int i = count; i < ids.length; ++i) {
                    cachedIds.add(ids[i]);
                }
                if (count == 1) {
                    return new int[]{ids[0]};
                }
                int[] ret = new int[count];
                System.arraycopy(ids, 0, ret, 0, count);
                return ret;
            }
            int[] ret = new int[count];
            for (int i = 0; i < count; ++i) {
                ret[i] = (Integer)cachedIds.removeFirst();
            }
            return ret;
        }
    }

    private int[] batchGenIntIds(String tenantId, String tableName, int count) {
        try {
            String lockPath = this.idServiceAssignerConfig.getIntLockPath(tenantId, tableName);
            String valuePath = this.idServiceAssignerConfig.getIntValuePath(tenantId, tableName);
            int from = this.getThenIncrement(lockPath, valuePath, count);
            if (count == 1) {
                return new int[]{from};
            }
            int[] ret = new int[count];
            for (int i = 0; i < count; ++i) {
                ret[i] = from + i;
            }
            return ret;
        }
        catch (Exception e) {
            throw DLockUtil.asRuntimeException(e);
        }
    }

    @Override
    public long genLongId() {
        this.checkStartup();
        return this.idGenner.nextId();
    }

    @Override
    public long[] genLongIds(int count) {
        this.checkStartup();
        long[] ids = new long[count];
        for (int i = 0; i < count; ++i) {
            ids[i] = this.idGenner.nextId();
        }
        return ids;
    }

    @Override
    public Date getCreateTime(long id) {
        return this.idGenner.getCreateTime(id);
    }

    @Override
    public IDRange getIDRangeOfDay(Date date) {
        return this.idGenner.getIDRangeOfDay(date);
    }

    @Override
    public String getStatus() {
        StringBuilder ss = new StringBuilder();
        ss.append("\r\n    instanceInfo=").append(this.instanceInfo);
        ss.append("\r\n    workerId=").append(this.workerId);
        ss.append("\r\n    clockPath=").append(this.clockPath);
        ss.append("\r\n    startupped=").append(this.startUpped.get());
        ss.append("\r\n    restartTimes=").append(this.restartTimes);
        ss.append("\r\n    genTimes=").append(this.genTimes.get());
        ss.append("\r\n    lastCheckTimestamp=").append(this.lastCheckTimestamp == -1L ? "-" : this.sdf.format(new Date(this.lastCheckTimestamp)));
        ss.append("\r\n    genner=").append(this.idGenner.getDescription());
        return ss.toString();
    }

    private void checkStartup() {
        while (!this.startUpped.get()) {
            try {
                this.startupCD.await(1L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                throw DLockUtil.asRuntimeException(Resources.getString((String)"bos-id", (String)"IDServiceImplWorker_4", (Object[])new Object[0]) + "): " + e.getMessage(), e);
            }
        }
        this.genTimes.incrementAndGet();
    }

    @Override
    public final int getWorkerId() {
        return this.workerId;
    }
}

