/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.id.worker;

import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.id.IDServiceAssignerConfig;
import kd.bos.id.worker.AssignerType;
import kd.bos.id.worker.WorkerAssigner;
import kd.bos.id.worker.impl.DBStoreWorkerAssigner;
import kd.bos.id.worker.impl.RedisWorkerAssigner;

public final class WorkerAssignerFactory {
    private WorkerAssignerFactory() {
    }

    public WorkerAssigner getWorkerIdAssigner(IDServiceAssignerConfig config) {
        String workerIdAssignerType = config.getWorkerIdAssignerType();
        if (workerIdAssignerType != null) {
            AssignerType assignerType = AssignerType.from(workerIdAssignerType);
            switch (assignerType) {
                case REDIS_ASSIGNER: {
                    return new RedisWorkerAssigner(config);
                }
                case DB_ASSIGNER: {
                    return new DBStoreWorkerAssigner(config);
                }
            }
            throw new KDException(BosErrorCode.bosId, new Object[]{String.format("unsupported assigner type name=%s", assignerType.getTypeName())});
        }
        return null;
    }

    public static WorkerAssignerFactory getInstance() {
        return WorkerIdAssignerFactoryHolder.workerAssignerFactory;
    }

    private static class WorkerIdAssignerFactoryHolder {
        private static WorkerAssignerFactory workerAssignerFactory = new WorkerAssignerFactory();

        private WorkerIdAssignerFactoryHolder() {
        }
    }
}

