/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.lock;

import java.io.UnsupportedEncodingException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;

public class DLockUtil {
    public static final byte[] empty_data = new byte[0];
    public static final int dlock_min_session_timeout = 2000;
    public static final int dlock_retry_count = 3;
    public static final int dlock_retry_delay = 500;

    public static byte[] getIpBytes() {
        String ipAddress = DLockUtil.getIpAddress();
        try {
            return ipAddress == null ? null : ipAddress.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw DLockUtil.asRuntimeException(e);
        }
    }

    public static String getIpAddress() {
        String ipAddress = null;
        try {
            Enumeration<NetworkInterface> allNetInterfaces = NetworkInterface.getNetworkInterfaces();
            InetAddress ip = null;
            while (allNetInterfaces.hasMoreElements()) {
                NetworkInterface netInterface = allNetInterfaces.nextElement();
                Enumeration<InetAddress> addresses = netInterface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    ip = addresses.nextElement();
                    if (!(ip instanceof Inet4Address) || (ipAddress = ip.getHostAddress()).equals("127.0.0.1")) continue;
                    return ipAddress;
                }
            }
            return ipAddress;
        }
        catch (SocketException e) {
            throw DLockUtil.asRuntimeException(e);
        }
    }

    public static RuntimeException asRuntimeException(String message) {
        throw new RuntimeException(message);
    }

    public static RuntimeException asRuntimeException(String message, Throwable e) {
        throw new RuntimeException(message, e);
    }

    public static RuntimeException asRuntimeException(Throwable e) {
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        return new RuntimeException(e);
    }
}

