/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cache.ha.adapter;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kd.bos.cache.ha.adapter.CacheAdapter;
import kd.bos.cache.ha.adapter.MothedCall;
import kd.bos.cache.ha.adapter.MothedCallBack;
import kd.bos.cache.ha.db.DbCacheFactory;
import kd.bos.cache.ha.db.IDbCache;
import kd.bos.dataentity.OperateOption;
import kd.bos.exception.KDException;

class DbCacheAdapter
implements CacheAdapter {
    private String regionKey;
    private boolean throwExecption;
    private CacheAdapter priorityAdapter;
    private static final Charset UTF_8 = StandardCharsets.UTF_8;
    private static final int DEFAULT_TIMEOUT = 3600;

    private int toExpireTime(int timeout, TimeUnit timeUnit) {
        return (int)timeUnit.toSeconds(timeout);
    }

    private OperateOption createAsynOption() {
        OperateOption option = OperateOption.create();
        option.setVariableValue("sync", "true");
        return option;
    }

    public IDbCache getCache(boolean isPriority) {
        return DbCacheFactory.get(isPriority);
    }

    public DbCacheAdapter(String regionKey, CacheAdapter priorityAdapter) {
        this.regionKey = regionKey == null || "".equals(regionKey) ? " " : regionKey;
        if (priorityAdapter != null) {
            this.priorityAdapter = priorityAdapter;
            this.priorityAdapter.setThrowException(true);
        }
    }

    @Override
    public void setPriorityAdapter(CacheAdapter priorityAdapter) {
        this.priorityAdapter = priorityAdapter;
        if (this.priorityAdapter != null) {
            this.priorityAdapter.setThrowException(true);
        }
    }

    @Override
    public CacheAdapter getPriorityAdapter() {
        return this.priorityAdapter;
    }

    @Override
    public void setThrowException(boolean throwException) {
        this.throwExecption = throwException;
    }

    @Override
    public boolean isThrowException() {
        return this.throwExecption;
    }

    @Override
    public void setRegionKey(String regionKey) {
        this.regionKey = regionKey;
    }

    @Override
    public String getRegionKey() {
        return this.regionKey;
    }

    public int addList(String key, String[] values) {
        return this.callBothBack(isUpLevel -> this.getPriorityAdapter().addList(key, values), isUpLevel -> {
            OperateOption option = isUpLevel ? this.createAsynOption() : null;
            return this.getCache(isUpLevel).addList(this.regionKey, key, values, option);
        }, 0);
    }

    public int addList(String key, String[] values, int timeoutSeconds) {
        return this.callBothBack(isUpLevel -> this.getPriorityAdapter().addList(key, values, timeoutSeconds), isUpLevel -> {
            OperateOption option = isUpLevel ? this.createAsynOption() : null;
            return this.getCache(isUpLevel).addList(this.regionKey, key, values, timeoutSeconds, option);
        }, 0);
    }

    public int addList(String key, String[] values, int timeout, TimeUnit timeUnit) {
        return this.callBothBack(isUpLevel -> this.getPriorityAdapter().addList(key, values, timeout, timeUnit), isUpLevel -> {
            OperateOption option = isUpLevel ? this.createAsynOption() : null;
            return this.getCache(isUpLevel).addList(this.regionKey, key, values, this.toExpireTime(timeout, timeUnit), option);
        }, 0);
    }

    public int resetList(String key, String[] values, int timeout, TimeUnit timeUnit) {
        this.remove(key);
        return this.addList(key, values, timeout, timeUnit);
    }

    public int insertList(String key, int index, String[] values) {
        return this.callBothBack(isUpLevel -> this.getPriorityAdapter().insertList(key, index, values), isUpLevel -> {
            OperateOption option = isUpLevel ? this.createAsynOption() : null;
            return this.getCache(isUpLevel).insertList(this.regionKey, key, index, values, option);
        }, 0);
    }

    public void setListObject(String key, int index, String value) {
        this.callBoth(isUpLevel -> this.getPriorityAdapter().setListObject(key, index, value), isUpLevel -> {
            OperateOption option = isUpLevel ? this.createAsynOption() : null;
            this.getCache(isUpLevel).setListObject(this.regionKey, key, index, value, option);
        });
    }

    public String[] getList(String key) {
        return this.callOneBack(isUpLevel -> this.getPriorityAdapter().getList(key), isUpLevel -> this.getCache(true).getList(this.regionKey, key, null), new String[0]);
    }

    public String[] getList(String key, int index, int length) {
        return this.callOneBack(isUpLevel -> this.getPriorityAdapter().getList(key, index, length), isUpLevel -> this.getCache(true).getList(this.regionKey, key, index, length, null), new String[0]);
    }

    public String getListObject(String key, int index) {
        return this.callOneBack(isUpLevel -> this.getPriorityAdapter().getListObject(key, index), isUpLevel -> this.getCache(true).getListObject(this.regionKey, key, index, null), null);
    }

    public void removeListObject(String key, int index) {
        this.callBoth(isUpLevel -> this.getPriorityAdapter().removeListObject(key, index), isUpLevel -> {
            OperateOption option = isUpLevel ? this.createAsynOption() : null;
            this.getCache(isUpLevel).removeListObject(this.regionKey, key, index, option);
        });
    }

    public void removeListObjects(String key, int index, int length) {
        this.callBoth(isUpLevel -> this.getPriorityAdapter().removeListObjects(key, index, length), isUpLevel -> {
            OperateOption option = isUpLevel ? this.createAsynOption() : null;
            this.getCache(isUpLevel).removeListObjects(this.regionKey, key, index, length, option);
        });
    }

    public int getListLength(String key) {
        return this.callOneBack(isUpLevel -> this.getPriorityAdapter().getListLength(key), isUpLevel -> this.getCache(true).getListLength(this.regionKey, key, null), 0);
    }

    public int addToSet(String key, String[] values) {
        return this.callBothBack(isUpLevel -> this.getPriorityAdapter().addToSet(key, values), isUpLevel -> {
            OperateOption option = isUpLevel ? this.createAsynOption() : null;
            HashMap<String, String> keyValues = new HashMap<String, String>(values.length);
            for (String value : values) {
                keyValues.put(value, "");
            }
            this.getCache(isUpLevel).put(this.regionKey, key, keyValues, option);
            return keyValues.size();
        }, 0);
    }

    public int addToSet(String key, String[] values, int timeoutSeconds) {
        return this.callBothBack(isUpLevel -> this.getPriorityAdapter().addToSet(key, values, timeoutSeconds), isUpLevel -> {
            OperateOption option = isUpLevel ? this.createAsynOption() : null;
            HashMap<String, String> keyValues = new HashMap<String, String>(values.length);
            for (String value : values) {
                keyValues.put(value, "");
            }
            this.getCache(isUpLevel).put(this.regionKey, key, keyValues, timeoutSeconds, option);
            return keyValues.size();
        }, 0);
    }

    public int addToSet(String key, String[] values, int timeout, TimeUnit timeUnit) {
        return this.callBothBack(isUpLevel -> this.getPriorityAdapter().addToSet(key, values, timeout, timeUnit), isUpLevel -> {
            OperateOption option = isUpLevel ? this.createAsynOption() : null;
            HashMap<String, String> keyValues = new HashMap<String, String>(values.length);
            for (String value : values) {
                keyValues.put(value, "");
            }
            this.getCache(isUpLevel).put(this.regionKey, key, keyValues, this.toExpireTime(timeout, timeUnit), option);
            return keyValues.size();
        }, 0);
    }

    public String[] getSetValues(String key) {
        return this.callOneBack(isUpLevel -> this.getPriorityAdapter().getSetValues(key), isUpLevel -> {
            Map<String, String> keyValues = this.getCache(true).getAll(this.regionKey, key, this.createAsynOption());
            return keyValues.keySet().toArray(new String[0]);
        }, new String[0]);
    }

    public int getSetLength(String key) {
        return this.callOneBack(isUpLevel -> this.getPriorityAdapter().getSetLength(key), isUpLevel -> {
            Map<String, String> keyValues = this.getCache(true).getAll(this.regionKey, key, this.createAsynOption());
            return keyValues.size();
        }, 0);
    }

    public void removeSetValues(String key, String[] values) {
        this.callBoth(isUpLevel -> this.getPriorityAdapter().removeSetValues(key, values), isUpLevel -> {
            OperateOption option = isUpLevel ? this.createAsynOption() : null;
            this.getCache(isUpLevel).remove(this.regionKey, key, values, option);
        });
    }

    public void put(String key, String value) {
        this.callBoth(isUpLevel -> this.getPriorityAdapter().put(key, value), isUpLevel -> {
            OperateOption option = isUpLevel ? this.createAsynOption() : null;
            this.getCache(isUpLevel).put(this.regionKey, key, value, option);
        });
    }

    public void put(String key, String value, int timeoutSeconds) {
        this.callBoth(isUpLevel -> this.getPriorityAdapter().put(key, value, timeoutSeconds), isUpLevel -> {
            OperateOption option = isUpLevel ? this.createAsynOption() : null;
            this.getCache(isUpLevel).put(this.regionKey, key, value, timeoutSeconds, option);
        });
    }

    public void put(String key, String value, int timeout, TimeUnit timeUnit) {
        this.callBoth(isUpLevel -> this.getPriorityAdapter().put(key, value, timeout, timeUnit), isUpLevel -> {
            OperateOption option = isUpLevel ? this.createAsynOption() : null;
            this.getCache(isUpLevel).put(this.regionKey, key, value, this.toExpireTime(timeout, timeUnit), option);
        });
    }

    public void put(String type, Map<String, String> keyValues) {
        this.callBoth(isUpLevel -> this.getPriorityAdapter().put(type, keyValues), isUpLevel -> {
            OperateOption option = isUpLevel ? this.createAsynOption() : null;
            this.getCache(isUpLevel).put(this.regionKey, type, keyValues, option);
        });
    }

    public void put(String type, Map<String, String> keyValues, int timeoutSeconds) {
        this.callBoth(isUpLevel -> this.getPriorityAdapter().put(type, keyValues, timeoutSeconds), isUpLevel -> {
            OperateOption option = isUpLevel ? this.createAsynOption() : null;
            this.getCache(isUpLevel).put(this.regionKey, type, keyValues, timeoutSeconds, option);
        });
    }

    public void put(String type, Map<String, String> keyValues, int timeout, TimeUnit timeUnit) {
        this.callBoth(isUpLevel -> this.getPriorityAdapter().put(type, keyValues, timeout, timeUnit), isUpLevel -> {
            OperateOption option = isUpLevel ? this.createAsynOption() : null;
            this.getCache(isUpLevel).put(this.regionKey, type, keyValues, this.toExpireTime(timeout, timeUnit), option);
        });
    }

    public void put(String type, String key, String value) {
        this.callBoth(isUpLevel -> this.getPriorityAdapter().put(type, key, value), isUpLevel -> {
            OperateOption option = isUpLevel ? this.createAsynOption() : null;
            this.getCache(isUpLevel).put(this.regionKey, type, key, value, option);
        });
    }

    public void put(String type, String key, String value, int timeoutSeconds) {
        this.callBoth(isUpLevel -> this.getPriorityAdapter().put(type, key, value, timeoutSeconds), isUpLevel -> {
            OperateOption option = isUpLevel ? this.createAsynOption() : null;
            this.getCache(isUpLevel).put(this.regionKey, type, key, value, timeoutSeconds, option);
        });
    }

    public void put(String type, String key, String value, int timeout, TimeUnit timeUnit) {
        this.callBoth(isUpLevel -> this.getPriorityAdapter().put(type, key, value, timeout, timeUnit), isUpLevel -> {
            OperateOption option = isUpLevel ? this.createAsynOption() : null;
            this.getCache(isUpLevel).put(this.regionKey, type, key, value, this.toExpireTime(timeout, timeUnit), option);
        });
    }

    public String get(String key) {
        return this.callOneBack(isUpLevel -> (String)this.getPriorityAdapter().get(key), isUpLevel -> this.getCache(true).get(this.regionKey, key, null), null);
    }

    public String get(String type, String key) {
        return this.callOneBack(isUpLevel -> (String)this.getPriorityAdapter().get(type, key), isUpLevel -> this.getCache(true).get(this.regionKey, type, key, null), null);
    }

    public List<String> get(String type, String[] keys) {
        ArrayList<Object> values = new ArrayList<Object>(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            values.add(null);
        }
        return this.callOneBack(isUpLevel -> this.getPriorityAdapter().get(type, keys), isUpLevel -> this.getCache(true).get(this.regionKey, type, keys, null), values);
    }

    public Map<String, String> getAll(String type) {
        return this.callOneBack(isUpLevel -> this.getPriorityAdapter().getAll(type), isUpLevel -> this.getCache(true).getAll(this.regionKey, type, null), new HashMap(0));
    }

    public void remove(String key) {
        this.callBoth(isUpLevel -> this.getPriorityAdapter().remove(key), isUpLevel -> {
            OperateOption option = isUpLevel ? this.createAsynOption() : null;
            this.getCache(isUpLevel).remove(this.regionKey, key, option);
        });
    }

    public void remove(String[] keys) {
        this.callBoth(isUpLevel -> this.getPriorityAdapter().remove(keys), isUpLevel -> {
            OperateOption option = isUpLevel ? this.createAsynOption() : null;
            this.getCache(isUpLevel).remove(this.regionKey, keys, option);
        });
    }

    public void remove(String type, String key) {
        this.callBoth(isUpLevel -> this.getPriorityAdapter().remove(type, key), isUpLevel -> {
            OperateOption option = isUpLevel ? this.createAsynOption() : null;
            this.getCache(isUpLevel).remove(this.regionKey, type, key, option);
        });
    }

    public void remove(String type, String[] keys) {
        this.callBoth(isUpLevel -> this.getPriorityAdapter().remove(type, keys), isUpLevel -> {
            OperateOption option = isUpLevel ? this.createAsynOption() : null;
            this.getCache(isUpLevel).remove(this.regionKey, type, keys, option);
        });
    }

    public void removeType(String type) {
        this.callBoth(isUpLevel -> this.getPriorityAdapter().removeType(type), isUpLevel -> {
            OperateOption option = isUpLevel ? this.createAsynOption() : null;
            this.getCache(isUpLevel).removeType(this.regionKey, type, option);
        });
    }

    public boolean contains(String key) {
        return this.callOneBack(isUpLevel -> this.getPriorityAdapter().contains(key), isUpLevel -> this.getCache(true).contains(this.regionKey, key, null), false);
    }

    public boolean contains(String type, String key) {
        return this.callOneBack(isUpLevel -> this.getPriorityAdapter().contains(type, key), isUpLevel -> this.getCache(true).contains(this.regionKey, type, key, null), false);
    }

    public List<String> getKeys(String type) {
        return this.callOneBack(isUpLevel -> this.getPriorityAdapter().getKeys(type), isUpLevel -> this.getCache(true).getKeys(this.regionKey, type, null), new ArrayList(0));
    }

    public List<String> getKeysWithPrefix(String type, String prefix) {
        return this.callOneBack(isUpLevel -> this.getPriorityAdapter().getKeysWithPrefix(type, prefix), isUpLevel -> this.getCache(true).getKeysWithPrefix(this.regionKey, type, prefix, null), new ArrayList(0));
    }

    public List<String> getKeysWithPrefix(String prefix) {
        return this.callOneBack(isUpLevel -> this.getPriorityAdapter().getKeysWithPrefix(prefix), isUpLevel -> this.getCache(true).getKeysWithPrefix(this.regionKey, prefix, null), new ArrayList(0));
    }

    public long inc(String key) {
        return this.callBothBack(isUpLevel -> this.getPriorityAdapter().inc(key), isUpLevel -> {
            OperateOption option = isUpLevel ? this.createAsynOption() : null;
            return this.getCache(isUpLevel).inc(this.regionKey, key, option);
        }, 0L);
    }

    public long inc(String key, int timeoutSeconds) {
        return this.callBothBack(isUpLevel -> this.getPriorityAdapter().inc(key, timeoutSeconds), isUpLevel -> {
            OperateOption option = isUpLevel ? this.createAsynOption() : null;
            return this.getCache(isUpLevel).inc(this.regionKey, key, timeoutSeconds, option);
        }, 0L);
    }

    public long inc(String key, int timeout, TimeUnit timeUnit) {
        return this.callBothBack(isUpLevel -> this.getPriorityAdapter().inc(key, timeout, timeUnit), isUpLevel -> {
            OperateOption option = isUpLevel ? this.createAsynOption() : null;
            return this.getCache(isUpLevel).inc(this.regionKey, key, this.toExpireTime(timeout, timeUnit), option);
        }, 0L);
    }

    public long incrBy(String key, int amount) {
        return this.callBothBack(isUpLevel -> this.getPriorityAdapter().incrBy(key, amount), isUpLevel -> {
            OperateOption option = isUpLevel ? this.createAsynOption() : null;
            return this.getCache(isUpLevel).incrBy(this.regionKey, key, amount, option);
        }, 0L);
    }

    public long decr(String key) {
        return this.callBothBack(isUpLevel -> this.getPriorityAdapter().decr(key), isUpLevel -> {
            OperateOption option = isUpLevel ? this.createAsynOption() : null;
            return this.getCache(isUpLevel).decr(this.regionKey, key, option);
        }, 0L);
    }

    public long decr(String key, int timeoutSeconds) {
        return this.callBothBack(isUpLevel -> this.getPriorityAdapter().decr(key, timeoutSeconds), isUpLevel -> {
            OperateOption option = isUpLevel ? this.createAsynOption() : null;
            return this.getCache(isUpLevel).decr(this.regionKey, key, timeoutSeconds, option);
        }, 0L);
    }

    public long decr(String key, int timeout, TimeUnit timeUnit) {
        return this.callBothBack(isUpLevel -> this.getPriorityAdapter().decr(key, timeout, timeUnit), isUpLevel -> {
            OperateOption option = isUpLevel ? this.createAsynOption() : null;
            return this.getCache(isUpLevel).decr(this.regionKey, key, this.toExpireTime(timeout, timeUnit), option);
        }, 0L);
    }

    public void expireAfter(String keyOrType, int second) {
        this.callBoth(isUpLevel -> this.getPriorityAdapter().expireAfter(keyOrType, second), isUpLevel -> {
            OperateOption option = isUpLevel ? this.createAsynOption() : null;
            this.getCache(isUpLevel).expireAfter(this.regionKey, keyOrType, second, option);
        });
    }

    public void expireAfter(String keyOrType, int timeout, TimeUnit timeUnit) {
        this.callBoth(isUpLevel -> this.getPriorityAdapter().expireAfter(keyOrType, timeout, timeUnit), isUpLevel -> {
            OperateOption option = isUpLevel ? this.createAsynOption() : null;
            this.getCache(isUpLevel).expireAfter(this.regionKey, keyOrType, this.toExpireTime(timeout, timeUnit), option);
        });
    }

    public void expireAfterImmediateEffect(String keyOrType, int timeout, TimeUnit timeUnit) {
        this.callBoth(isUpLevel -> this.getPriorityAdapter().expireAfterImmediateEffect(keyOrType, timeout, timeUnit), isUpLevel -> {
            OperateOption option = isUpLevel ? this.createAsynOption() : null;
            this.getCache(isUpLevel).expireAfterImmediateEffect(this.regionKey, keyOrType, this.toExpireTime(timeout, timeUnit), option);
        });
    }

    public Object eval(String lua, String key, List<String> params) {
        return this.getPriorityAdapter().eval(lua, key, params);
    }

    public void put(String key, byte[] value) {
        this.callBoth(isUpLevel -> this.getPriorityAdapter().put(key, value), isUpLevel -> {
            OperateOption option = isUpLevel ? this.createAsynOption() : null;
            this.getCache(isUpLevel).put(this.regionKey, key, new String(value, UTF_8), option);
        });
    }

    public void put(String key, byte[] value, int timeoutSecond) {
        this.callBoth(isUpLevel -> this.getPriorityAdapter().put(key, value, timeoutSecond), isUpLevel -> {
            OperateOption option = isUpLevel ? this.createAsynOption() : null;
            this.getCache(isUpLevel).put(this.regionKey, key, new String(value, UTF_8), timeoutSecond, option);
        });
    }

    public void hset(String key, byte[] field, byte[] value) {
        this.callBoth(isUpLevel -> this.getPriorityAdapter().hset(key, field, value), isUpLevel -> {
            OperateOption option = isUpLevel ? this.createAsynOption() : null;
            this.getCache(isUpLevel).hset(this.regionKey, key, new String(field, UTF_8), new String(value, UTF_8), option);
        });
    }

    public void hset(String key, byte[] field, byte[] value, int timeoutSeconds) {
        this.callBoth(isUpLevel -> this.getPriorityAdapter().hset(key, field, value, timeoutSeconds), isUpLevel -> {
            OperateOption option = isUpLevel ? this.createAsynOption() : null;
            this.getCache(isUpLevel).hset(this.regionKey, key, new String(field, UTF_8), new String(value, UTF_8), timeoutSeconds, option);
        });
    }

    public void hmset(String key, Map<byte[], byte[]> map) {
        this.hmset(key, map, 3600);
    }

    public void hmset(String key, Map<byte[], byte[]> map, int timeoutSeconds) {
        HashMap<String, String> fieldValues = new HashMap<String, String>(16);
        for (Map.Entry<byte[], byte[]> next : map.entrySet()) {
            fieldValues.put(new String(next.getKey(), UTF_8), new String(next.getValue(), UTF_8));
        }
        this.callBoth(isUpLevel -> this.getPriorityAdapter().hmset(key, map, timeoutSeconds), isUpLevel -> {
            OperateOption option = isUpLevel ? this.createAsynOption() : null;
            this.getCache(isUpLevel).hmset(this.regionKey, key, fieldValues, timeoutSeconds, option);
        });
    }

    public byte[] hget(String key, byte[] bytes) {
        return this.callOneBack(isUpLevel -> this.getPriorityAdapter().hget(key, bytes), isUpLevel -> this.getCache(true).hget(this.regionKey, key, new String(bytes, UTF_8), null), new byte[0]);
    }

    public Map<byte[], byte[]> hgetAll(String key) {
        return this.callOneBack(isUpLevel -> this.getPriorityAdapter().hgetAll(key), isUpLevel -> this.getCache(true).hgetAll(this.regionKey, key, null), Collections.EMPTY_MAP);
    }

    public List<byte[]> hmget(String key, byte[] ... bytes) {
        int length = bytes.length;
        String[] params = new String[length];
        for (int i = 0; i < length; ++i) {
            params[i] = new String(bytes[i], UTF_8);
        }
        return this.callOneBack(isUpLevel -> this.getPriorityAdapter().hmget(key, bytes), isUpLevel -> this.getCache(true).hmget(this.regionKey, key, params, null), Collections.emptyList());
    }

    public byte[] getByteValue(String key) {
        return this.callOneBack(isUpLevel -> this.getPriorityAdapter().getByteValue(key), isUpLevel -> this.getCache(true).getByteValue(this.regionKey, key, null), new byte[0]);
    }

    public void pipelinedMode() {
        this.getPriorityAdapter().pipelinedMode();
    }

    public void singleMode() {
        this.getPriorityAdapter().singleMode();
    }

    public List<Object> syncAndReturn() {
        return this.getPriorityAdapter().syncAndReturn();
    }

    private <R> R callOneBack(MothedCallBack<R> call1, MothedCallBack<R> call2, R defValue) {
        if (!this.isAvailable()) {
            try {
                return call2.call(true);
            }
            catch (KDException e) {
                if (this.isThrowException()) {
                    throw e;
                }
                return defValue;
            }
        }
        if (this.getPriorityAdapter() != null) {
            try {
                return call1.call(true);
            }
            catch (KDException e) {
                // empty catch block
            }
        }
        try {
            return call2.call(true);
        }
        catch (KDException e) {
            if (this.isThrowException()) {
                throw e;
            }
            return defValue;
        }
    }

    private void callBoth(MothedCall call1, MothedCall call2) {
        block9: {
            boolean isUpLevel;
            block8: {
                if (!this.isAvailable()) {
                    try {
                        call2.call(true);
                    }
                    catch (KDException e) {
                        if (!this.isThrowException()) break block8;
                        throw e;
                    }
                }
            }
            boolean bl = isUpLevel = this.getPriorityAdapter() == null;
            if (this.getPriorityAdapter() != null) {
                try {
                    call1.call(true);
                }
                catch (KDException e) {
                    isUpLevel = true;
                }
            }
            try {
                call2.call(isUpLevel);
            }
            catch (KDException e) {
                if (!this.isThrowException()) break block9;
                throw e;
            }
        }
    }

    private <R> R callBothBack(MothedCallBack<R> call1, MothedCallBack<R> call2, R defValue) {
        boolean isUpLevel;
        R val2;
        R val1;
        block9: {
            block8: {
                if (!this.isAvailable()) {
                    try {
                        return call2.call(true);
                    }
                    catch (KDException e) {
                        if (!this.isThrowException()) break block8;
                        throw e;
                    }
                }
            }
            val1 = defValue;
            val2 = defValue;
            boolean bl = isUpLevel = this.getPriorityAdapter() == null;
            if (this.getPriorityAdapter() != null) {
                try {
                    val1 = call1.call(true);
                }
                catch (KDException e) {
                    isUpLevel = true;
                }
            }
            try {
                val2 = call2.call(isUpLevel);
            }
            catch (KDException e) {
                if (!this.isThrowException()) break block9;
                throw e;
            }
        }
        return isUpLevel ? val2 : val1;
    }

    public boolean isAvailable() {
        if (this.getPriorityAdapter() != null) {
            return this.priorityAdapter.isAvailable();
        }
        return false;
    }
}

