/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cache.ha.db.dao;

import java.util.Arrays;
import java.util.Date;
import kd.bos.cache.ha.db.dao.DbCacheReader;
import kd.bos.cache.ha.db.dao.IWriteAction;
import kd.bos.cache.ha.db.dao.WriteHelper;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;

class AddListAction
implements IWriteAction {
    private String regionKey;
    private String type;
    private String[] values;
    private Date currTime = WriteHelper.getCurrTime();
    private long timeoutSeconds;
    private int listLength = 0;

    public AddListAction(String regionKey, String type, String[] values, int timeoutSeconds) {
        this.regionKey = regionKey;
        this.type = type;
        this.values = values == null ? new String[0] : Arrays.copyOf(values, values.length);
        this.timeoutSeconds = timeoutSeconds;
    }

    private boolean validate() {
        return this.regionKey != null && this.type != null && !"".equals(this.type) && this.values != null && this.values.length != 0;
    }

    @Override
    public String getLockKey() {
        return WriteHelper.getLockKey(this.regionKey, this.type);
    }

    @Override
    public void execute() {
        if (!this.validate()) {
            return;
        }
        DbCacheReader reader = new DbCacheReader();
        Long id = reader.loadId(this.regionKey, this.type);
        int size = 0;
        try (TXHandle h = TX.requiresNew((String)AddListAction.class.getSimpleName());){
            try {
                if (id == null) {
                    id = WriteHelper.insertListType(this.regionKey, this.type, this.currTime, this.timeoutSeconds);
                } else {
                    WriteHelper.updateListOvertime(id, this.currTime, this.timeoutSeconds);
                    size = reader.loadListLength(this.regionKey, this.type);
                }
                int beginSeq = size + 1;
                WriteHelper.insertListValues(id, beginSeq, this.values, this.currTime, this.timeoutSeconds);
            }
            catch (Exception e) {
                h.markRollback();
                throw e;
            }
        }
        this.listLength = size + this.values.length;
    }

    public int getListLength() {
        return this.listLength;
    }
}

