/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cache.ha.db.dao;

import kd.bos.cache.ha.db.dao.IWriteAction;
import kd.bos.context.RequestContext;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

class DbCacheWriteRunner
implements Runnable {
    private static final Log LOG = LogFactory.getLog(DbCacheWriteRunner.class);
    private RequestContext rc = RequestContext.get();
    private IWriteAction writeAction;

    public DbCacheWriteRunner(IWriteAction writeAction) {
        this.writeAction = writeAction;
    }

    @Override
    public void run() {
        RequestContext.copyAndSet((RequestContext)this.rc);
        this.execute();
    }

    public void execute() {
        if (this.rc == null) {
            return;
        }
        try {
            this.save();
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    private void save() {
        try (TXHandle h = TX.notSupported((String)DbCacheWriteRunner.class.getSimpleName());){
            this.writeAction.execute();
        }
    }
}

