/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cache.ha.db.dao;

import java.util.Date;
import kd.bos.cache.ha.db.dao.DbCacheReader;
import kd.bos.cache.ha.db.dao.IWriteAction;
import kd.bos.cache.ha.db.dao.WriteHelper;

class ExpireAfterAction
implements IWriteAction {
    private String regionKey;
    private String keyOrType;
    private Date currTime = WriteHelper.getCurrTime();
    private long timeoutSecond;

    public ExpireAfterAction(String regionKey, String keyOrType, int timeoutSecond) {
        this.regionKey = regionKey;
        this.keyOrType = keyOrType;
        this.timeoutSecond = timeoutSecond;
    }

    private boolean validate() {
        return this.regionKey != null && this.keyOrType != null && !"".equals(this.keyOrType);
    }

    @Override
    public String getLockKey() {
        return WriteHelper.getLockKey(this.regionKey, this.keyOrType);
    }

    @Override
    public void execute() {
        if (!this.validate()) {
            return;
        }
        DbCacheReader reader = new DbCacheReader();
        Long id = reader.loadId(this.regionKey, this.keyOrType);
        if (id != null) {
            WriteHelper.updateListOvertime(id, this.currTime, this.timeoutSecond);
        }
    }
}

