/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cache.ha.db.dao;

import java.util.Arrays;
import java.util.Date;
import kd.bos.cache.ha.db.dao.DbCacheReader;
import kd.bos.cache.ha.db.dao.IWriteAction;
import kd.bos.cache.ha.db.dao.WriteHelper;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;

class InsertListAction
implements IWriteAction {
    private String regionKey;
    private String type;
    private int index;
    private String[] values;
    private Date currTime = WriteHelper.getCurrTime();
    private long timeoutSeconds;

    public InsertListAction(String regionKey, String type, int index, String[] values, int timeoutSeconds) {
        this.regionKey = regionKey;
        this.type = type;
        this.index = index;
        this.values = values == null ? new String[0] : Arrays.copyOf(values, values.length);
        this.timeoutSeconds = timeoutSeconds;
    }

    private boolean validate() {
        return this.regionKey != null && this.type != null && !"".equals(this.type) && this.index >= 0 && this.values != null && this.values.length != 0;
    }

    @Override
    public String getLockKey() {
        return WriteHelper.getLockKey(this.regionKey, this.type);
    }

    @Override
    public void execute() {
        if (!this.validate()) {
            return;
        }
        DbCacheReader reader = new DbCacheReader();
        Long id = reader.loadId(this.regionKey, this.type);
        int beginSeq = this.index + 1;
        try (TXHandle h = TX.requiresNew((String)InsertListAction.class.getSimpleName());){
            try {
                if (id == null) {
                    id = WriteHelper.insertListType(this.regionKey, this.type, this.currTime, this.timeoutSeconds);
                } else {
                    WriteHelper.updateListOvertime(id, this.currTime, this.timeoutSeconds);
                    WriteHelper.updateListSeq(id, beginSeq, this.values.length);
                }
                WriteHelper.insertListValues(id, beginSeq, this.values, this.currTime, this.timeoutSeconds);
            }
            catch (Exception e) {
                h.markRollback();
                throw e;
            }
        }
    }
}

