/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cache.ha.db.dao;

import java.util.Arrays;
import java.util.Set;
import kd.bos.cache.ha.db.dao.DbCacheReader;
import kd.bos.cache.ha.db.dao.IWriteAction;
import kd.bos.cache.ha.db.dao.WriteHelper;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;

class RemoveKeyValueAction
implements IWriteAction {
    private String regionKey;
    private String[] keys;

    public RemoveKeyValueAction(String regionKey, String key) {
        this.regionKey = regionKey;
        this.keys = key == null || "".equals(key) ? new String[0] : new String[]{key};
    }

    public RemoveKeyValueAction(String regionKey, String[] keys) {
        this.regionKey = regionKey;
        this.keys = Arrays.copyOf(keys, keys.length);
    }

    private boolean validate() {
        return this.regionKey != null && this.keys != null && this.keys.length != 0;
    }

    @Override
    public String getLockKey() {
        return WriteHelper.getLockKey(this.regionKey, this.keys[0]);
    }

    @Override
    public void execute() {
        if (!this.validate()) {
            return;
        }
        DbCacheReader reader = new DbCacheReader();
        Set<Long> ids = reader.loadIds(this.regionKey, this.keys);
        if (!ids.isEmpty()) {
            SqlBuilder delMain = new SqlBuilder();
            delMain.append("delete t_log_dbcache where ", new Object[0]);
            delMain.appendIn("fid", (Object[])ids.toArray(new Long[0]));
            DB.execute((DBRoute)DBRoute.log, (SqlBuilder)delMain);
            SqlBuilder delEntryList = new SqlBuilder();
            delEntryList.append("delete t_log_dbcacheentry where ", new Object[0]);
            delEntryList.appendIn("fid", (Object[])ids.toArray(new Long[0]));
            DB.execute((DBRoute)DBRoute.log, (SqlBuilder)delEntryList);
        }
    }
}

