/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cache.ha.db.dao;

import kd.bos.cache.ha.db.dao.DbCacheReader;
import kd.bos.cache.ha.db.dao.IWriteAction;
import kd.bos.cache.ha.db.dao.WriteHelper;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;

class RemoveListObjectAction
implements IWriteAction {
    private String regionKey;
    private String key;
    private int index;
    private int length;

    public RemoveListObjectAction(String regionKey, String key, int index, int length) {
        this.regionKey = regionKey;
        this.key = key;
        this.index = index;
        this.length = length;
    }

    private boolean validate() {
        return this.regionKey != null && this.key != null && !"".equals(this.key) && this.index >= 0 && this.length > 0;
    }

    @Override
    public String getLockKey() {
        return WriteHelper.getLockKey(this.regionKey, this.key);
    }

    @Override
    public void execute() {
        if (!this.validate()) {
            return;
        }
        DbCacheReader reader = new DbCacheReader();
        Long id = reader.loadId(this.regionKey, this.key);
        if (id == null) {
            return;
        }
        int beginSeq = this.index + 1;
        int endSeq = this.index + this.length;
        try (TXHandle h = TX.requiresNew((String)RemoveListObjectAction.class.getSimpleName());){
            try {
                WriteHelper.deleteListValues(id, beginSeq, endSeq);
                WriteHelper.updateListSeq(id, beginSeq, -this.length);
            }
            catch (Exception e) {
                h.markRollback();
                throw e;
            }
        }
    }
}

