
function JmxChartsFactory(jmxapiurl, keepHistorySec, pollInterval, columnsCount) {
    var jolokia = new Jolokia(jmxapiurl);
    var charts = [];
    var monitoredMbeans = [];
    var chartsCount = 0;

    columnsCount = columnsCount || 4;
    pollInterval = pollInterval || 1000;
    var keepPoints = (keepHistorySec || 60) / (pollInterval / 1000);

    setupPortletsContainer(columnsCount);

    setInterval(function() {
        pollAndUpdateCharts();
    }, pollInterval);

     
    var beanToChartsMap = {};
    
    this.create = function(chartBean) {
        var chart = new JMXChart(chartBean);
        charts = charts.concat(chart);
        $.map(chartBean.series, function(serie){
        	var mbean = serie.mbean;
        	var key = getMbeanKey(mbean);
        	
        	var charts = beanToChartsMap[key];
        	if(!charts)
        	{
        		charts = [chart];
        		monitoredMbeans = monitoredMbeans.concat(mbean);
        	}
        	else
        		charts.push(chart);
        	
        });
    };

    function getMbeanKey(mbean)
    {
    	var ret = mbean.name + "-" + mbean.attribute;
    	if(mbean.path)
    		ret += "-" + mbean.path;
    	return ret;
    }
    
    function pollAndUpdateCharts() {
        var requests = prepareBatchRequest();
        var responses = jolokia.request(requests);
        updateCharts(responses);
    }

    this.startRenderer = pollAndUpdateCharts;
    
    function createNewPortlet(name) {
        return $('#portlet-template')
                .clone(true)
                .appendTo($('.column')[chartsCount++ % columnsCount])
                .removeAttr('id')
                .find('.title').text((name.length > 50? '...' : '') + name.substring(name.length - 50, name.length)).end()
                .find('.portlet-content')[0];
    }

    function setupPortletsContainer() {
        var column = $('.column');
        for(var i = 1; i < columnsCount; ++i){
            column.clone().appendTo(column.parent());
        }
        $(".column").sortable({
            connectWith: ".column"
        });

        $(".portlet-header .ui-icon").click(function() {
            $(this).toggleClass("ui-icon-minusthick").toggleClass("ui-icon-plusthick");
            $(this).parents(".portlet:first").find(".portlet-content").toggle();
        });
        $(".column").disableSelection();
    }

    function prepareBatchRequest() {
        return $.map(monitoredMbeans, function(mbean) {
            return {
                type: "read",
                mbean: mbean.name,
                attribute: mbean.attribute,
                path: mbean.path
            };
        });
    }

    function updateCharts(responses) {
        var beanToResponseMap = {};
        for(var i=0;i<monitoredMbeans.length;i++)
        {
        	var mbean = monitoredMbeans[i];
        	var response = responses[i];
        	
        	beanToResponseMap[getMbeanKey(mbean)]=response;
        }
        
        $.map(charts, function(chart) {
        	
        	var series = chart.series;
        	var points = [];
        	
        	var valueLabel = "";
        	for(var i=0;i<series.length;i++)
        	{
        		var mbean = series[i].mbean;
        		var response = beanToResponseMap[getMbeanKey(mbean)];
        		var value = parseFloat(response.value);
        		points[i] = [response.timestamp*1000, value];
        		valueLabel += createValueLabel(series[i], value);
        	}
        	
            chart.addPoint(points, valueLabel);
        });
    }
    
    function createValueLabel(serie, value)
    {
    	return (serie.label?serie.label:"value") + ":" + formatNumber(value) + " ";
    }
    
    function formatNumber(num)
    {
    	if(!num)
    		return 0;
    	
    	if(isInteger(num))
    		return formatIntNumber(num);
    	else
    		return formatFloatNumber(num,4,true);
    }
    
    function isInteger(obj) {
    	 return Math.floor(obj) === obj
    }
    
    function formatIntNumber(num) {
        if (isNaN(num)) {
            throw new TypeError("num is not a number");
        }
     
        return ("" + num).replace(/(\d{1,3})(?=(\d{3})+(?:$|\.))/g, "$1,"); 
    }
    
    /* 
    将数值四舍五入后格式化. 
    @param num 数值(Number或者String) 
    @param cent 要保留的小数位(Number) 
    @param isThousand 是否需要千分位 0:不需要,1:需要(数值类型); 
    @return 格式的字符串,如'1,234,567.45' 
    @type String 
    */ 
    function formatFloatNumber(num,cent,isThousand){
    
    num = num.toString().replace(/\$|\,/g,''); 
    if(isNaN(num))//检查传入数值为数值类型. 
    num = "0"; 
    if(isNaN(cent))//确保传入小数位为数值型数值. 
    cent = 0; 
    cent = parseInt(cent); 
    cent = Math.abs(cent);//求出小数位数,确保为正整数. 
    if(isNaN(isThousand))//确保传入是否需要千分位为数值类型. 
    isThousand = 0; 
    isThousand = parseInt(isThousand); 
    if(isThousand < 0) 
    isThousand = 0; 
    if(isThousand >=1) //确保传入的数值只为0或1 
    isThousand = 1; 
    sign = (num == (num = Math.abs(num)));//获取符号(正/负数) 
    //Math.floor:返回小于等于其数值参数的最大整数 
    num = Math.floor(num*Math.pow(10,cent)+0.50000000001);//把指定的小数位先转换成整数.多余的小数位四舍五入. 
    cents = num%Math.pow(10,cent); //求出小数位数值. 
    num = Math.floor(num/Math.pow(10,cent)).toString();//求出整数位数值. 
    cents = cents.toString();//把小数位转换成字符串,以便求小数位长度. 
    while(cents.length<cent){//补足小数位到指定的位数. 
    cents = "0" + cents; 
    } 
    if(isThousand == 0) //不需要千分位符. 
    return (((sign)?'':'-') + num + '.' + cents); 
    //对整数部分进行千分位格式化. 
    for (var i = 0; i < Math.floor((num.length-(1+i))/3); i++) 
    num = num.substring(0,num.length-(4*i+3))+','+ 
    num.substring(num.length-(4*i+3)); 
    return (((sign)?'':'-') + num + '.' + cents); 
    } 
    
    function getTickFormatter(type)
    {
    	return function(val,axis){
    		
    		if(type=='percent')
        	{
   				return "" + (val * 100).toFixed(axis.tickDecimals) + "%"; 
        	}
    		else if(type=='mkb1024')
    		{
    		    if (val > (1024*1024))
    		        return (val / (1024*1024)).toFixed(axis.tickDecimals) + "MB";
    		      else if (val > 1024)
    		        return (val / 1024).toFixed(axis.tickDecimals) + "KB";
    		      else
    		        return val.toFixed(axis.tickDecimals) + "B";
    		}
    		else if(type=='mkb1000')
    		{
    		    if (val > 1000000)
    		        return (val / 1000000).toFixed(axis.tickDecimals) + "M";
    		      else if (val > 1000)
    		        return (val / 1000).toFixed(axis.tickDecimals) + "K";
    		      else
    		        return val.toFixed(axis.tickDecimals);
    		}
    		else
    			return val;
    	}
    }

    // 节点提示
    function showTooltip(x, y, contents) {
        $('<div id="tooltip">' + contents + '</div>').css( {
            position: 'absolute',
            display: 'none',
            top: y + 10,
            left: x + 10,
            border: '1px solid #fdd',
            padding: '2px',
            'background-color': '#dfeffc',
            opacity: 0.80
        }).appendTo("body").fadeIn(200);
    }

    var previousPoint = null;
    
    function bindHoverListener(placeHolder)
    {
    	/*会阻止轮询时间
        // 绑定提示事件
    	$(placeHolder).bind("plothover", function (event, pos, item) {
            if (item) {
                if (previousPoint != item.dataIndex) {
                    previousPoint = item.dataIndex;
                    $("#tooltip").remove();
                    var y = item.datapoint[1].toFixed(0);

                    var tip = "展现量：";
                    showTooltip(item.pageX, item.pageY,tip+y);
                }
            }
            else {
                $("#tooltip").remove();
                previousPoint = null;
            }
        });
        */
    }

    
    function JMXChart(chartBean) {
    	
    	this.series = chartBean.series;
    	
   	    var options = {
			charts: { shadowSize: 1 }, 
			yaxis: {},
			xaxis: { 
				mode: "time", 
				timezone:"browser",
				tickFormatter: function (val, axis) {  
	                var d = new Date(val);  
	                //return d.toLocaleTimeString();//转为当地时间格式
	                return "" + d.getHours()+":"+d.getMinutes()+":" + d.getSeconds();
	            }	
			},
			  
			grid: { hoverable: true},
			lines: {  
                show: true  
            },  
		};
   	    
   	    if(chartBean.yaxisFormatter)
   	    {
   	    	options.yaxis.tickFormatter = getTickFormatter(chartBean.yaxisFormatter);
   	    }
   	    
   	    if(chartBean.showLegend)
   	    {
   	    	options.legend = {show:true, backgroundColor:"gray",backgroundOpacity:0.2}
   	    }
   	    
   	    this.datas = [];
   	    for(var i=0;i<this.series.length;i++)
   	    {
   	    	this.datas.push({label:this.series[i].label,data:[0,0]});
   	    }
   	    
   	    var placeHolder = createNewPortlet(chartBean.title);
		this.plot = $.plot(placeHolder, this.datas, options);
		
		bindHoverListener(placeHolder);
		
		this.addPoint = function(points, valueLabel) {
			
			for(var i=0;i<points.length;i++)
			{
				var data = this.datas[i];
				var point = points[i];
				while (data.data.length >= keepPoints) {
					data.data = data.data.slice(1);
				}
				
				data.data.push(point);
			}
			
			this.plot.setData(this.datas);
			this.plot.setupGrid();
			this.plot.draw();
			this.plot.getPlaceholder().parent().find(".chart-values").text(valueLabel);
			
    	}
    }
    

    
}