grammar KingScript;

REFERENCE_INDEX: '///';
REFERENCE_KEYWORD: 'reference';
REFERENCE_TYPES: 'types';

EQUAL_KEYWORD: '=';

QUOTATION_TWO: '"';

BRACKET_OPEN_S: '<';
BRACKET_CLOSE_S: '>';

BRACKET_OPEN_M: '(';
BRACKET_CLOSE_M: ')';

BRACKET_OPEN_B: '{';
BRACKET_CLOSE_B: '}';

SLASHES_CORRECT: '/';
SEMI: ';';
COLON: ':';
QUESTION: '?';
AMPERSAND: '&';
COMMA: ',';

READONLY: 'readonly';

COMMENT: BLOCK_COMMENT;  //注释
//LINE_COMMENT: '//' ~[\r\n]*;  //行注释
BLOCK_COMMENT: '/*' .*? '*/' -> channel(HIDDEN); //块注释

DECLARE: 'declare';
GLOBAL: 'global';
NAMESPACE: 'namespace';
INTERFACE: 'interface';
CLASS: 'class';
STATIC: 'static';
TYPE: 'type';
EXTENDS: 'extends';
NEW: 'new';
EXPORT: 'export';
ENUM: 'enum';

IDENTIFIER: [a-zA-Z$_][a-zA-Z0-9$_]*;
STRING
    : '"' ( [^"\r\n]+ ) '"' // Allows any characters except double quotes, carriage returns, and newlines
    ;


WS: [ \t\r\n]+ -> skip; // 忽略空白字符


keywordList
  : REFERENCE_KEYWORD | REFERENCE_TYPES | DECLARE | GLOBAL | NAMESPACE | INTERFACE | TYPE | EXTENDS | NEW | EXPORT | ENUM | IDENTIFIER | STRING | CLASS
  ;




// 语法规则
startRule
  : (referenceDirective | declareGlobalBlock | exportDeclaration | COMMENT)* EOF
  ;


statement
  : namespaceBlock
  | typeDeclaration
  | interfaceBlock
  | classBlock
  | enumDeclaration
  ;

statementList
    : statement+
    ;


exportDeclaration
  : EXPORT BRACKET_OPEN_B BRACKET_CLOSE_B SEMI?
  ;

//引用
referenceDirective 
  :  REFERENCE_INDEX BRACKET_OPEN_S REFERENCE_KEYWORD REFERENCE_TYPES EQUAL_KEYWORD QUOTATION_TWO referenceName QUOTATION_TWO SLASHES_CORRECT BRACKET_CLOSE_S
  ;

referenceName
  : IDENTIFIER ('-' IDENTIFIER)*
  ; 

//全局声明
declareGlobalBlock
  : DECLARE GLOBAL BRACKET_OPEN_B statementList+ BRACKET_CLOSE_B
  ;

//namespace
namespaceBlock
  : NAMESPACE namespaceName BRACKET_OPEN_B statementList+ BRACKET_CLOSE_B
  ;

namespaceName
  : IDENTIFIER ('.' IDENTIFIER)*
  ;

//type
typeDeclaration
  : TYPE typeDeclarationName EQUAL_KEYWORD typeExpression SEMI
  ;

typeDeclarationName
  : IDENTIFIER
  ;

typeExpression
  : classTypeObject (AMPERSAND classTypeObject)*
  ;


enumDeclaration
  : ENUM enumDeclarationName BRACKET_OPEN_B enumExpression* BRACKET_CLOSE_B
  ;

enumDeclarationName
  : IDENTIFIER
  ;

enumExpression
  : IDENTIFIER COMMA?
  ;


classBlock
  : CLASS classBlockName (EXTENDS classBlockExtends)? BRACKET_OPEN_B interfaceBlockMember* BRACKET_CLOSE_B
  ;

classBlockName
  : IDENTIFIER | keywordList
  ; 

classBlockExtends
  : IDENTIFIER | keywordList
  ; 

//interface
interfaceBlock
  : INTERFACE interfaceBlockName (EXTENDS interfaceBlockExtends)? BRACKET_OPEN_B interfaceBlockMember* BRACKET_CLOSE_B
  ;

interfaceBlockMember
  : fieldDeclaration 
  | methodDeclaration
  ;

interfaceBlockExtends
  : IDENTIFIER | keywordList
  ;

interfaceBlockName
  : IDENTIFIER | keywordList
  ;


//方法
methodDeclaration
  : COMMENT? STATIC? methodDeclarationName QUESTION? BRACKET_OPEN_M paramListDeclaration? BRACKET_CLOSE_M COLON returnDeclaration SEMI
  ;

methodDeclarationName
  : NEW | IDENTIFIER | keywordList
  ;

//字段
fieldDeclaration
  : COMMENT? STATIC? READONLY? fieldDeclarationName COLON classTypeObject SEMI
  ;

fieldDeclarationName
  : IDENTIFIER | keywordList
  ;

//多个参数
paramListDeclaration
  : paramDeclaration (',' paramDeclaration)*
  ;

paramDeclaration
  : paramOneDeclaration | paramFunctionDeclaration
  ;

//一个参数
paramOneDeclaration
  : ('...')? paramFunctionDeclarationName COLON classTypeObject
  ;

//consumer1: (t: any) => void
paramFunctionDeclaration
  : paramFunctionDeclarationName COLON paramFunctionBody
  ;

paramFunctionBody
  : BRACKET_OPEN_M paramOneDeclaration (',' paramOneDeclaration)* BRACKET_CLOSE_M '=>' classTypeObject
  | BRACKET_OPEN_M BRACKET_CLOSE_M '=>' classTypeObject
  ;

paramFunctionDeclarationName
  : IDENTIFIER | keywordList
  ;

returnDeclaration
  : classTypeObject | paramFunctionBody
  ;

//数据类型
classTypeObject
  : (IDENTIFIER | keywordList) ('.' (IDENTIFIER | keywordList))* ('[]')*
  ;


