/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.jdbc;

import java.lang.reflect.Field;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class Configuration {
    private String user = null;
    private String password = null;
    private String account = null;
    private String database = null;
    private String schema = null;
    String domainUrl = null;
    private String initialUrl = null;
    private Properties nonMappedOption = null;
    private int defaultFetchSize = 0;
    private int connectTimeout = DriverManager.getLoginTimeout() > 0 ? DriverManager.getLoginTimeout() * 1000 : 30000;
    private int maxAllowedPacket = 0xFFFFFF;

    private Configuration() {
    }

    private Configuration(ConfigurationBuilder configurationBuilder) {
        this.user = configurationBuilder.user;
        this.password = configurationBuilder.password;
        this.account = configurationBuilder.account;
        this.database = configurationBuilder.database;
        this.schema = configurationBuilder.schema;
        this.domainUrl = configurationBuilder.domainUrl;
        this.nonMappedOption = configurationBuilder._nonMappedOption;
        this.defaultFetchSize = configurationBuilder.defaultFetchSize;
        this.connectTimeout = configurationBuilder.connectTimeout;
        this.initialUrl = Configuration.buildUrl(this);
    }

    public static Configuration parseUrl(String url, Properties info) throws SQLException {
        if (Configuration.acceptsURL(url)) {
            return Configuration.parseInternal(url, info == null ? new Properties() : info);
        }
        return null;
    }

    private static Configuration parseInternal(String url, Properties properties) throws SQLException {
        try {
            String additionalParameters;
            String hostAddressesString;
            int paramIndex;
            ConfigurationBuilder builder = new ConfigurationBuilder();
            int separator = url.indexOf("//");
            if (separator == -1) {
                throw new IllegalArgumentException("url parsing error : '//' is not present in the url " + url);
            }
            String urlSecondPart = url.substring(separator + 2);
            int dbIndex = urlSecondPart.lastIndexOf("/");
            if (dbIndex < (paramIndex = urlSecondPart.indexOf("?")) && dbIndex < 0 || dbIndex > paramIndex && paramIndex > -1) {
                hostAddressesString = urlSecondPart.substring(0, paramIndex);
                additionalParameters = urlSecondPart.substring(paramIndex);
            } else if (dbIndex < paramIndex || dbIndex > paramIndex) {
                hostAddressesString = urlSecondPart.substring(0, dbIndex);
                additionalParameters = urlSecondPart.substring(dbIndex);
            } else {
                hostAddressesString = urlSecondPart;
                additionalParameters = null;
            }
            builder.domainUrl(hostAddressesString);
            if (additionalParameters != null) {
                String account;
                int optIndex = additionalParameters.indexOf("?");
                if (optIndex < 0) {
                    account = additionalParameters.length() > 1 ? additionalParameters.substring(1) : null;
                } else {
                    if (optIndex == 0) {
                        account = null;
                    } else {
                        account = additionalParameters.substring(1, optIndex);
                        if (account.isEmpty()) {
                            account = null;
                        }
                    }
                    String urlParameters = additionalParameters.substring(optIndex + 1);
                    if (urlParameters != null && !urlParameters.isEmpty()) {
                        String[] parameters;
                        for (String parameter : parameters = urlParameters.split("&")) {
                            int pos = parameter.indexOf(61);
                            if (pos == -1) {
                                properties.setProperty(parameter, "");
                                continue;
                            }
                            properties.setProperty(parameter.substring(0, pos), parameter.substring(pos + 1));
                        }
                    }
                }
                builder.account(account);
            } else {
                builder.account(null);
            }
            Configuration.mapPropertiesToOption(builder, properties);
            return builder.build();
        }
        catch (IllegalArgumentException i) {
            throw new SQLException("error parsing url : " + i.getMessage(), i);
        }
    }

    private static void mapPropertiesToOption(ConfigurationBuilder builder, Properties properties) {
        Properties nonMappedOptions = new Properties();
        try {
            Set<Map.Entry<Object, Object>> entries = properties.entrySet();
            for (Map.Entry<Object, Object> next : entries) {
                Object keyObj = next.getKey();
                Object propertyValue = next.getValue();
                if (propertyValue == null) continue;
                try {
                    Field field = ConfigurationBuilder.class.getDeclaredField(keyObj.toString());
                    field.setAccessible(true);
                    if (field.getGenericType().equals(String.class) && !propertyValue.toString().isEmpty()) {
                        field.set(builder, propertyValue);
                        continue;
                    }
                    if (field.getGenericType().equals(Boolean.class)) {
                        switch (propertyValue.toString().toLowerCase(Locale.ENGLISH)) {
                            case "": 
                            case "1": 
                            case "true": {
                                field.set(builder, Boolean.TRUE);
                                break;
                            }
                            case "0": 
                            case "false": {
                                field.set(builder, Boolean.FALSE);
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException(String.format("Optional parameter %s must be boolean (true/false or 0/1) was '%s'", keyObj, propertyValue));
                            }
                        }
                        continue;
                    }
                    if (!field.getGenericType().equals(Integer.class)) continue;
                    try {
                        Integer value = Integer.parseInt(propertyValue.toString());
                        field.set(builder, value);
                    }
                    catch (NumberFormatException n) {
                        throw new IllegalArgumentException(String.format("Optional parameter %s must be Integer, was '%s'", keyObj, propertyValue), n);
                    }
                }
                catch (NoSuchFieldException nfe) {
                    nonMappedOptions.setProperty(String.valueOf(keyObj), String.valueOf(propertyValue));
                }
            }
        }
        catch (IllegalAccessException | SecurityException s) {
            throw new IllegalArgumentException("Unexpected error", s);
        }
        builder._nonMappedOption = nonMappedOptions;
    }

    public static boolean acceptsURL(String url) {
        return url != null && url.toLowerCase(Locale.ENGLISH).startsWith("jdbc:flydb:") && !url.toLowerCase(Locale.ENGLISH).startsWith("jdbc:flydb://internal");
    }

    static String buildUrl(Configuration configuration) {
        Configuration defaultConf = new Configuration();
        StringBuilder sb = new StringBuilder();
        sb.append("jdbc:flydb:");
        sb.append("//");
        sb.append("domainUrl=(").append(configuration.domainUrl).append(")");
        sb.append("/");
        if (configuration.account != null) {
            sb.append(configuration.account);
        }
        try {
            Field[] fields;
            boolean first = true;
            for (Field field : fields = Configuration.class.getDeclaredFields()) {
                Object obj;
                if ("accountName".equals(field.getName()) || (obj = field.get(configuration)) == null || obj instanceof Properties && ((Properties)obj).size() <= 0) continue;
                if ("password".equals(field.getName())) {
                    sb.append(first ? (char)'?' : '&');
                    first = false;
                    sb.append(field.getName()).append('=');
                    sb.append("***");
                    continue;
                }
                if (field.getType().equals(String.class)) {
                    sb.append(first ? (char)'?' : '&');
                    first = false;
                    sb.append(field.getName()).append('=');
                    sb.append((String)obj);
                    continue;
                }
                if (field.getType().equals(Boolean.TYPE)) {
                    boolean defaultValue = field.getBoolean(defaultConf);
                    if (obj.equals(defaultValue)) continue;
                    sb.append(first ? (char)'?' : '&');
                    first = false;
                    sb.append(field.getName()).append('=');
                    sb.append(obj);
                    continue;
                }
                if (field.getType().equals(Integer.TYPE)) {
                    try {
                        int defaultValue = field.getInt(defaultConf);
                        if (obj.equals(defaultValue)) continue;
                        sb.append(first ? (char)'?' : '&');
                        sb.append(field.getName()).append('=').append(obj);
                        first = false;
                    }
                    catch (IllegalAccessException defaultValue) {}
                    continue;
                }
                if (field.getType().equals(Properties.class)) {
                    sb.append(first ? (char)'?' : '&');
                    first = false;
                    boolean firstProp = true;
                    Properties properties = (Properties)obj;
                    for (Map.Entry<Object, Object> objectEntry : properties.entrySet()) {
                        if (firstProp) {
                            firstProp = false;
                        } else {
                            sb.append('&');
                        }
                        sb.append(objectEntry.getKey()).append('=');
                        sb.append(objectEntry.getValue());
                    }
                    continue;
                }
                Object defaultValue = field.get(defaultConf);
                if (obj.equals(defaultValue)) continue;
                sb.append(first ? (char)'?' : '&');
                first = false;
                sb.append(field.getName()).append('=');
                sb.append(obj);
            }
        }
        catch (IllegalAccessException first) {
        }
        catch (SecurityException s) {
            throw new IllegalArgumentException("Security too restrictive : " + s.getMessage(), s);
        }
        return sb.toString();
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public String getAccount() {
        return this.account;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getDomainUrl() {
        return this.domainUrl;
    }

    public String getInitialUrl() {
        return this.initialUrl;
    }

    public Properties getNonMappedOption() {
        return this.nonMappedOption;
    }

    public int getDefaultFetchSize() {
        return this.defaultFetchSize;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    private static String nullOrEmpty(String val) {
        return val == null || val.isEmpty() ? null : val;
    }

    public Integer getMaxAllowedPacket() {
        return this.maxAllowedPacket;
    }

    public static final class ConfigurationBuilder {
        private String user = null;
        private String password = null;
        private String account = null;
        private String database = null;
        private String schema = null;
        public String domainUrl = null;
        private Properties _nonMappedOption = null;
        private int defaultFetchSize = 0;
        private int connectTimeout = DriverManager.getLoginTimeout() > 0 ? DriverManager.getLoginTimeout() * 1000 : 30000;

        public ConfigurationBuilder user(String user) {
            this.user = Configuration.nullOrEmpty(user);
            return this;
        }

        public ConfigurationBuilder password(String password) {
            this.password = Configuration.nullOrEmpty(password);
            return this;
        }

        public ConfigurationBuilder account(String account) {
            this.account = Configuration.nullOrEmpty(account);
            return this;
        }

        public ConfigurationBuilder database(String database) {
            this.database = Configuration.nullOrEmpty(database);
            return this;
        }

        public ConfigurationBuilder schema(String schema) {
            this.schema = Configuration.nullOrEmpty(schema);
            return this;
        }

        public ConfigurationBuilder domainUrl(String domainUrl) {
            this.domainUrl = domainUrl;
            return this;
        }

        public ConfigurationBuilder nonMappedOption(Properties nonMappedOption) {
            this._nonMappedOption = nonMappedOption;
            return this;
        }

        public ConfigurationBuilder defaultFetchSize(int defaultFetchSize) {
            this.defaultFetchSize = defaultFetchSize;
            return this;
        }

        public ConfigurationBuilder connectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Configuration build() {
            Configuration configuration = new Configuration(this);
            configuration.initialUrl = Configuration.buildUrl(configuration);
            return configuration;
        }
    }
}

