/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import kd.bos.flydb.jdbc.Configuration;
import kd.bos.flydb.jdbc.FlyDBConnection;
import kd.bos.flydb.jdbc.client.impl.HttpClient;
import kd.bos.flydb.jdbc.exception.Exceptions;

public class Driver
implements java.sql.Driver {
    static final String DRIVER_NAME = "FlyDB JDBC Driver";
    static final int DRIVER_VERSION_MAJOR = 1;
    static final int DRIVER_VERSION_MINOR = 0;
    public static final String JDBC_INTERNAL_URL_ACCEPTS = "jdbc:flydb://internal";

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        ReentrantLock lock = new ReentrantLock();
        Configuration configuration = Configuration.parseUrl(url, info);
        if (configuration != null) {
            return this.connect(configuration, lock);
        }
        return null;
    }

    private Connection connect(Configuration configuration, ReentrantLock lock) throws SQLException {
        try {
            return new FlyDBConnection(configuration, new HttpClient(configuration, lock));
        }
        catch (Exception e) {
            throw Exceptions.wrap(e);
        }
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return Configuration.acceptsURL(url);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        Configuration conf = Configuration.parseUrl(url, info);
        if (conf == null) {
            return new DriverPropertyInfo[0];
        }
        Properties propDesc = new Properties();
        try {
            InputStream inputStream = Driver.class.getClassLoader().getResourceAsStream("driver.properties");
            Object object = null;
            try {
                propDesc.load(inputStream);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (inputStream != null) {
                    if (object != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        inputStream.close();
                    }
                }
            }
        }
        catch (IOException inputStream) {
            // empty catch block
        }
        ArrayList<DriverPropertyInfo> props = new ArrayList<DriverPropertyInfo>();
        for (Field field : Configuration.ConfigurationBuilder.class.getDeclaredFields()) {
            if (field.getName().startsWith("_")) continue;
            try {
                Field fieldConf = Configuration.class.getDeclaredField(field.getName());
                fieldConf.setAccessible(true);
                Object obj = fieldConf.get(conf);
                String value = obj == null ? null : obj.toString();
                DriverPropertyInfo propertyInfo = new DriverPropertyInfo(field.getName(), value);
                propertyInfo.description = value == null ? "" : (String)propDesc.get(field.getName());
                propertyInfo.required = false;
                props.add(propertyInfo);
            }
            catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
                // empty catch block
            }
        }
        return props.toArray(new DriverPropertyInfo[0]);
    }

    @Override
    public int getMajorVersion() {
        return 1;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("Use logging parameters for enabling logging.");
    }

    static {
        try {
            DriverManager.registerDriver(new Driver());
        }
        catch (SQLException e) {
            throw new RuntimeException("Can't register driver!" + e.getMessage(), e);
        }
    }
}

