/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.jdbc;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import kd.bos.flydb.jdbc.Configuration;
import kd.bos.flydb.jdbc.FlyDBDatabaseMetaData;
import kd.bos.flydb.jdbc.FlyDBPreparedStatement;
import kd.bos.flydb.jdbc.FlyDBStatement;
import kd.bos.flydb.jdbc.client.Client;
import kd.bos.flydb.jdbc.client.Context;
import kd.bos.flydb.jdbc.exception.ErrorCode;
import kd.bos.flydb.jdbc.exception.Exceptions;

public class FlyDBConnection
implements Connection {
    private final Configuration configuration;
    private final Client client;
    private final int fetchSize;
    private final String connectionId;
    private boolean closed = false;

    public FlyDBConnection(Configuration configuration, Client client) {
        this.configuration = configuration;
        this.client = client;
        Context context = this.client.getContext();
        this.connectionId = context.getConnectionId();
        this.fetchSize = context.getConfiguration().getDefaultFetchSize();
    }

    public Client getClient() {
        return this.client;
    }

    public Context getContext() {
        return this.client.getContext();
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    @Override
    public Statement createStatement() throws SQLException {
        return new FlyDBStatement(this, this.fetchSize);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return new FlyDBPreparedStatement(this, sql, this.fetchSize);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        throw Exceptions.newUnsupportedFeature("Unsupported prepareCall(String sql)");
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return sql;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return true;
    }

    @Override
    public void commit() throws SQLException {
    }

    @Override
    public void rollback() throws SQLException {
    }

    @Override
    public void close() throws SQLException {
        try {
            this.client.close();
            this.closed = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return new FlyDBDatabaseMetaData(this, this.configuration);
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return true;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.configuration.getDatabase();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return 2;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        throw Exceptions.newUnsupportedFeature("Unsupported getWarnings()");
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        throw Exceptions.newUnsupportedFeature("Unsupported createStatement(int resultSetType, int resultSetConcurrency)");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw Exceptions.newUnsupportedFeature("Unsupported prepareStatement(String sql, int resultSetType, int resultSetConcurrency)");
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw Exceptions.newUnsupportedFeature("Unsupported prepareCall(String sql, int resultSetType, int resultSetConcurrency)");
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        throw Exceptions.newUnsupportedFeature("Unsupported getTypeMap()");
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        throw Exceptions.newUnsupportedFeature("Unsupported setTypeMap(Map<String, Class<?>> map)");
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        throw Exceptions.newUnsupportedFeature("Unsupported setHoldability(int holdability)");
    }

    @Override
    public int getHoldability() throws SQLException {
        throw Exceptions.newUnsupportedFeature("Unsupported getHoldability()");
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw Exceptions.newUnsupportedFeature("Unsupported setSavepoint()");
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        throw Exceptions.newUnsupportedFeature("Unsupported setSavepoint(String name)");
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        throw Exceptions.newUnsupportedFeature("Unsupported rollback(Savepoint savepoint)");
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw Exceptions.newUnsupportedFeature("Unsupported releaseSavepoint(Savepoint savepoint)");
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw Exceptions.newUnsupportedFeature("Unsupported createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability)");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw Exceptions.newUnsupportedFeature("Unsupported repareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability)");
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw Exceptions.newUnsupportedFeature("Unsupported prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability)");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        throw Exceptions.newUnsupportedFeature("Unsupported prepareStatement(String sql, int autoGeneratedKeys)");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        throw Exceptions.newUnsupportedFeature("Unsupported prepareStatement(String sql, int[] columnIndexes)");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        throw Exceptions.newUnsupportedFeature("Unsupported prepareStatement(String sql, String[] columnNames)");
    }

    @Override
    public Clob createClob() throws SQLException {
        throw Exceptions.newUnsupportedFeature("Unsupported createClob()");
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw Exceptions.newUnsupportedFeature("Unsupported createBlob()");
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw Exceptions.newUnsupportedFeature("Unsupported createNClob()");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw Exceptions.newUnsupportedFeature("Unsupported createSQLXML()");
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return true;
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        throw new SQLClientInfoException();
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        throw new SQLClientInfoException();
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        throw Exceptions.newUnsupportedFeature("Unsupported getClientInfo(String name)");
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        throw Exceptions.newUnsupportedFeature("Unsupported getClientInfo()");
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        throw Exceptions.newUnsupportedFeature("Unsupported createArrayOf(String typeName, Object[] elements)");
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw Exceptions.newUnsupportedFeature("Unsupported createStruct(String typeName, Object[] attributes)");
    }

    @Override
    public void setSchema(String schema) throws SQLException {
    }

    @Override
    public String getSchema() throws SQLException {
        return this.configuration.getSchema();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        throw Exceptions.newUnsupportedFeature("Unsupported abort(Executor executor)");
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        throw Exceptions.newUnsupportedFeature("Unsupported getNetworkTimeout()");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this)) {
            return iface.cast(this);
        }
        throw Exceptions.newSQLException(ErrorCode.ClientError_UnwrapFail, iface.getName());
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }
}

