/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import kd.bos.flydb.jdbc.FlyDBConnection;
import kd.bos.flydb.jdbc.FlyDBStatement;
import kd.bos.flydb.jdbc.client.result.CompleteResultSet;
import kd.bos.flydb.jdbc.client.result.Result;
import kd.bos.flydb.jdbc.client.transfer.bytebuf.StandardReadableByteBuf;
import kd.bos.flydb.jdbc.exception.ErrorCode;
import kd.bos.flydb.jdbc.exception.Exceptions;
import kd.bos.flydb.jdbc.packet.ServerPacket;
import kd.bos.flydb.jdbc.packet.client.QueryWithParametersPacket;
import kd.bos.flydb.jdbc.packet.server.ColumnDefinitionPacket;
import kd.bos.flydb.jdbc.util.ClientParser;
import kd.bos.flydb.jdbc.util.ParameterList;
import kd.bos.flydb.jdbc.util.encode.BigDecimalEncoder;
import kd.bos.flydb.jdbc.util.encode.BooleanEncoder;
import kd.bos.flydb.jdbc.util.encode.ByteEncoder;
import kd.bos.flydb.jdbc.util.encode.DateEncoder;
import kd.bos.flydb.jdbc.util.encode.DoubleEncoder;
import kd.bos.flydb.jdbc.util.encode.Encoder;
import kd.bos.flydb.jdbc.util.encode.FloatEncoder;
import kd.bos.flydb.jdbc.util.encode.IntegerEncoder;
import kd.bos.flydb.jdbc.util.encode.LongEncoder;
import kd.bos.flydb.jdbc.util.encode.ShortEncoder;
import kd.bos.flydb.jdbc.util.encode.StringEncoder;
import kd.bos.flydb.jdbc.util.encode.TimeEncoder;
import kd.bos.flydb.jdbc.util.encode.TimestampEncoder;
import kd.bos.flydb.jdbc.util.parameter.Parameter;
import kd.bos.flydb.jdbc.util.parameter.ParameterWithCalendar;

public class FlyDBPreparedStatement
extends FlyDBStatement
implements PreparedStatement {
    private final String sql;
    private ClientParser parser;
    private ParameterList parameters;

    public FlyDBPreparedStatement(FlyDBConnection connection, String sql, int fetchSize) {
        super(connection, fetchSize);
        this.sql = sql;
        this.parser = ClientParser.parameterParts(sql, false);
        this.parameters = new ParameterList(this.parser.getParamCount());
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        try {
            this.executeInternal();
            this.currResult = (ServerPacket)this.results.remove(0);
            if (this.currResult instanceof Result) {
                return (Result)this.currResult;
            }
            return new CompleteResultSet(this, new ColumnDefinitionPacket[0], new StandardReadableByteBuf(new byte[0], 0));
        }
        catch (Exception e) {
            throw Exceptions.wrap(e);
        }
    }

    private void executeInternal() throws SQLException {
        this.checkNotClosed();
        this.results = this.connection.getClient().execute(new QueryWithParametersPacket(this.parser, this.parameters, this.fetchSize, this.queryTimeout, this.connection.getConnectionId()), this, this.fetchSize);
    }

    @Override
    public void addBatch() throws SQLException {
    }

    @Override
    public void clearParameters() throws SQLException {
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.currResult instanceof Result) {
            return ((Result)this.currResult).getMetaData();
        }
        throw Exceptions.newSQLException(ErrorCode.ClientError_GetMetaDataBeforeQuery, new Object[0]);
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        throw Exceptions.newUnsupportedFeature("Unsupported getParameterMetaData()");
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, Parameter.NULL_PARAMETER);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new Parameter<Boolean>(BooleanEncoder.INSTANCE, x));
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new Parameter<Byte>(ByteEncoder.INSTANCE, x));
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new Parameter<Short>(ShortEncoder.INSTANCE, x));
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new Parameter<Integer>(IntegerEncoder.INSTANCE, x));
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new Parameter<Long>(LongEncoder.INSTANCE, x));
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new Parameter<Float>(FloatEncoder.INSTANCE, Float.valueOf(x)));
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new Parameter<Double>(DoubleEncoder.INSTANCE, x));
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new Parameter<BigDecimal>(BigDecimalEncoder.INSTANCE, x));
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new Parameter<String>(StringEncoder.INSTANCE, x));
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.checkIndex(parameterIndex);
        throw Exceptions.newUnsupportedFeature("Unsupported setBytes(int parameterIndex, byte[] x)");
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new Parameter<Date>(DateEncoder.INSTANCE, x));
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new Parameter<Time>(TimeEncoder.INSTANCE, x));
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new Parameter<Timestamp>(TimestampEncoder.INSTANCE, x));
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw Exceptions.newUnsupportedFeature("Unsupported setAsciiStream(int parameterIndex, InputStream x, int length)");
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw Exceptions.newUnsupportedFeature("Unsupported setUnicodeStream(int parameterIndex, InputStream x, int length)");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw Exceptions.newUnsupportedFeature("Unsupported setBinaryStream(int parameterIndex, InputStream x, int length)");
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.setInternalObject(parameterIndex, x, targetSqlType, null);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.setInternalObject(parameterIndex, x, null, null);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        throw Exceptions.newUnsupportedFeature("Unsupported setCharacterStream(int parameterIndex, Reader reader, int length)");
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        throw Exceptions.newUnsupportedFeature("Unsupported setBlob(int parameterIndex, Blob x)");
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        throw Exceptions.newUnsupportedFeature("Unsupported setClob(int parameterIndex, Clob x)");
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        throw Exceptions.newUnsupportedFeature("Unsupported setArray(int parameterIndex, Array x)");
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new ParameterWithCalendar((Encoder)DateEncoder.INSTANCE, x, cal));
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new ParameterWithCalendar((Encoder)TimeEncoder.INSTANCE, x, cal));
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, new ParameterWithCalendar((Encoder)TimestampEncoder.INSTANCE, x, cal));
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.checkIndex(parameterIndex);
        this.parameters.set(parameterIndex - 1, Parameter.NULL_PARAMETER);
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        throw Exceptions.newUnsupportedFeature("Unsupported setURL(int parameterIndex, URL x)");
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw Exceptions.newUnsupportedFeature("Unsupported setRowId(int parameterIndex, RowId x)");
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        throw Exceptions.newUnsupportedFeature("Unsupported setNString(int parameterIndex, String value)");
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        throw Exceptions.newUnsupportedFeature("Unsupported setNCharacterStream(int parameterIndex, Reader value, long length)");
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        throw Exceptions.newUnsupportedFeature("Unsupported setNClob(int parameterIndex, NClob value)");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw Exceptions.newUnsupportedFeature("Unsupported setClob(int parameterIndex, Reader reader, long length)");
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        throw Exceptions.newUnsupportedFeature("Unsupported setBlob(int parameterIndex, InputStream inputStream, long length)");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw Exceptions.newUnsupportedFeature("Unsupported setNClob(int parameterIndex, Reader reader, long length)");
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        throw Exceptions.newUnsupportedFeature("Unsupported setSQLXML(int parameterIndex, SQLXML xmlObject)");
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        this.setInternalObject(parameterIndex, x, targetSqlType, Long.valueOf(scaleOrLength));
    }

    private void setInternalObject(int parameterIndex, Object obj, Integer targetSqlType, Long scaleOrLength) throws SQLException {
        this.checkIndex(parameterIndex);
        if (obj == null) {
            this.parameters.set(parameterIndex - 1, Parameter.NULL_PARAMETER);
            return;
        }
        if (targetSqlType != null) {
            switch (targetSqlType) {
                case -8: 
                case 70: 
                case 2000: 
                case 2002: 
                case 2003: 
                case 2006: 
                case 2009: {
                    throw new SQLException("Type not supported");
                }
            }
            if (obj instanceof String || obj instanceof Character) {
                if (targetSqlType == 2004) {
                    throw new SQLException(String.format("Cannot convert a %s to a Blob", obj instanceof String ? "string" : "character"));
                }
                String str = obj instanceof String ? (String)obj : ((Character)obj).toString();
                try {
                    switch (targetSqlType) {
                        case -7: 
                        case 16: {
                            this.setBoolean(parameterIndex, !"false".equalsIgnoreCase(str) && !"0".equals(str));
                            return;
                        }
                        case -6: {
                            this.setByte(parameterIndex, Byte.parseByte(str));
                            return;
                        }
                        case 5: {
                            this.setShort(parameterIndex, Short.parseShort(str));
                            return;
                        }
                        case 4: {
                            this.setInt(parameterIndex, Integer.parseInt(str));
                            return;
                        }
                        case 6: 
                        case 8: {
                            this.setDouble(parameterIndex, Double.parseDouble(str));
                            return;
                        }
                        case 7: {
                            this.setFloat(parameterIndex, Float.parseFloat(str));
                            return;
                        }
                        case -5: {
                            this.setLong(parameterIndex, Long.parseLong(str));
                            return;
                        }
                        case 2: 
                        case 3: {
                            this.setBigDecimal(parameterIndex, new BigDecimal(str));
                            return;
                        }
                        case -16: 
                        case -15: 
                        case -9: 
                        case -1: 
                        case 1: 
                        case 12: 
                        case 2005: 
                        case 2011: {
                            this.setString(parameterIndex, str);
                            return;
                        }
                        case 93: {
                            if (str.startsWith("0000-00-00")) {
                                this.setTimestamp(parameterIndex, null);
                            } else {
                                this.setTimestamp(parameterIndex, Timestamp.valueOf(str));
                            }
                            return;
                        }
                        case 92: {
                            this.setTime(parameterIndex, Time.valueOf((String)obj));
                            return;
                        }
                    }
                    throw new SQLException(String.format("Could not convert [%s] to %s", str, targetSqlType));
                }
                catch (IllegalArgumentException e) {
                    throw new SQLException(String.format("Could not convert [%s] to java.sql.Type %s", str, targetSqlType), "HY000", e);
                }
            }
            if (obj instanceof Number) {
                Number bd = (Number)obj;
                switch (targetSqlType) {
                    case -6: {
                        this.setByte(parameterIndex, bd.byteValue());
                        return;
                    }
                    case 5: {
                        this.setShort(parameterIndex, bd.shortValue());
                        return;
                    }
                    case 4: {
                        this.setInt(parameterIndex, bd.intValue());
                        return;
                    }
                    case -5: {
                        this.setLong(parameterIndex, bd.longValue());
                        return;
                    }
                    case 6: 
                    case 8: {
                        this.setDouble(parameterIndex, bd.doubleValue());
                        return;
                    }
                    case 7: {
                        this.setFloat(parameterIndex, bd.floatValue());
                        return;
                    }
                    case 2: 
                    case 3: {
                        if (obj instanceof BigDecimal) {
                            this.setBigDecimal(parameterIndex, (BigDecimal)obj);
                        } else if (obj instanceof Double || obj instanceof Float) {
                            this.setDouble(parameterIndex, bd.doubleValue());
                        } else {
                            this.setLong(parameterIndex, bd.longValue());
                        }
                        return;
                    }
                    case -7: {
                        this.setBoolean(parameterIndex, bd.shortValue() != 0);
                        return;
                    }
                    case 1: 
                    case 12: {
                        this.setString(parameterIndex, bd.toString());
                        return;
                    }
                }
                throw new SQLException(String.format("Could not convert [%s] to %s", bd, targetSqlType));
            }
            if (obj instanceof byte[]) {
                if (targetSqlType == -2 || targetSqlType == -3 || targetSqlType == -4) {
                    this.setBytes(parameterIndex, (byte[])obj);
                    return;
                }
                throw new SQLException("Can only convert a byte[] to BINARY, VARBINARY, LONGVARBINARY type");
            }
        }
        throw new SQLException(String.format("Type %s not supported type", obj.getClass().getName()));
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw Exceptions.newUnsupportedFeature("Unsupported setAsciiStream(int parameterIndex, InputStream x, long length)");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw Exceptions.newUnsupportedFeature("Unsupported setBinaryStream(int parameterIndex, InputStream x, long length)");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        throw Exceptions.newUnsupportedFeature("Unsupported setCharacterStream(int parameterIndex, Reader reader, long length)");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        throw Exceptions.newUnsupportedFeature("Unsupported setAsciiStream(int parameterIndex, InputStream x)");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        throw Exceptions.newUnsupportedFeature("Unsupported setBinaryStream(int parameterIndex, InputStream x)");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        throw Exceptions.newUnsupportedFeature("Unsupported setCharacterStream(int parameterIndex, Reader reader)");
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        throw Exceptions.newUnsupportedFeature("Unsupported setNCharacterStream(int parameterIndex, Reader value)");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        throw Exceptions.newUnsupportedFeature("Unsupported setClob(int parameterIndex, Reader reader)");
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        throw Exceptions.newUnsupportedFeature("Unsupported setBlob(int parameterIndex, InputStream inputStream)");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        throw Exceptions.newUnsupportedFeature("Unsupported setNClob(int parameterIndex, Reader reader)");
    }

    private void checkIndex(int index) throws SQLException {
        if (index <= 0) {
            throw Exceptions.newSQLException(ErrorCode.ClientError_WrongParameterIndex, index);
        }
    }

    @Override
    public boolean execute() throws SQLException {
        throw Exceptions.newUnsupportedFeature("Unsupported execute()");
    }

    @Override
    public int executeUpdate() throws SQLException {
        throw Exceptions.newUnsupportedFeature("Unsupported executeUpdate()");
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        throw Exceptions.newUnsupportedFeature("executeQuery(String sql) cannot be called on preparedStatement.");
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        throw Exceptions.newUnsupportedFeature("executeQuery(String sql) cannot be called on preparedStatement.");
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        throw Exceptions.newUnsupportedFeature("execute(String sql) cannot be called on preparedStatement.");
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        throw Exceptions.newUnsupportedFeature("addBatch(String sql) cannot be called on preparedStatement.");
    }

    @Override
    public int[] executeBatch() throws SQLException {
        throw Exceptions.newUnsupportedFeature("Unsupported executeBatch()");
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw Exceptions.newUnsupportedFeature("executeUpdate(String sql, int autoGeneratedKeys) cannot be called on preparedStatement.");
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw Exceptions.newUnsupportedFeature("executeUpdate(String sql, int[] columnIndexes) cannot be called on preparedStatement.");
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw Exceptions.newUnsupportedFeature("executeUpdate(String sql, String[] columnNames) cannot be called on preparedStatement.");
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw Exceptions.newUnsupportedFeature("execute(String sql, int autoGeneratedKeys) cannot be called on preparedStatement.");
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw Exceptions.newUnsupportedFeature("execute(String sql, int[] columnIndexes) cannot be called on preparedStatement.");
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw Exceptions.newUnsupportedFeature("execute(String sql, String[] columnNames) cannot be called on preparedStatement.");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this)) {
            return iface.cast(this);
        }
        throw Exceptions.newSQLException(ErrorCode.ClientError_UnwrapFail, iface.getName());
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }
}

