/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.jdbc;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import kd.bos.flydb.jdbc.exception.Exceptions;
import kd.bos.flydb.jdbc.packet.common.DataType;
import kd.bos.flydb.jdbc.packet.server.ColumnDefinitionPacket;

public class FlyDBResultSetMetaData
implements ResultSetMetaData {
    private final ColumnDefinitionPacket[] cdps;

    public FlyDBResultSetMetaData(ColumnDefinitionPacket[] cdps) {
        this.cdps = cdps;
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.cdps.length;
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        return false;
    }

    @Override
    public int isNullable(int column) throws SQLException {
        throw Exceptions.newUnsupportedFeature("Unsupported method isNullable.");
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        return false;
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        throw Exceptions.newUnsupportedFeature("Unsupported method getColumnDisplaySize.");
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return this.getColumnDefinitionPacket(column).getColumnAlias();
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        return this.getColumnDefinitionPacket(column).getName();
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        return this.getColumnDefinitionPacket(column).getSchema();
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        return this.getColumnDefinitionPacket(column).getPrecision();
    }

    @Override
    public int getScale(int column) throws SQLException {
        return this.getColumnDefinitionPacket(column).getScale();
    }

    @Override
    public String getTableName(int column) throws SQLException {
        return this.getColumnDefinitionPacket(column).getTable();
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        return this.getColumnDefinitionPacket(column).getCatalog();
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        return DataType.convertSqlTypes(this.getColumnDefinitionPacket(column).getDataType());
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        return this.getColumnDefinitionPacket(column).getDataType().name();
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return false;
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        return this.getColumnDefinitionPacket(column).getDataType().getJavaTypeClassName();
    }

    private ColumnDefinitionPacket getColumnDefinitionPacket(int column) throws SQLException {
        if (column >= 1 && column <= this.getColumnCount()) {
            return this.cdps[column - 1];
        }
        throw new SQLException(String.format("Wrong column index %s", column));
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this)) {
            return iface.cast(this);
        }
        throw new SQLException("The receiver is not a wrapper for " + iface.getName());
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }
}

