/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.List;
import kd.bos.flydb.jdbc.FlyDBConnection;
import kd.bos.flydb.jdbc.client.result.CompleteResultSet;
import kd.bos.flydb.jdbc.client.result.Result;
import kd.bos.flydb.jdbc.client.transfer.bytebuf.StandardReadableByteBuf;
import kd.bos.flydb.jdbc.exception.ErrorCode;
import kd.bos.flydb.jdbc.exception.Exceptions;
import kd.bos.flydb.jdbc.packet.ServerPacket;
import kd.bos.flydb.jdbc.packet.client.CloseStatementPacket;
import kd.bos.flydb.jdbc.packet.client.QueryPacket;
import kd.bos.flydb.jdbc.packet.server.ColumnDefinitionPacket;

public class FlyDBStatement
implements Statement {
    protected final FlyDBConnection connection;
    protected int fetchSize;
    protected String statementId;
    protected ServerPacket currResult;
    protected List<ServerPacket> results;
    protected int queryTimeout = -1;
    protected boolean closed = false;

    public FlyDBStatement(FlyDBConnection connection, int fetchSize) {
        this.connection = connection;
        this.fetchSize = fetchSize;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        try {
            this.executeInternal(sql);
            this.currResult = this.results.remove(0);
            if (this.currResult instanceof Result) {
                return (Result)this.currResult;
            }
            return new CompleteResultSet(this, new ColumnDefinitionPacket[0], new StandardReadableByteBuf(new byte[0], 0));
        }
        catch (Exception e) {
            throw Exceptions.wrap(e);
        }
    }

    private void executeInternal(String sql) throws SQLException {
        this.checkNotClosed();
        this.results = this.connection.getClient().execute(new QueryPacket(sql, this.fetchSize, this.getQueryTimeout(), this.connection.getConnectionId()), this, this.fetchSize);
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        throw Exceptions.newUnsupportedFeature("Unsupported executeUpdate(String sql)");
    }

    @Override
    public void close() throws SQLException {
        if (!this.closed) {
            this.closed = true;
            if (this.currResult != null && this.currResult instanceof Result) {
                ((Result)this.currResult).close();
            }
            if (this.results != null && !this.results.isEmpty()) {
                for (ServerPacket serverPacket : this.results) {
                    if (!(serverPacket instanceof Result)) continue;
                    ((Result)serverPacket).close();
                }
            }
            if (this.statementId != null) {
                this.connection.getClient().execute(new CloseStatementPacket(this.statementId), this, this.fetchSize);
            }
        }
    }

    public String getStatementId() {
        return this.statementId;
    }

    public void setStatementId(String statementId) {
        this.statementId = statementId;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        throw Exceptions.newUnsupportedFeature("Unsupported getMaxFieldSize().");
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        throw Exceptions.newUnsupportedFeature("Unsupported setMaxFieldSize(int max).");
    }

    @Override
    public int getMaxRows() throws SQLException {
        throw Exceptions.newUnsupportedFeature("Unsupported getMaxRows().");
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        throw Exceptions.newUnsupportedFeature("Unsupported setMaxRows(int max).");
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        throw Exceptions.newUnsupportedFeature("Unsupported setEscapeProcessing(boolean enable).");
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.queryTimeout;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.queryTimeout = seconds;
    }

    @Override
    public void cancel() throws SQLException {
        throw Exceptions.newUnsupportedFeature("Unsupported cancel().");
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        throw Exceptions.newUnsupportedFeature("Unsupported getWarnings().");
    }

    @Override
    public void clearWarnings() throws SQLException {
        throw Exceptions.newUnsupportedFeature("Unsupported clearWarnings().");
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        throw Exceptions.newUnsupportedFeature("Unsupported setCursorName(String name).");
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.executeInternal(sql);
        this.currResult = this.results.remove(0);
        return this.currResult instanceof Result;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.checkNotClosed();
        if (this.currResult instanceof Result) {
            return (Result)this.currResult;
        }
        return null;
    }

    protected void checkNotClosed() throws SQLException {
        if (this.closed) {
            throw Exceptions.newUnsupportedFeature("Not operated by a closed statement.");
        }
    }

    @Override
    public int getUpdateCount() throws SQLException {
        throw Exceptions.newUnsupportedFeature("Unsupported getUpdateCount().");
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.getMoreResults(1);
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        throw Exceptions.newUnsupportedFeature("Unsupported setFetchDirection(int direction).");
    }

    @Override
    public int getFetchDirection() throws SQLException {
        throw Exceptions.newUnsupportedFeature("Unsupported getFetchDirection().");
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.fetchSize = rows;
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        throw Exceptions.newUnsupportedFeature("Unsupported getResultSetConcurrency().");
    }

    @Override
    public int getResultSetType() throws SQLException {
        throw Exceptions.newUnsupportedFeature("Unsupported getResultSetType().");
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        throw Exceptions.newUnsupportedFeature("Unsupported addBatch(String sql).");
    }

    @Override
    public void clearBatch() throws SQLException {
        throw Exceptions.newUnsupportedFeature("Unsupported clearBatch().");
    }

    @Override
    public int[] executeBatch() throws SQLException {
        throw Exceptions.newUnsupportedFeature("Unsupported executeBatch()");
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        this.checkNotClosed();
        if (this.currResult instanceof Result) {
            Result result = (Result)this.currResult;
            if (current == 1) {
                result.close();
            }
            if (result.isFetching() && result.hasMoreResultExists()) {
                return true;
            }
        }
        this.currResult = null;
        return false;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        throw Exceptions.newUnsupportedFeature("Unsupported getGeneratedKeys().");
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw Exceptions.newUnsupportedFeature("Unsupported executeUpdate(String sql, int autoGeneratedKeys).");
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw Exceptions.newUnsupportedFeature("Unsupported executeUpdate(String sql, int[] columnIndexes).");
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw Exceptions.newUnsupportedFeature("Unsupported executeUpdate(String sql, String[] columnNames).");
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw Exceptions.newUnsupportedFeature("Unsupported execute(String sql, int autoGeneratedKeys).");
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw Exceptions.newUnsupportedFeature("Unsupported execute(String sql, int[] columnIndexes).");
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw Exceptions.newUnsupportedFeature("Unsupported execute(String sql, String[] columnNames).");
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        throw Exceptions.newUnsupportedFeature("Unsupported getResultSetHoldability().");
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        throw Exceptions.newUnsupportedFeature("Unsupported setPoolable(boolean poolable).");
    }

    @Override
    public boolean isPoolable() throws SQLException {
        throw Exceptions.newUnsupportedFeature("Unsupported isPoolable().");
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        throw Exceptions.newUnsupportedFeature("Unsupported closeOnCompletion().");
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        throw Exceptions.newUnsupportedFeature("Unsupported isCloseOnCompletion().");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this)) {
            return iface.cast(this);
        }
        throw Exceptions.newSQLException(ErrorCode.ClientError_UnwrapFail, iface.getName());
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }
}

