/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.jdbc.client.impl;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import kd.bos.flydb.jdbc.Configuration;
import kd.bos.flydb.jdbc.FlyDBStatement;
import kd.bos.flydb.jdbc.client.Client;
import kd.bos.flydb.jdbc.client.Context;
import kd.bos.flydb.jdbc.client.bean.SequenceInt;
import kd.bos.flydb.jdbc.client.context.BaseContext;
import kd.bos.flydb.jdbc.client.result.CompleteResultSet;
import kd.bos.flydb.jdbc.client.result.FetchResultSet;
import kd.bos.flydb.jdbc.client.transfer.Channel;
import kd.bos.flydb.jdbc.client.transfer.Reader;
import kd.bos.flydb.jdbc.client.transfer.Writer;
import kd.bos.flydb.jdbc.client.transfer.bytebuf.ReadableByteBuf;
import kd.bos.flydb.jdbc.client.transfer.http.HttpChannel;
import kd.bos.flydb.jdbc.exception.Exceptions;
import kd.bos.flydb.jdbc.exception.ServerSideException;
import kd.bos.flydb.jdbc.packet.ClientPacket;
import kd.bos.flydb.jdbc.packet.ServerPacket;
import kd.bos.flydb.jdbc.packet.client.QuitPacket;
import kd.bos.flydb.jdbc.packet.common.DataType;
import kd.bos.flydb.jdbc.packet.server.ColumnDefinitionPacket;
import kd.bos.flydb.jdbc.packet.server.ErrorResponsePacket;
import kd.bos.flydb.jdbc.packet.server.OkResponsePacket;

public class HttpClient
implements Client {
    private Context context = new BaseContext();
    private Channel channel;
    private boolean isClosed = false;
    private final ReentrantLock lock;

    public HttpClient(Configuration configuration, ReentrantLock lock) throws IOException, ServerSideException {
        this.channel = new HttpChannel(configuration, this.context);
        this.channel.open();
        this.lock = lock;
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ServerPacket> execute(ClientPacket queryPacket, FlyDBStatement flyDBStatement, int fetchSize) throws SQLException {
        this.lock.lock();
        try {
            this.writer(queryPacket);
            List<ServerPacket> list = this.readResponse(flyDBStatement, fetchSize);
            return list;
        }
        catch (Exception e) {
            throw Exceptions.wrap(e);
        }
        finally {
            try {
                if (this.channel != null) {
                    this.channel.close();
                }
            }
            catch (IOException iOException) {
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private List<ServerPacket> readResults(FlyDBStatement flyDBStatement, List<ServerPacket> completes, int fetchSize) throws IOException, ServerSideException {
        try (Reader reader = this.reader();){
            completes.add(this.readPacket(reader, flyDBStatement, fetchSize));
            List<ServerPacket> list = completes;
            return list;
        }
    }

    private Reader reader() throws IOException {
        return this.channel.reader(new SequenceInt());
    }

    private int writer(ClientPacket clientPacket) throws IOException {
        try (Writer writer = this.channel.writer(new SequenceInt());){
            int n = clientPacket.encode(writer, this.context);
            return n;
        }
    }

    private List<ServerPacket> readResponse(FlyDBStatement flyDBStatement, int fetchSize) throws IOException, ServerSideException {
        ArrayList<ServerPacket> completes = new ArrayList<ServerPacket>();
        return this.readResults(flyDBStatement, completes, fetchSize);
    }

    private ServerPacket readPacket(Reader reader, FlyDBStatement flyDBStatement, int fetchSize) throws IOException, ServerSideException {
        ReadableByteBuf readableByteBuf = reader.readPacket(true);
        switch (readableByteBuf.getByte() & 0xFF) {
            case 0: {
                return OkResponsePacket.decode(readableByteBuf);
            }
            case 255: {
                throw Exceptions.newServerSideException(ErrorResponsePacket.decodeWithSkip(readableByteBuf));
            }
        }
        int fieldCount = readableByteBuf.readInt();
        ColumnDefinitionPacket[] cdps = new ColumnDefinitionPacket[fieldCount];
        for (int i = 0; i < fieldCount; ++i) {
            cdps[i] = ColumnDefinitionPacket.builder().sequenceId(readableByteBuf.readInt()).catalog(readableByteBuf.readStringNullEnd()).schema(readableByteBuf.readStringNullEnd()).table(readableByteBuf.readStringNullEnd()).name(readableByteBuf.readStringNullEnd()).columnAlias(readableByteBuf.readStringNullEnd()).serverCharset(readableByteBuf.readByte()).columnLength(readableByteBuf.readLong()).dataType(DataType.of(readableByteBuf.readInt())).build();
        }
        String resultId = null;
        boolean hasMoreResults = false;
        if ((readableByteBuf.readByte() & 0xFF) == 254) {
            readableByteBuf.readInt();
            hasMoreResults = (readableByteBuf.readInt() & 8) > 0;
            flyDBStatement.setStatementId(readableByteBuf.readStringNullEnd());
            resultId = readableByteBuf.readStringNullEnd();
        }
        if (hasMoreResults) {
            return new FetchResultSet(flyDBStatement, cdps, readableByteBuf, resultId, fetchSize);
        }
        return new CompleteResultSet(flyDBStatement, cdps, readableByteBuf);
    }

    @Override
    public void close() throws Exception {
        boolean locked = this.lock.tryLock();
        if (!this.isClosed) {
            this.isClosed = true;
            if (this.channel != null) {
                this.writer(new QuitPacket(this.context.getConnectionId()));
                Reader reader = this.reader();
                reader.close();
                this.channel.close();
                this.channel = null;
            }
        }
        if (locked) {
            this.lock.unlock();
        }
    }
}

