/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.jdbc.client.result;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import kd.bos.flydb.jdbc.FlyDBConnection;
import kd.bos.flydb.jdbc.FlyDBResultSetMetaData;
import kd.bos.flydb.jdbc.FlyDBStatement;
import kd.bos.flydb.jdbc.client.result.Result;
import kd.bos.flydb.jdbc.client.transfer.bytebuf.ReadableByteBuf;
import kd.bos.flydb.jdbc.exception.Exceptions;
import kd.bos.flydb.jdbc.exception.ServerSideException;
import kd.bos.flydb.jdbc.packet.server.ColumnDefinitionPacket;
import kd.bos.flydb.jdbc.packet.server.EofResponsePacket;
import kd.bos.flydb.jdbc.packet.server.ErrorResponsePacket;

public class CompleteResultSet
extends Result {
    List<Object[]> data;
    private boolean loaded;
    private int rowIndex = 0;
    private boolean closed;

    public CompleteResultSet(FlyDBStatement flyDBStatement, ColumnDefinitionPacket[] cdps, ReadableByteBuf readableByteBuf) throws ServerSideException, IOException {
        super(flyDBStatement, cdps, readableByteBuf);
        this.data = new ArrayList<Object[]>();
        while (this.readNext()) {
        }
        this.loaded = true;
    }

    private CompleteResultSet(ColumnDefinitionPacket[] cdps, List<Object[]> data) {
        super(cdps);
        this.data = data;
        this.loaded = true;
    }

    private boolean readNext() throws ServerSideException, IOException {
        switch (this.readableByteBuf.getByte() & 0xFF) {
            case 255: {
                this.loaded = true;
                throw Exceptions.newServerSideException(ErrorResponsePacket.decodeWithSkip(this.readableByteBuf));
            }
            case 254: {
                this.readableByteBuf.skip();
                int serverStatus = new EofResponsePacket(this.readableByteBuf.readInt(), this.readableByteBuf.readInt(), this.readableByteBuf.readStringNullEnd(), this.readableByteBuf.readStringNullEnd()).getStatusFlag();
                try {
                    this.flyDBStatement.getConnection().unwrap(FlyDBConnection.class).getContext().setServerStatus(serverStatus);
                }
                catch (SQLException e) {
                    throw Exceptions.wrapIOException(e);
                }
                this.loaded = true;
                return false;
            }
        }
        Object[] row = new Object[this.cdps.length];
        for (int i = 0; i < row.length; ++i) {
            Integer length = this.readableByteBuf.readLength();
            row[i] = length == null ? null : this.readableByteBuf.readString(length);
        }
        this.data.add(row);
        return true;
    }

    @Override
    public boolean isFetching() {
        return false;
    }

    @Override
    public boolean hasMoreResultExists() {
        return false;
    }

    @Override
    public boolean next() throws SQLException {
        if (this.rowIndex < this.data.size()) {
            this.rowDecoder.setRow(this.data.get(this.rowIndex++));
            return true;
        }
        this.rowIndex = this.data.size();
        this.rowDecoder.setRow(null);
        return false;
    }

    @Override
    public void close() throws SQLException {
        if (!this.loaded) {
            this.skipRemaining();
        }
        this.closed = true;
    }

    public void skipRemaining() throws SQLException {
        block4: while (this.readableByteBuf.readableBytes() > 0) {
            switch (this.readableByteBuf.getByte() & 0xFF) {
                case 255: {
                    this.loaded = true;
                    throw new RuntimeException(ErrorResponsePacket.decodeWithSkip(this.readableByteBuf).getMessage());
                }
                case 254: {
                    this.readableByteBuf.skip();
                    int serverStatus = new EofResponsePacket(this.readableByteBuf.readInt(), this.readableByteBuf.readInt(), this.readableByteBuf.readStringNullEnd(), this.readableByteBuf.readStringNullEnd()).getStatusFlag();
                    this.flyDBStatement.getConnection().unwrap(FlyDBConnection.class).getContext().setServerStatus(serverStatus);
                    this.loaded = true;
                    return;
                }
            }
            int i = 0;
            while (true) {
                if (i >= this.cdps.length) continue block4;
                Integer length = this.readableByteBuf.readLength();
                if (length != null) {
                    this.readableByteBuf.readString(length);
                }
                ++i;
            }
            break;
        }
        return;
    }

    private void checkClose() throws SQLException {
        if (this.closed) {
            throw new SQLException("Operation not permit on a closed resultSet.");
        }
    }

    public static CompleteResultSet createCompleteResultSet(ColumnDefinitionPacket[] columnDefinitionPackets, List<Object[]> data) {
        return new CompleteResultSet(columnDefinitionPackets, data);
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.rowDecoder.wasNull();
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        return this.rowDecoder.getStringValue(columnIndex);
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        return this.rowDecoder.getBooleanValue(columnIndex);
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        throw new SQLException("Unsupported getByte");
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        return this.rowDecoder.getShortValue(columnIndex);
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        return this.rowDecoder.getIntValue(columnIndex);
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        return this.rowDecoder.getLongValue(columnIndex);
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        return this.rowDecoder.getFloatValue(columnIndex);
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        return this.rowDecoder.getDoubleValue(columnIndex);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        return this.rowDecoder.getBigDecimalValue(columnIndex);
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        throw new SQLException("Unsupported getBytes");
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        return this.rowDecoder.getDateValue(columnIndex);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        return this.rowDecoder.getTimeValue(columnIndex);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return this.rowDecoder.getTimestampValue(columnIndex);
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        throw new SQLException("Unsupported getAsciiStream");
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        throw new SQLException("Unsupported getUnicodeStream");
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        throw new SQLException("Unsupported getBinaryStream");
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        Integer columnIndex = (Integer)this.mapper.get(columnLabel);
        if (columnIndex != null) {
            return this.rowDecoder.getStringValue(columnIndex);
        }
        throw new SQLException(String.format("Unknown columnLabel '%s'", columnLabel));
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        Integer columnIndex = (Integer)this.mapper.get(columnLabel);
        if (columnIndex != null) {
            return this.rowDecoder.getBooleanValue(columnIndex);
        }
        throw new SQLException(String.format("Unknown columnLabel '%s'", columnLabel));
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        throw new SQLException("Unsupported getByte");
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        Integer columnIndex = (Integer)this.mapper.get(columnLabel);
        if (columnIndex != null) {
            return this.rowDecoder.getShortValue(columnIndex);
        }
        throw new SQLException(String.format("Unknown columnLabel '%s'", columnLabel));
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        Integer columnIndex = (Integer)this.mapper.get(columnLabel);
        if (columnIndex != null) {
            return this.rowDecoder.getIntValue(columnIndex);
        }
        throw new SQLException(String.format("Unknown columnLabel '%s'", columnLabel));
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        Integer columnIndex = (Integer)this.mapper.get(columnLabel);
        if (columnIndex != null) {
            return this.rowDecoder.getLongValue(columnIndex);
        }
        throw new SQLException(String.format("Unknown columnLabel '%s'", columnLabel));
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        Integer columnIndex = (Integer)this.mapper.get(columnLabel);
        if (columnIndex != null) {
            return this.rowDecoder.getFloatValue(columnIndex);
        }
        throw new SQLException(String.format("Unknown columnLabel '%s'", columnLabel));
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        Integer columnIndex = (Integer)this.mapper.get(columnLabel);
        if (columnIndex != null) {
            return this.rowDecoder.getDoubleValue(columnIndex);
        }
        throw new SQLException(String.format("Unknown columnLabel '%s'", columnLabel));
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        Integer columnIndex = (Integer)this.mapper.get(columnLabel);
        if (columnIndex != null) {
            return this.rowDecoder.getBigDecimalValue(columnIndex);
        }
        throw new SQLException(String.format("Unknown columnLabel '%s'", columnLabel));
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        throw new SQLException("Unsupported getBytes");
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        Integer columnIndex = (Integer)this.mapper.get(columnLabel);
        if (columnIndex != null) {
            return this.rowDecoder.getDateValue(columnIndex);
        }
        throw new SQLException(String.format("Unknown columnLabel '%s'", columnLabel));
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        Integer columnIndex = (Integer)this.mapper.get(columnLabel);
        if (columnIndex != null) {
            return this.rowDecoder.getTimeValue(columnIndex);
        }
        throw new SQLException(String.format("Unknown columnLabel '%s'", columnLabel));
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        Integer columnIndex = (Integer)this.mapper.get(columnLabel);
        if (columnIndex != null) {
            return this.rowDecoder.getTimestampValue(columnIndex);
        }
        throw new SQLException(String.format("Unknown columnLabel '%s'", columnLabel));
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        throw new SQLException("Unsupported getAsciiStream(String columnLabel)");
    }

    @Override
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        throw new SQLException("Unsupported getUnicodeStream(String columnLabel)");
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        throw new SQLException("Unsupported getBinaryStream(String columnLabel)");
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        throw new SQLException("Unsupported getWarnings()");
    }

    @Override
    public void clearWarnings() throws SQLException {
        throw new SQLException("Unsupported clearWarnings()");
    }

    @Override
    public String getCursorName() throws SQLException {
        throw new SQLException("Unsupported getCursorName()");
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return new FlyDBResultSetMetaData(this.cdps);
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        return this.rowDecoder.getValue(columnIndex);
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        Integer columnIndex = (Integer)this.mapper.get(columnLabel);
        if (columnIndex != null) {
            return this.rowDecoder.getValue(columnIndex);
        }
        throw new SQLException(String.format("Unknown columnLabel '%s'", columnLabel));
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        Integer columnIndex = (Integer)this.mapper.get(columnLabel);
        if (columnIndex != null) {
            return (Integer)this.mapper.get(columnLabel);
        }
        throw new SQLException(String.format("Unknown columnLabel '%s'", columnLabel));
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        throw new SQLException("Unsupported getCharacterStream(int columnIndex)");
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        throw new SQLException("Unsupported getCharacterStream(String columnLabel)");
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return this.rowDecoder.getBigDecimalValue(columnIndex);
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        Integer columnIndex = (Integer)this.mapper.get(columnLabel);
        if (columnIndex != null) {
            return this.rowDecoder.getBigDecimalValue(columnIndex);
        }
        throw new SQLException(String.format("Unknown columnLabel '%s'", columnLabel));
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        throw new SQLException("Unsupported isBeforeFirst()");
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        throw new SQLException("Unsupported isAfterLast()");
    }

    @Override
    public boolean isFirst() throws SQLException {
        throw new SQLException("Unsupported isFirst()");
    }

    @Override
    public boolean isLast() throws SQLException {
        throw new SQLException("Unsupported isLast()");
    }

    @Override
    public void beforeFirst() throws SQLException {
        throw new SQLException("Unsupported beforeFirst()");
    }

    @Override
    public void afterLast() throws SQLException {
        throw new SQLException("Unsupported afterLast()");
    }

    @Override
    public boolean first() throws SQLException {
        throw new SQLException("Unsupported first()");
    }

    @Override
    public boolean last() throws SQLException {
        throw new SQLException("Unsupported last()");
    }

    @Override
    public int getRow() throws SQLException {
        throw new SQLException("Unsupported getRow()");
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        throw new SQLException("Unsupported absolute(int row)");
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        throw new SQLException("Unsupported relative(int rows)");
    }

    @Override
    public boolean previous() throws SQLException {
        throw new SQLException("Unsupported previous()");
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.checkClose();
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkClose();
        return 0;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.checkClose();
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkClose();
        return 0;
    }

    @Override
    public int getType() throws SQLException {
        throw new SQLException("Unsupported getType()");
    }

    @Override
    public int getConcurrency() throws SQLException {
        throw new SQLException("Unsupported getConcurrency()");
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        throw new SQLException("Unsupported rowUpdated()");
    }

    @Override
    public boolean rowInserted() throws SQLException {
        throw new SQLException("Unsupported rowInserted()");
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        throw new SQLException("Unsupported rowDeleted()");
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        throw new SQLException("Unsupported updateNull(int columnIndex)");
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        throw new SQLException("Unsupported updateBoolean(int columnIndex, boolean x)");
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        throw new SQLException("Unsupported updateByte(int columnIndex, byte x)");
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        throw new SQLException("Unsupported updateShort(int columnIndex, short x)");
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        throw new SQLException("Unsupported updateInt(int columnIndex, int x)");
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        throw new SQLException("Unsupported updateLong(int columnIndex, long x)");
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        throw new SQLException("Unsupported updateFloat(int columnIndex, float x)");
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        throw new SQLException("Unsupported updateDouble(int columnIndex, double x)");
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        throw new SQLException("Unsupported updateBigDecimal(int columnIndex, BigDecimal x)");
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        throw new SQLException("Unsupported updateString(int columnIndex, String x)");
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        throw new SQLException("Unsupported updateBytes(int columnIndex, byte[] x)");
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        throw new SQLException("Unsupported updateDate(int columnIndex, Date x)");
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        throw new SQLException("Unsupported updateTime(int columnIndex, Time x)");
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        throw new SQLException("Unsupported updateTimestamp(int columnIndex, Timestamp x)");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new SQLException("Unsupported updateAsciiStream(int columnIndex, InputStream x, int length)");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new SQLException("Unsupported updateBinaryStream(int columnIndex, InputStream x, int length)");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        throw new SQLException("Unsupported updateCharacterStream(int columnIndex, Reader x, int length)");
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scaleOrLength) throws SQLException {
        throw new SQLException("Unsupported updateObject(int columnIndex, Object x, int scaleOrLength)");
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        throw new SQLException("Unsupported updateObject(int columnIndex, Object x)");
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        throw new SQLException("Unsupported updateNull(String columnLabel)");
    }

    @Override
    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
        throw new SQLException("Unsupported updateBoolean(String columnLabel, boolean x)");
    }

    @Override
    public void updateByte(String columnLabel, byte x) throws SQLException {
        throw new SQLException("Unsupported updateByte(String columnLabel, byte x)");
    }

    @Override
    public void updateShort(String columnLabel, short x) throws SQLException {
        throw new SQLException("Unsupported updateShort(String columnLabel, short x)");
    }

    @Override
    public void updateInt(String columnLabel, int x) throws SQLException {
        throw new SQLException("Unsupported updateInt(String columnLabel, int x)");
    }

    @Override
    public void updateLong(String columnLabel, long x) throws SQLException {
        throw new SQLException("Unsupported updateLong(String columnLabel, long x)");
    }

    @Override
    public void updateFloat(String columnLabel, float x) throws SQLException {
        throw new SQLException("Unsupported updateFloat(String columnLabel, float x)");
    }

    @Override
    public void updateDouble(String columnLabel, double x) throws SQLException {
        throw new SQLException("Unsupported updateDouble(String columnLabel, double x)");
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
        throw new SQLException("Unsupported updateBigDecimal(String columnLabel, BigDecimal x)");
    }

    @Override
    public void updateString(String columnLabel, String x) throws SQLException {
        throw new SQLException("Unsupported updateString(String columnLabel, String x)");
    }

    @Override
    public void updateBytes(String columnLabel, byte[] x) throws SQLException {
        throw new SQLException("Unsupported updateBytes(String columnLabel, byte[] x)");
    }

    @Override
    public void updateDate(String columnLabel, Date x) throws SQLException {
        throw new SQLException("Unsupported updateDate(String columnLabel, Date x)");
    }

    @Override
    public void updateTime(String columnLabel, Time x) throws SQLException {
        throw new SQLException("Unsupported updateTime(String columnLabel, Time x)");
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        throw new SQLException("Unsupported updateTimestamp(String columnLabel, Timestamp x)");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
        throw new SQLException("Unsupported updateAsciiStream(String columnLabel, InputStream x, int length)");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
        throw new SQLException("Unsupported updateBinaryStream(String columnLabel, InputStream x, int length)");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {
        throw new SQLException("Unsupported updateCharacterStream(String columnLabel, Reader reader, int length)");
    }

    @Override
    public void updateObject(String columnLabel, Object x, int scaleOrLength) throws SQLException {
        throw new SQLException("Unsupported updateObject(String columnLabel, Object x, int scaleOrLength)");
    }

    @Override
    public void updateObject(String columnLabel, Object x) throws SQLException {
        throw new SQLException("Unsupported updateObject(String columnLabel, Object x)");
    }

    @Override
    public void insertRow() throws SQLException {
        throw new SQLException("Unsupported insertRow()");
    }

    @Override
    public void updateRow() throws SQLException {
        throw new SQLException("Unsupported updateRow()");
    }

    @Override
    public void deleteRow() throws SQLException {
        throw new SQLException("Unsupported deleteRow()");
    }

    @Override
    public void refreshRow() throws SQLException {
        throw new SQLException("Unsupported refreshRow()");
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw new SQLException("Unsupported cancelRowUpdates()");
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw new SQLException("Unsupported moveToInsertRow()");
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        throw new SQLException("Unsupported moveToCurrentRow()");
    }

    @Override
    public Statement getStatement() throws SQLException {
        return this.flyDBStatement;
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        if (map == null || map.isEmpty()) {
            return this.getObject(columnIndex);
        }
        throw new SQLException("Method ResultSet.getObject(int columnIndex, Map<String, Class<?>> map) not supported for non empty map");
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        throw new SQLException("Unsupported getRef(int columnIndex)");
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        throw new SQLException("Unsupported getBlob(int columnIndex)");
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        throw new SQLException("Unsupported getClob(int columnIndex)");
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        throw new SQLException("Unsupported getArray(int columnIndex)");
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        if (map == null || map.isEmpty()) {
            return this.getObject(columnLabel);
        }
        throw new SQLException("Method ResultSet.getObject(String columnLabel, Map<String, Class<?>> map) not supported");
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        throw new SQLException("Unsupported getRef(String columnLabel)");
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        throw new SQLException("Unsupported getBlob(String columnLabel)");
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        throw new SQLException("Unsupported getClob(String columnLabel)");
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        throw new SQLException("Unsupported getArray(String columnLabel)");
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        throw new SQLException("Unsupported getDate(int columnIndex, Calendar cal)");
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        throw new SQLException("Unsupported getDate(String columnLabel, Calendar cal)");
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        throw new SQLException("Unsupported getTime(int columnIndex, Calendar cal)");
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        throw new SQLException("Unsupported getTime(String columnLabel, Calendar cal)");
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        throw new SQLException("Unsupported getTimestamp(int columnIndex, Calendar cal)");
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        throw new SQLException("Unsupported getTimestamp(String columnLabel, Calendar cal)");
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        Object s = this.rowDecoder.getValue(columnIndex);
        if (s == null) {
            return null;
        }
        try {
            return new URL(s.toString());
        }
        catch (MalformedURLException e) {
            throw new SQLException(String.format("Could not parse '%s' as URL", s), e);
        }
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        Integer columnIndex = (Integer)this.mapper.get(columnLabel);
        if (columnIndex == null) {
            throw new SQLException(String.format("Unknown columnLabel '%s'", columnLabel));
        }
        Object s = this.rowDecoder.getValue(columnIndex);
        if (s == null) {
            return null;
        }
        try {
            return new URL(s.toString());
        }
        catch (MalformedURLException e) {
            throw new SQLException(String.format("Could not parse '%s' as URL", s), e);
        }
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw new SQLException("Unsupported updateRef(int columnIndex, Ref x)");
    }

    @Override
    public void updateRef(String columnLabel, Ref x) throws SQLException {
        throw new SQLException("Unsupported updateRef(String columnLabel, Ref x)");
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        throw new SQLException("Unsupported updateBlob(int columnIndex, Blob x)");
    }

    @Override
    public void updateBlob(String columnLabel, Blob x) throws SQLException {
        throw new SQLException("Unsupported updateBlob(String columnLabel, Blob x)");
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        throw new SQLException("Unsupported updateClob(int columnIndex, Clob x)");
    }

    @Override
    public void updateClob(String columnLabel, Clob x) throws SQLException {
        throw new SQLException("Unsupported updateClob(String columnLabel, Clob x)");
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        throw new SQLException("Unsupported updateArray(int columnIndex, Array x)");
    }

    @Override
    public void updateArray(String columnLabel, Array x) throws SQLException {
        throw new SQLException("Unsupported updateArray(String columnLabel, Array x)");
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        throw new SQLException("Unsupported getRowId(int columnIndex)");
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        throw new SQLException("Unsupported getRowId(String columnLabel)");
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        throw new SQLException("Unsupported updateRowId(int columnIndex, RowId x)");
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        throw new SQLException("Unsupported updateRowId(String columnLabel, RowId x)");
    }

    @Override
    public int getHoldability() throws SQLException {
        throw new SQLException("Unsupported getHoldability()");
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        throw new SQLException("Unsupported updateNString(int columnIndex, String nString)");
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        throw new SQLException("Unsupported updateNString(String columnLabel, String nString)");
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        throw new SQLException("Unsupported updateNClob(int columnIndex, NClob nClob)");
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        throw new SQLException("Unsupported updateNClob(String columnLabel, NClob nClob)");
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        throw new SQLException("Unsupported getNClob(int columnIndex)");
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        throw new SQLException("Unsupported getNClob(String columnLabel)");
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        throw new SQLException("Unsupported getSQLXML(int columnIndex)");
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        throw new SQLException("Unsupported getSQLXML(String columnLabel)");
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        throw new SQLException("Unsupported updateSQLXML(int columnIndex, SQLXML xmlObject)");
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        throw new SQLException("Unsupported updateSQLXML(String columnLabel, SQLXML xmlObject)");
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        return this.getString(columnIndex);
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        return this.getString(columnLabel);
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        throw new SQLException("Unsupported getNCharacterStream(int columnIndex)");
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        throw new SQLException("Unsupported getNCharacterStream(String columnLabel)");
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new SQLException("Unsupported updateNCharacterStream(int columnIndex, Reader x, long length)");
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new SQLException("Unsupported updateNCharacterStream(String columnLabel, Reader reader, long length)");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw new SQLException("Unsupported updateAsciiStream(int columnIndex, InputStream x, long length)");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw new SQLException("Unsupported updateBinaryStream(int columnIndex, InputStream x, long length)");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new SQLException("Unsupported updateCharacterStream(int columnIndex, Reader x, long length)");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw new SQLException("Unsupported updateAsciiStream(String columnLabel, InputStream x, long length)");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw new SQLException("Unsupported updateBinaryStream(String columnLabel, InputStream x, long length)");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new SQLException("Unsupported updateCharacterStream(String columnLabel, Reader reader, long length)");
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        throw new SQLException("Unsupported updateBlob(int columnIndex, InputStream inputStream, long length)");
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        throw new SQLException("Unsupported updateBlob(String columnLabel, InputStream inputStream, long length)");
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new SQLException("Unsupported updateClob(int columnIndex, Reader reader, long length)");
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new SQLException("Unsupported updateClob(String columnLabel, Reader reader, long length)");
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new SQLException("Unsupported updateNClob(int columnIndex, Reader reader, long length)");
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new SQLException("Unsupported updateNClob(String columnLabel, Reader reader, long length)");
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new SQLException("Unsupported updateNCharacterStream(int columnIndex, Reader x)");
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new SQLException("Unsupported updateNCharacterStream(String columnLabel, Reader reader)");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        throw new SQLException("Unsupported updateAsciiStream(int columnIndex, InputStream x)");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        throw new SQLException("Unsupported updateBinaryStream(int columnIndex, InputStream x)");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new SQLException("Unsupported updateCharacterStream(int columnIndex, Reader x)");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        throw new SQLException("Unsupported updateAsciiStream(String columnLabel, InputStream x)");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        throw new SQLException("Unsupported updateBinaryStream(String columnLabel, InputStream x)");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new SQLException("Unsupported updateCharacterStream(String columnLabel, Reader reader)");
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        throw new SQLException("Unsupported updateBlob(int columnIndex, InputStream inputStream)");
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        throw new SQLException("Unsupported updateBlob(String columnLabel, InputStream inputStream)");
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        throw new SQLException("Unsupported updateClob(int columnIndex, Reader reader)");
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        throw new SQLException("Unsupported updateClob(String columnLabel, Reader reader)");
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        throw new SQLException("Unsupported updateNClob(int columnIndex, Reader reader)");
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        throw new SQLException("Unsupported updateNClob(String columnLabel, Reader reader)");
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        throw new SQLException("Unsupported getObject(int columnIndex, Class<T> type)");
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        throw new SQLException("Unsupported getObject(String columnLabel, Class<T> type)");
    }

    @Override
    public void updateObject(int columnIndex, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        throw new SQLException("Unsupported updateObject(int columnIndex, Object x, SQLType targetSqlType, int scaleOrLength)");
    }

    @Override
    public void updateObject(String columnLabel, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        throw new SQLException("Unsupported updateObject(String columnLabel, Object x, SQLType targetSqlType, int scaleOrLength)");
    }

    @Override
    public void updateObject(int columnIndex, Object x, SQLType targetSqlType) throws SQLException {
        throw new SQLException("Unsupported updateObject(int columnIndex, Object x, SQLType targetSqlType)");
    }

    @Override
    public void updateObject(String columnLabel, Object x, SQLType targetSqlType) throws SQLException {
        throw new SQLException("Unsupported updateObject(String columnLabel, Object x, SQLType targetSqlType)");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this)) {
            return iface.cast(this);
        }
        throw new SQLException("Wrapped statement is not an instance of " + iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    @Override
    public int getSequenceId() {
        return 0;
    }
}

