/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.jdbc.client.result;

import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Map;
import kd.bos.flydb.jdbc.FlyDBStatement;
import kd.bos.flydb.jdbc.client.result.RowDecoder;
import kd.bos.flydb.jdbc.client.transfer.bytebuf.ReadableByteBuf;
import kd.bos.flydb.jdbc.packet.ServerPacket;
import kd.bos.flydb.jdbc.packet.server.ColumnDefinitionPacket;

public abstract class Result
implements ResultSet,
ServerPacket {
    protected final ColumnDefinitionPacket[] cdps;
    protected final ReadableByteBuf readableByteBuf;
    protected final RowDecoder rowDecoder;
    protected FlyDBStatement flyDBStatement;
    protected Map<String, Integer> mapper = new HashMap<String, Integer>();

    public Result(FlyDBStatement flyDBStatement, ColumnDefinitionPacket[] cdps, ReadableByteBuf readableByteBuf) {
        this.flyDBStatement = flyDBStatement;
        this.cdps = cdps;
        this.readableByteBuf = readableByteBuf;
        this.rowDecoder = new RowDecoder(cdps);
        this.initMapper();
    }

    protected Result(ColumnDefinitionPacket[] cdps) {
        this.flyDBStatement = null;
        this.readableByteBuf = null;
        this.cdps = cdps;
        this.rowDecoder = new RowDecoder(cdps);
    }

    private void initMapper() {
        if (this.cdps != null) {
            for (int i = 0; i < this.cdps.length; ++i) {
                ColumnDefinitionPacket cdp = this.cdps[i];
                this.mapper.put(cdp.getName(), i + 1);
                this.mapper.put(cdp.getColumnAlias(), i + 1);
            }
        }
    }

    public abstract boolean isFetching();

    public abstract boolean hasMoreResultExists();
}

