/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.jdbc.client.result;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Objects;
import kd.bos.flydb.jdbc.packet.common.DataType;
import kd.bos.flydb.jdbc.packet.server.ColumnDefinitionPacket;
import kd.bos.flydb.jdbc.util.DateFormatUtil;

public class RowDecoder {
    private final ColumnDefinitionPacket[] cdps;
    private final int columnCount;
    private Object[] row;
    private int columnIdx;

    public RowDecoder(ColumnDefinitionPacket[] cdps) {
        this.cdps = cdps;
        this.columnCount = cdps.length;
    }

    public void setRow(Object[] row) {
        this.row = row;
        this.columnIdx = -1;
    }

    private void checkIndexAndSetPos(int index) throws SQLException {
        if (index < 1 || index > this.columnCount) {
            throw new SQLException(String.format("Wrong index position. Is %s but must be in 1-%s range", index, this.columnCount));
        }
        if (this.row == null) {
            throw new SQLDataException("wrong row position", "22023");
        }
        this.setPosition(index - 1);
    }

    private void setPosition(int newIndex) {
        this.columnIdx = newIndex;
    }

    public boolean wasNull() {
        return Objects.isNull(this.row[this.columnIdx]);
    }

    public String getStringValue(int columnIndex) throws SQLException {
        this.checkIndexAndSetPos(columnIndex);
        ColumnDefinitionPacket column = this.cdps[this.columnIdx];
        if (column.getDataType() == DataType.VARCHAR) {
            return this.row[this.columnIdx] == null ? null : String.valueOf(this.row[this.columnIdx]);
        }
        throw new SQLException(column.getDataType().name() + " cannot be cast to String.");
    }

    public boolean getBooleanValue(int columnIndex) throws SQLException {
        this.checkIndexAndSetPos(columnIndex);
        ColumnDefinitionPacket column = this.cdps[this.columnIdx];
        if (column.getDataType() == DataType.BOOLEAN) {
            return this.row[this.columnIdx] == null ? false : Boolean.parseBoolean(String.valueOf(this.row[this.columnIdx]));
        }
        if (column.getDataType() == DataType.VARCHAR) {
            return this.row[this.columnIdx] == null ? false : ("0".equals(String.valueOf(this.row[this.columnIdx])) ? false : ("1".equals(String.valueOf(this.row[this.columnIdx])) ? true : Boolean.parseBoolean(String.valueOf(this.row[this.columnIdx]))));
        }
        throw new SQLException(column.getDataType().name() + " cannot be cast to Boolean.");
    }

    public short getShortValue(int columnIndex) throws SQLException {
        this.checkIndexAndSetPos(columnIndex);
        ColumnDefinitionPacket column = this.cdps[this.columnIdx];
        if (column.getDataType() == DataType.INTEGER) {
            return this.row[this.columnIdx] == null ? (short)0 : Short.parseShort(String.valueOf(this.row[this.columnIdx]));
        }
        throw new SQLException(column.getDataType().name() + " cannot be cast to Short.");
    }

    public int getIntValue(int columnIndex) throws SQLException {
        this.checkIndexAndSetPos(columnIndex);
        ColumnDefinitionPacket column = this.cdps[this.columnIdx];
        if (column.getDataType() == DataType.INTEGER) {
            return this.row[this.columnIdx] == null ? 0 : Integer.parseInt(String.valueOf(this.row[this.columnIdx]));
        }
        throw new SQLException(column.getDataType().name() + " cannot be cast to Int.");
    }

    public long getLongValue(int columnIndex) throws SQLException {
        this.checkIndexAndSetPos(columnIndex);
        ColumnDefinitionPacket column = this.cdps[this.columnIdx];
        if (column.getDataType() == DataType.BIGINT) {
            return this.row[this.columnIdx] == null ? 0L : Long.parseLong(String.valueOf(this.row[this.columnIdx]));
        }
        throw new SQLException(column.getDataType().name() + " cannot be cast to Long.");
    }

    public float getFloatValue(int columnIndex) throws SQLException {
        this.checkIndexAndSetPos(columnIndex);
        ColumnDefinitionPacket column = this.cdps[this.columnIdx];
        if (column.getDataType() == DataType.DOUBLE) {
            return this.row[this.columnIdx] == null ? 0.0f : new BigDecimal(String.valueOf(this.row[this.columnIdx])).floatValue();
        }
        throw new SQLException(column.getDataType().name() + " cannot be cast to Float.");
    }

    public double getDoubleValue(int columnIndex) throws SQLException {
        this.checkIndexAndSetPos(columnIndex);
        ColumnDefinitionPacket column = this.cdps[this.columnIdx];
        if (column.getDataType() == DataType.DOUBLE) {
            return this.row[this.columnIdx] == null ? 0.0 : new BigDecimal(String.valueOf(this.row[this.columnIdx])).doubleValue();
        }
        throw new SQLException(column.getDataType().name() + " cannot be cast to Double.");
    }

    public BigDecimal getBigDecimalValue(int columnIndex) throws SQLException {
        this.checkIndexAndSetPos(columnIndex);
        ColumnDefinitionPacket column = this.cdps[this.columnIdx];
        DataType dataType = column.getDataType();
        if (dataType == DataType.DECIMAL || dataType == DataType.INTEGER || dataType == DataType.BIGINT || dataType == DataType.DOUBLE) {
            return this.row[this.columnIdx] == null ? null : new BigDecimal(String.valueOf(this.row[this.columnIdx]));
        }
        throw new SQLException(column.getDataType().name() + " cannot be cast to BigDecimal.");
    }

    public Date getDateValue(int columnIndex) throws SQLException {
        this.checkIndexAndSetPos(columnIndex);
        ColumnDefinitionPacket column = this.cdps[this.columnIdx];
        if (column.getDataType() == DataType.DATE || column.getDataType() == DataType.DATETIME) {
            try {
                return this.row[this.columnIdx] == null ? null : new Date(DateFormatUtil.getDateFormat("yyyy-MM-dd").parse(String.valueOf(this.row[this.columnIdx])).getTime());
            }
            catch (ParseException e) {
                throw new SQLException(this.row[this.columnIdx] + " parse to date error:" + e.getMessage(), e);
            }
        }
        throw new SQLException(column.getDataType().name() + " cannot be cast to Date.");
    }

    public Time getTimeValue(int columnIndex) throws SQLException {
        this.checkIndexAndSetPos(columnIndex);
        ColumnDefinitionPacket column = this.cdps[this.columnIdx];
        if (column.getDataType() == DataType.TIME || column.getDataType() == DataType.DATETIME) {
            try {
                return this.row[this.columnIdx] == null ? null : new Time(DateFormatUtil.getDateFormat("HH:mm:ss").parse(String.valueOf(this.row[this.columnIdx])).getTime());
            }
            catch (ParseException e) {
                throw new SQLException(this.row[this.columnIdx] + " parse to time error:" + e.getMessage(), e);
            }
        }
        throw new SQLException(column.getDataType().name() + " cannot be cast to TIME.");
    }

    public Timestamp getTimestampValue(int columnIndex) throws SQLException {
        this.checkIndexAndSetPos(columnIndex);
        ColumnDefinitionPacket column = this.cdps[this.columnIdx];
        if (column.getDataType() == DataType.DATETIME) {
            try {
                return this.row[this.columnIdx] == null ? null : new Timestamp(DateFormatUtil.getDateFormat("yyyy-MM-dd HH:mm:ss.SSS").parse(String.valueOf(this.row[this.columnIdx])).getTime());
            }
            catch (ParseException e) {
                throw new SQLException(this.row[this.columnIdx] + " parse to timestamp error:" + e.getMessage(), e);
            }
        }
        throw new SQLException(column.getDataType().name() + " cannot be cast to Timestamp.");
    }

    public Object getValue(int columnIndex) throws SQLException {
        this.checkIndexAndSetPos(columnIndex);
        ColumnDefinitionPacket column = this.cdps[this.columnIdx];
        switch (column.getDataType()) {
            case BIGINT: {
                return this.getLongValue(columnIndex);
            }
            case BOOLEAN: {
                return this.getBooleanValue(columnIndex);
            }
            case DECIMAL: {
                return this.getBigDecimalValue(columnIndex);
            }
            case DOUBLE: {
                return this.getDoubleValue(columnIndex);
            }
            case DATE: {
                return this.getDateValue(columnIndex);
            }
            case DATETIME: {
                return this.getTimestampValue(columnIndex);
            }
            case TIME: {
                return this.getTimeValue(columnIndex);
            }
            case INTEGER: {
                return this.getIntValue(columnIndex);
            }
            case NULL: {
                return null;
            }
            case VARCHAR: {
                return this.getStringValue(columnIndex);
            }
        }
        throw new SQLException("Unsupported dataType:" + column.getDataType().name());
    }
}

