/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.jdbc.client.transfer.http;

import java.io.IOException;
import java.io.OutputStream;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.flydb.jdbc.Configuration;
import kd.bos.flydb.jdbc.client.Context;
import kd.bos.flydb.jdbc.client.bean.SequenceInt;
import kd.bos.flydb.jdbc.client.context.BaseContext;
import kd.bos.flydb.jdbc.client.transfer.Channel;
import kd.bos.flydb.jdbc.client.transfer.Reader;
import kd.bos.flydb.jdbc.client.transfer.Writer;
import kd.bos.flydb.jdbc.client.transfer.bytebuf.ReadableByteBuf;
import kd.bos.flydb.jdbc.client.transfer.http.HttpPacketReader;
import kd.bos.flydb.jdbc.client.transfer.http.HttpPacketWriter;
import kd.bos.flydb.jdbc.exception.ErrorCode;
import kd.bos.flydb.jdbc.exception.Exceptions;
import kd.bos.flydb.jdbc.exception.ServerSideException;
import kd.bos.flydb.jdbc.packet.ClientPacket;
import kd.bos.flydb.jdbc.packet.client.ClientSendHandShakePacket;
import kd.bos.flydb.jdbc.packet.client.HandShakeResponsePacket;
import kd.bos.flydb.jdbc.packet.common.ServerCharset;
import kd.bos.flydb.jdbc.packet.server.ErrorResponsePacket;
import kd.bos.flydb.jdbc.packet.server.HandShakeAckPacket;
import kd.bos.flydb.jdbc.packet.server.LoginResponsePacket;

public class HttpChannel
implements Channel {
    private final Configuration configuration;
    private OutputStream outputStream;
    private HttpURLConnection connection;
    private CookieManager cookieManager;
    private String csrf;
    private Context context;
    private String accountId;
    private final AtomicBoolean isLogin = new AtomicBoolean(false);
    private final URI domainURI;

    public HttpChannel(Configuration configuration, Context context) throws IOException {
        this.configuration = configuration;
        this.context = context;
        this.cookieManager = new CookieManager();
        this.cookieManager.setCookiePolicy(CookiePolicy.ACCEPT_ORIGINAL_SERVER);
        try {
            this.domainURI = new URI(configuration.getDomainUrl());
        }
        catch (URISyntaxException e) {
            throw new IOException("Client save cookie fail, " + e.getMessage());
        }
    }

    @Override
    public void open() throws IOException, ServerSideException {
        ReadableByteBuf handShakeAckBuf = this.send(new ClientSendHandShakePacket());
        if (handShakeAckBuf.getByte() == -1) {
            throw new RuntimeException(ErrorResponsePacket.decodeWithSkip(handShakeAckBuf).getMessage());
        }
        HandShakeAckPacket handShakeAck = HandShakeAckPacket.decode(handShakeAckBuf);
        byte exchangeCharset = this.decideLanguage(handShakeAck);
        this.context = this.initContext(this.context, this.configuration, handShakeAck);
        ReadableByteBuf handShakeResponseBuf = this.send(new HandShakeResponsePacket(this.configuration.getUser(), this.configuration.getPassword(), this.configuration.getAccount(), this.configuration.getDatabase(), this.configuration.getSchema(), exchangeCharset, handShakeAck.getSalt(), handShakeAck.getSequenceId()));
        this.csrf = this.connection.getHeaderField("kd-csrf-token");
        byte responseCode = handShakeResponseBuf.readByte();
        switch (responseCode & 0xFF) {
            case 1: {
                LoginResponsePacket okResponsePacket = LoginResponsePacket.decode(handShakeResponseBuf);
                this.context.setServerStatus(okResponsePacket.getServerStatus());
                ((BaseContext)this.context).setConnectionId(okResponsePacket.getConnectionId());
                this.accountId = okResponsePacket.getAccountId();
                this.handleSetCookies(this.connection);
                this.isLogin.set(true);
                break;
            }
            case 255: {
                throw Exceptions.newServerSideException(ErrorResponsePacket.decode(handShakeResponseBuf));
            }
        }
    }

    private Context initContext(Context context, Configuration configuration, HandShakeAckPacket handShakeAck) {
        context.setServerStatus(handShakeAck.getServerStatus());
        ((BaseContext)context).setConfiguration(configuration);
        ((BaseContext)context).setServerVersion(handShakeAck.getServerVersion());
        ((BaseContext)context).setSalt(handShakeAck.getSalt());
        ((BaseContext)context).setCharset(ServerCharset.getCharsetById(handShakeAck.getCharsetId()));
        return context;
    }

    private byte decideLanguage(HandShakeAckPacket handShakeAck) {
        return handShakeAck.getCharsetId();
    }

    private ReadableByteBuf send(ClientPacket clientPacket) throws IOException {
        try (Writer writer = this.writer(new SequenceInt());){
            clientPacket.encode(writer, this.context);
        }
        var3_3 = null;
        try (Reader reader = this.reader(new SequenceInt());){
            ReadableByteBuf readableByteBuf = reader.readPacket(true);
            return readableByteBuf;
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
    }

    private void handleSetCookies(HttpURLConnection connection) throws IOException {
        this.cookieManager.put(this.domainURI, connection.getHeaderFields());
    }

    private String getCookieValue() throws IOException {
        if (this.cookieManager == null) {
            return null;
        }
        Map<String, List<String>> cookieMap = this.cookieManager.get(this.domainURI, new HashMap<String, List<String>>());
        List<String> cookies = cookieMap.get("Cookie");
        return String.join((CharSequence)";", cookies);
    }

    @Override
    public Reader reader(SequenceInt sequenceInt) throws IOException {
        if (200 == this.connection.getResponseCode()) {
            this.handleSetCookies(this.connection);
            return new HttpPacketReader(this.connection.getInputStream(), sequenceInt);
        }
        throw Exceptions.newIOException(ErrorCode.ClientError_ServerUnavailable, new Object[0]);
    }

    @Override
    public Writer writer(SequenceInt sequenceInt) throws IOException {
        this.newIO();
        return new HttpPacketWriter(this.outputStream, sequenceInt, this.configuration.getMaxAllowedPacket());
    }

    @Override
    public void close() throws IOException {
        this.connection.disconnect();
        if (this.outputStream != null) {
            this.outputStream.close();
        }
    }

    private void newIO() throws IOException {
        if (this.isLogin.get()) {
            URL url = new URL(this.configuration.getDomainUrl() + "/flyweb/handlePacket.do");
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Cookie", this.getCookieValue());
            connection.setRequestProperty("kd-transfer-encoding", "original");
            connection.setRequestProperty("Content-Type", "application/octet-stream");
            connection.setRequestProperty("accountId", this.accountId);
            connection.setDoInput(true);
            connection.setDoOutput(true);
            connection.setConnectTimeout(this.configuration.getConnectTimeout());
            this.connection = connection;
        } else {
            URL url = new URL(this.configuration.getDomainUrl() + "/flyweb/authorize.do");
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("kd-transfer-encoding", "original");
            connection.setRequestProperty("Content-Type", "application/octet-stream");
            connection.setDoInput(true);
            connection.setDoOutput(true);
            connection.setConnectTimeout(this.configuration.getConnectTimeout());
            this.connection = connection;
        }
        if (this.csrf != null) {
            this.connection.setRequestProperty("kd-csrf-token", this.csrf);
        }
        this.outputStream = this.connection.getOutputStream();
    }
}

