/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.jdbc.client.transfer.http;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import kd.bos.flydb.jdbc.client.bean.SequenceInt;
import kd.bos.flydb.jdbc.client.transfer.Reader;
import kd.bos.flydb.jdbc.client.transfer.bytebuf.ReadableByteBuf;
import kd.bos.flydb.jdbc.client.transfer.bytebuf.StandardReadableByteBuf;

public class HttpPacketReader
implements Reader {
    private static final int REUSABLE_BUFFER_LENGTH = 1024;
    private static final Integer MAX_PACKET_SIZE = 0xFFFFFF;
    private final byte[] header = new byte[4];
    private final byte[] reusableArray = new byte[1024];
    private final InputStream inputStream;
    private final SequenceInt sequenceInt;

    public HttpPacketReader(InputStream inputStream, SequenceInt sequenceInt) {
        this.inputStream = inputStream;
        this.sequenceInt = sequenceInt;
    }

    @Override
    public ReadableByteBuf readPacket(boolean reUsable) throws IOException {
        int count;
        int count2;
        int streamBytesLen = this.inputStream.available();
        int remaining = 4;
        int off = 0;
        do {
            if ((count2 = this.inputStream.read(this.header, off, remaining)) < 0) {
                throw new EOFException("unexpected end of stream, read " + off + " bytes from 4 (socket was closed by server)");
            }
            off += count2;
        } while ((remaining -= count2) > 0);
        int lastPacketLength = (this.header[0] & 0xFF) + ((this.header[1] & 0xFF) << 8) + ((this.header[2] & 0xFF) << 16);
        this.sequenceInt.set(this.header[3]);
        byte[] rawBytes = reUsable && lastPacketLength < 1024 ? this.reusableArray : new byte[lastPacketLength];
        remaining = lastPacketLength;
        off = 0;
        do {
            if ((count = this.inputStream.read(rawBytes, off, remaining)) < 0) {
                throw new EOFException(String.format("unexpected end of stream, read %s bytes from %s (socket was closed by server), maybe the flydb proxy did not deploy or handle packet incorrectly,\nmessage : {%s}", lastPacketLength - remaining, lastPacketLength, this.unexpectedMsg(rawBytes, streamBytesLen)));
            }
            off += count;
        } while ((remaining -= count) > 0);
        if (lastPacketLength == MAX_PACKET_SIZE) {
            int packetLength;
            do {
                int count3;
                int count4;
                remaining = 4;
                off = 0;
                do {
                    if ((count4 = this.inputStream.read(this.header, off, remaining)) < 0) {
                        throw new EOFException("unexpected end of stream, read " + off + " bytes from 4");
                    }
                    off += count4;
                } while ((remaining -= count4) > 0);
                packetLength = (this.header[0] & 0xFF) + ((this.header[1] & 0xFF) << 8) + ((this.header[2] & 0xFF) << 16);
                this.sequenceInt.set(this.header[3]);
                int currentbufLength = rawBytes.length;
                byte[] newRawBytes = currentbufLength < lastPacketLength ? new byte[currentbufLength + packetLength] : new byte[currentbufLength];
                System.arraycopy(rawBytes, 0, newRawBytes, 0, currentbufLength);
                rawBytes = newRawBytes;
                remaining = packetLength;
                off = reUsable ? lastPacketLength : currentbufLength;
                do {
                    if ((count3 = this.inputStream.read(rawBytes, off, remaining)) < 0) {
                        throw new EOFException("unexpected end of stream, read " + (packetLength - remaining) + " bytes from " + packetLength);
                    }
                    off += count3;
                } while ((remaining -= count3) > 0);
                lastPacketLength += packetLength;
            } while (packetLength == MAX_PACKET_SIZE);
        }
        return new StandardReadableByteBuf(rawBytes, lastPacketLength);
    }

    private String unexpectedMsg(byte[] rawBytes, int streamBytesLen) {
        return new String(Arrays.copyOf(rawBytes, streamBytesLen));
    }

    public SequenceInt getSequenceInt() {
        return this.sequenceInt;
    }

    @Override
    public void close() throws IOException {
        if (this.inputStream != null) {
            this.inputStream.close();
        }
    }
}

