/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.jdbc.exception;

import java.net.ConnectException;
import java.text.MessageFormat;
import kd.bos.flydb.jdbc.exception.ErrorCode;
import kd.bos.flydb.jdbc.exception.IOException;
import kd.bos.flydb.jdbc.exception.SQLException;
import kd.bos.flydb.jdbc.exception.ServerSideException;
import kd.bos.flydb.jdbc.packet.server.ErrorResponsePacket;

public final class Exceptions {
    private static String format(String pattern, Object ... args) {
        String message = pattern;
        try {
            message = MessageFormat.format(pattern, args);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!message.endsWith(".")) {
            return message + '.';
        }
        return message;
    }

    public static SQLException newUnsupportedFeature(Object ... args) {
        return Exceptions.newSQLException(ErrorCode.ClientError_UnsupportedFeature, args);
    }

    public static SQLException newSQLException(ErrorCode code, Object ... args) {
        return new SQLException(Exceptions.format(code.reason, args), "", code.vendorCode);
    }

    public static SQLException newSQLException(Throwable cause, ErrorCode code, Object ... args) {
        return new SQLException(Exceptions.format(code.reason, args), "", code.vendorCode, cause);
    }

    private static SQLException wrapNativeException(Throwable cause, int vendorCode, String message) {
        return new SQLException(message, "", vendorCode, cause);
    }

    public static ServerSideException newServerSideException(ErrorResponsePacket packet) {
        return new ServerSideException(packet.getMessage(), packet.getErrorNo());
    }

    public static IOException newIOException(ErrorCode code, Object ... args) {
        return new IOException(Exceptions.format(code.reason, args), code.vendorCode);
    }

    public static SQLException wrap(Exception e) {
        if (e instanceof ServerSideException) {
            return new SQLException(e.getMessage(), "", ((ServerSideException)e).getVendorCode());
        }
        if (e instanceof SQLException) {
            return (SQLException)e;
        }
        if (e instanceof IOException) {
            return new SQLException(e.getMessage(), "", ((IOException)e).getVendorCode());
        }
        if (e instanceof ConnectException) {
            return Exceptions.wrapNativeException(e, ErrorCode.ClientError_IOException.vendorCode, e.getMessage());
        }
        if (e instanceof java.io.IOException) {
            return Exceptions.newSQLException(e, ErrorCode.ClientError_IOException, new Object[0]);
        }
        return Exceptions.newSQLException(e, ErrorCode.ClientError_Unexpected, new Object[0]);
    }

    public static java.io.IOException wrapIOException(Exception e) {
        if (e instanceof java.io.IOException) {
            return (java.io.IOException)e;
        }
        return new java.io.IOException(e);
    }
}

