/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.jdbc.packet.client;

import java.io.IOException;
import java.nio.charset.Charset;
import kd.bos.flydb.jdbc.client.Context;
import kd.bos.flydb.jdbc.client.transfer.Writer;
import kd.bos.flydb.jdbc.packet.ClientPacket;
import kd.bos.flydb.jdbc.packet.common.ClientCommand;
import kd.bos.flydb.jdbc.packet.common.ServerCharset;

public final class HandShakeResponsePacket
implements ClientPacket {
    private final String user;
    private final String password;
    private final String account;
    private final String database;
    private final String schema;
    private final byte charsetId;
    private final Charset charset;
    private final byte[] salt;
    private final int sequenceId;

    public HandShakeResponsePacket(String user, String password, String account, String database, String schema, byte charsetId, byte[] salt, int sequenceId) {
        this.user = user;
        this.password = password;
        this.account = account;
        this.database = database;
        this.schema = schema;
        this.charsetId = charsetId;
        this.charset = ServerCharset.getCharsetById(charsetId);
        this.salt = salt;
        this.sequenceId = sequenceId;
    }

    @Override
    public int encode(Writer writer, Context context) throws IOException {
        writer.writeByte(ClientCommand.COM_ACK_RESPONSE.getCommandTypeCode());
        writer.writeByte(this.charsetId);
        writer.writeInt(this.sequenceId);
        byte[] userData = this.user == null ? System.getProperty("user.name").getBytes(this.charset) : this.user.getBytes(this.charset);
        writer.writeBytes(userData);
        writer.writeByte(0);
        byte[] authData = this.password == null ? new byte[]{} : this.password.getBytes(this.charset);
        byte[] encrypt = this.encrypt(authData, this.salt);
        writer.writeLength(encrypt.length);
        writer.writeBytes(encrypt);
        writer.writeString(this.account);
        writer.writeByte(0);
        if (this.database != null) {
            writer.writeString(this.database);
        }
        writer.writeByte(0);
        if (this.schema != null) {
            writer.writeString(this.schema);
        }
        writer.writeByte(0);
        writer.flush();
        return 1;
    }

    private byte[] encrypt(byte[] authData, byte[] salt) {
        if (authData.length <= salt.length) {
            for (int i = 0; i < authData.length; ++i) {
                int n = i;
                authData[n] = (byte)(authData[n] ^ salt[i]);
            }
        } else {
            for (int i = 0; i < salt.length; ++i) {
                int n = i;
                authData[n] = (byte)(authData[n] ^ salt[i]);
            }
        }
        return authData;
    }

    @Override
    public int getSequenceId() {
        return this.sequenceId;
    }
}

