/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.jdbc.packet.client;

import java.io.IOException;
import kd.bos.flydb.jdbc.client.Context;
import kd.bos.flydb.jdbc.client.transfer.Writer;
import kd.bos.flydb.jdbc.packet.ClientPacket;
import kd.bos.flydb.jdbc.packet.common.ClientCommand;
import kd.bos.flydb.jdbc.util.ClientParser;
import kd.bos.flydb.jdbc.util.ParameterList;

public class QueryWithParametersPacket
implements ClientPacket {
    private final ClientParser parser;
    private final ParameterList parameters;
    private final int fetchSize;
    private final int queryTimeout;
    private final String connectionId;

    public QueryWithParametersPacket(ClientParser parser, ParameterList parameters, int fetchSize, int queryTimeout, String connectionId) {
        this.parser = parser;
        this.parameters = parameters;
        this.fetchSize = fetchSize;
        this.queryTimeout = queryTimeout;
        this.connectionId = connectionId;
    }

    @Override
    public int encode(Writer writer, Context context) throws IOException {
        writer.initPacket();
        writer.writeByte(ClientCommand.COM_QUERY.getCommandTypeCode());
        writer.writeInt(this.fetchSize);
        writer.writeInt(this.queryTimeout);
        writer.writeString(this.connectionId);
        writer.writeByte(0);
        int pos = 0;
        for (int i = 0; i < this.parser.getParamPositions().size(); ++i) {
            int paramPos = this.parser.getParamPositions().get(i);
            writer.writeBytes(this.parser.getQuery(), pos, paramPos - pos);
            pos = paramPos + 1;
            this.parameters.get(i).encodeText(writer);
        }
        writer.writeBytes(this.parser.getQuery(), pos, this.parser.getQuery().length - pos);
        writer.writeByte(0);
        writer.flush();
        return 1;
    }

    @Override
    public int getSequenceId() {
        return 0;
    }
}

