/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.jdbc.packet.common;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

public enum DataType {
    INTEGER(3),
    DOUBLE(5),
    NULL(6),
    BIGINT(8),
    DATE(10),
    TIME(11),
    DATETIME(12),
    VARCHAR(15),
    BOOLEAN(244),
    DECIMAL(246);

    static final DataType[] typeMap;
    private final int type;

    private DataType(int type) {
        this.type = type;
    }

    public static int convertSqlTypes(DataType dataType) throws SQLException {
        switch (dataType) {
            case BIGINT: {
                return -5;
            }
            case BOOLEAN: {
                return 16;
            }
            case DATE: {
                return 91;
            }
            case DECIMAL: {
                return 3;
            }
            case DOUBLE: {
                return 8;
            }
            case INTEGER: {
                return 4;
            }
            case NULL: {
                return 0;
            }
            case TIME: {
                return 92;
            }
            case DATETIME: {
                return 93;
            }
            case VARCHAR: {
                return 12;
            }
        }
        throw new SQLException("Unsupported dataType:" + (Object)((Object)dataType));
    }

    public static DataType convertTypes2DataType(int type) throws SQLException {
        switch (type) {
            case -5: {
                return BIGINT;
            }
            case 16: {
                return BOOLEAN;
            }
            case 91: {
                return DATE;
            }
            case 3: {
                return DECIMAL;
            }
            case 4: {
                return INTEGER;
            }
            case 0: {
                return NULL;
            }
            case 92: {
                return TIME;
            }
            case 93: {
                return DATETIME;
            }
            case 12: {
                return VARCHAR;
            }
        }
        throw new SQLException("Unsupported sqlType:" + type);
    }

    public String getJavaTypeClassName() {
        switch (this) {
            case BIGINT: {
                return BigInteger.class.getName();
            }
            case BOOLEAN: {
                return Boolean.class.getName();
            }
            case DATE: {
                return Date.class.getName();
            }
            case DECIMAL: {
                return BigDecimal.class.getName();
            }
            case DOUBLE: {
                return Double.class.getName();
            }
            case INTEGER: {
                return Integer.class.getName();
            }
            case TIME: {
                return Time.class.getName();
            }
            case DATETIME: {
                return Timestamp.class.getName();
            }
            case VARCHAR: {
                return String.class.getName();
            }
        }
        throw new UnsupportedOperationException(this.name());
    }

    public int get() {
        return this.type;
    }

    public static DataType of(int typeValue) {
        return typeMap[typeValue];
    }

    static {
        typeMap = new DataType[256];
        DataType[] dataTypeArray = DataType.values();
        int n = dataTypeArray.length;
        for (int i = 0; i < n; ++i) {
            DataType v;
            DataType.typeMap[v.type] = v = dataTypeArray[i];
        }
    }
}

