/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.jdbc.packet.common;

import java.nio.charset.Charset;

public enum ServerCharset {
    UTF8_GENERAL_CI(0, "UTF-8"),
    GBK_GENERAL_CI(1, "GBK");

    private static final ServerCharset defaultCharset;
    private byte charsetId;
    private Charset charset;

    private ServerCharset(byte charsetId, String name) {
        this.charsetId = charsetId;
        this.charset = Charset.forName(name);
    }

    public byte getCharsetId() {
        return this.charsetId;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public static Charset getCharsetById(byte charsetId) {
        for (ServerCharset serverCharset : ServerCharset.values()) {
            if (serverCharset.charsetId != charsetId) continue;
            return serverCharset.charset;
        }
        return defaultCharset.getCharset();
    }

    static {
        defaultCharset = UTF8_GENERAL_CI;
    }
}

